/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.resourcebundle.message;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * bZ[W`[BlancoResourceBundle]Iɗp郊\[XohNXB
 *
 * \[Xoh`: [BlancoResourceBundleMessage]B<BR>
 * ̃NX̓\[Xoh`玩ꂽ\[XohNXłB<BR>
 */
class BlancoResourceBundleMessageResourceBundle {
    /**
     * \[XohIuWFNgB
     *
     * IɎۂɓ͂s\[XohL܂B
     */
    private ResourceBundle fResourceBundle;

    /**
     * BlancoResourceBundleMessageResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoResourceBundleMessage]AftHg̃P[AĂяõNX[_gpāA\[Xoh擾܂B
     */
    public BlancoResourceBundleMessageResourceBundle() {
        try {
            fResourceBundle = ResourceBundle.getBundle("blanco/resourcebundle/message/BlancoResourceBundleMessage");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BlancoResourceBundleMessageResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoResourceBundleMessage]Aw肳ꂽP[AĂяõNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     */
    public BlancoResourceBundleMessageResourceBundle(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("blanco/resourcebundle/message/BlancoResourceBundleMessage", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BlancoResourceBundleMessageResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoResourceBundleMessage]Aw肳ꂽP[Aw肳ꂽNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     * @param loader NX[_̎w
     */
    public BlancoResourceBundleMessageResourceBundle(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("blanco/resourcebundle/message/BlancoResourceBundleMessage", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * IɕێĂ郊\[XohIuWFNg擾܂B
     *
     * @return IɕێĂ郊\[XohIuWFNgB
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[BlancoResourceBundleMessage], key[MBRBI001]
     *
     * [\[X`[{0}]̃pbP[W̎w肪܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[MBRBI001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMbrbi001(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "\[X`[{0}]̃pbP[W̎w肪܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MBRBI001");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoResourceBundleMessage], key[MBRBI002]
     *
     * [\[X`[{0}]ɈقȂpbP[W̎w[{1}][{2}]܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.lang.String^^ĂB
     * @return key[MBRBI002]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMbrbi002(final String arg0, final String arg1, final String arg2) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "\[X`[{0}]ɈقȂpbP[W̎w[{1}][{2}]܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MBRBI002");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoResourceBundleMessage], key[MBRBI003]
     *
     * [قȂTtBbNX[{0}][{1}]̐ݒt@CɌ܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[MBRBI003]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMbrbi003(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "قȂTtBbNX[{0}][{1}]̐ݒt@CɌ܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MBRBI003");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoResourceBundleMessage], key[MBRBI004]
     *
     * [\[X`[{0}]̃P[̎w肪܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[MBRBI004]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMbrbi004(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "\[X`[{0}]̃P[̎w肪܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MBRBI004");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoResourceBundleMessage], key[MBRBI005]
     *
     * [ꖼ[{0}] ͊ɃP[[{1}]ŏĂ܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[MBRBI005]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMbrbi005(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "ꖼ[{0}] ͊ɃP[[{1}]ŏĂ܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MBRBI005");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoResourceBundleMessage], key[MBRBI006]
     *
     * [\[Xoh`[{0}]̃P[[{1}]dĒ`Ă܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[MBRBI006]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMbrbi006(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "\[Xoh`[{0}]̃P[[{1}]dĒ`Ă܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MBRBI006");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoResourceBundleMessage], key[MBRBI007]
     *
     * [\[Xoh`[{0}]̃P[[{1}]̃\[XID[{2}]dĒ`Ă܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.lang.String^^ĂB
     * @return key[MBRBI007]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMbrbi007(final String arg0, final String arg1, final String arg2) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "\[Xoh`[{0}]̃P[[{1}]̃\[XID[{2}]dĒ`Ă܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MBRBI007");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoResourceBundleMessage], key[MBRBI008]
     *
     * [ꖼ[{0}] P[[{1}] L[[{2}] [{3}]̉͂Ɏs܂B񂪕sł\܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.lang.String^^ĂB
     * @param arg3 u{3}ulBjava.lang.String^^ĂB
     * @return key[MBRBI008]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMbrbi008(final String arg0, final String arg1, final String arg2, final String arg3) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "ꖼ[{0}] P[[{1}] L[[{2}] [{3}]̉͂Ɏs܂B񂪕sł\܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MBRBI008");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2, arg3}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoResourceBundleMessage], key[MBRBI009]
     *
     * [\[Xoh`[{0}]̃P[[{1}]̃\[XID[{2}]̃bZ[Wɂăp[^̎w肪({3})܂A܂ŌĂɂ̓p[^̎w肪܂łB] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.lang.String^^ĂB
     * @param arg3 u{3}ulBjava.lang.String^^ĂB
     * @return key[MBRBI009]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMbrbi009(final String arg0, final String arg1, final String arg2, final String arg3) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "\[Xoh`[{0}]̃P[[{1}]̃\[XID[{2}]̃bZ[Wɂăp[^̎w肪({3})܂A܂ŌĂɂ̓p[^̎w肪܂łB";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MBRBI009");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2, arg3}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoResourceBundleMessage], key[MBRBI010]
     *
     * [\[Xoh`[{0}]̃P[[{1}]̃\[XID[{2}]̃bZ[Wɂăp[^̎w肪܂񂪁A܂ŌĂɂ({3})̃p[^̎w肪܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.lang.String^^ĂB
     * @param arg3 u{3}ulBjava.lang.String^^ĂB
     * @return key[MBRBI010]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMbrbi010(final String arg0, final String arg1, final String arg2, final String arg3) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "\[Xoh`[{0}]̃P[[{1}]̃\[XID[{2}]̃bZ[Wɂăp[^̎w肪܂񂪁A܂ŌĂɂ({3})̃p[^̎w肪܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MBRBI010");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2, arg3}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoResourceBundleMessage], key[MBRBI011]
     *
     * [\[Xoh`[{0}]̃P[[{1}]̃\[XID[{2}]̃bZ[Wɂp[^̐({3})A܂ŌĂp[^̐({4})ƈv܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.lang.String^^ĂB
     * @param arg3 u{3}ulBjava.lang.String^^ĂB
     * @param arg4 u{4}ulBjava.lang.String^^ĂB
     * @return key[MBRBI011]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMbrbi011(final String arg0, final String arg1, final String arg2, final String arg3, final String arg4) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "\[Xoh`[{0}]̃P[[{1}]̃\[XID[{2}]̃bZ[Wɂp[^̐({3})A܂ŌĂp[^̐({4})ƈv܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MBRBI011");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2, arg3, arg4}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoResourceBundleMessage], key[MBRBI012]
     *
     * [\[Xoh`[{0}]̃P[[{1}]̃\[XID[{2}]̃bZ[Wɂp[^̌^({3})A܂ŌĂp[^̌^({4})ƈv܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.lang.String^^ĂB
     * @param arg3 u{3}ulBjava.lang.String^^ĂB
     * @param arg4 u{4}ulBjava.lang.String^^ĂB
     * @return key[MBRBI012]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMbrbi012(final String arg0, final String arg1, final String arg2, final String arg3, final String arg4) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "\[Xoh`[{0}]̃P[[{1}]̃\[XID[{2}]̃bZ[Wɂp[^̌^({3})A܂ŌĂp[^̌^({4})ƈv܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MBRBI012");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2, arg3, arg4}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoResourceBundleMessage], key[MBRBA001]
     *
     * [wmetadir[{0}]܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[MBRBA001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMbrba001(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "wmetadir[{0}]܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MBRBA001");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }
}
