/*******************************************************************************
 * Copyright (c) 2010 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2004-2010 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.service.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

import blanco.plugin.service.BlancoServicePlugin;
import blanco.plugin.service.BlancoServicePluginConstants;
import blanco.plugin.service.editors.BlancoServicePluginUtil;
import blanco.service.BlancoServiceConstants;
import blanco.service.resourcebundle.BlancoServiceResourceBundle;
import blanco.service.task.BlancoServiceProcessImpl;
import blanco.service.task.valueobject.BlancoServiceProcessInput;

public class BlancoServiceGenerateAction {
    private static final BlancoServiceResourceBundle fBundle = new BlancoServiceResourceBundle();

    /**
     * \[XR[hs܂B
     * 
     * @param ifile
     *            Ώۂ̃t@CB
     * @param shell
     *            ẽVFB
     * @param workbenchMonitor
     *            [Nx`j^B
     * @param metaDir
     *            ^fBNgB
     * @throws InvocationTargetException
     *             s̗OB
     * @throws InterruptedException
     *             荞ݗOB
     * @throws CoreException
     */
    public static final void processBlancoServiceSource(final IFile ifile,
            final Shell shell, IProgressMonitor workbenchMonitor,
            final String metaDir) throws InvocationTargetException,
            InterruptedException, CoreException {
        if (ifile.getProject().getFolder(metaDir).exists() == false) {
            MessageDialog.openWarning(shell, "\[XR[h", "^fBNg (" + metaDir
                    + ") ݂܂B𒆒f܂B");
            return;
        }

        // Eclipse 3.3 ΍: begin
        // workbenchMonitor𗘗p邱Ƃ~܂B
        // org.eclipse.swt.SWTException: Invalid thread access Ă܂܂B
        // Eclipse 3.3 ΍: end

        final BlancoServiceProcessInput input = new BlancoServiceProcessInput();

        // Eclipse vOC̏̃[ɏ]Ď\[XR[h̕GR[fBOB
        final String encoding = ifile.getProject().getDefaultCharset(true);
        input.setEncoding(encoding);

        try {
            // PlatformUI.getWorkbench().getProgressService()LvƔfB
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(
                    new IRunnableWithProgress() {
                        public void run(final IProgressMonitor monitor)
                                throws InvocationTargetException,
                                InterruptedException {
                            try {
                                monitor.beginTask(
                                        BlancoServiceConstants.PRODUCT_NAME
                                                + "\[XR[h", 10);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("fBNg: e|tH_̒B");

                                // e|tH_U폜܂B
                                BlancoServicePluginUtil
                                        .deleteFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoServiceConstants.TARGET_SUBDIRECTORY);
                                BlancoServicePluginUtil
                                        .createFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoServiceConstants.TARGET_SUBDIRECTORY);
                                final IFolder tempFolder = BlancoServicePluginUtil
                                        .findFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoServiceConstants.TARGET_SUBDIRECTORY);

                                // hLgꗗ̂߂̒ԃt@CpfBNgB
                                final File blancoTempDirectoryDocListing = ifile
                                        .getProject().getFolder(
                                                "tmp/doclisting").getLocation()
                                        .toFile();
                                blancoTempDirectoryDocListing.mkdirs();

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask(fBundle
                                        .getMetafileDisplayname()
                                        + " (*.xls)܂");
                                monitor.worked(1);

                                final IFolder findFolder = BlancoServicePluginUtil
                                        .findFolder(ifile, monitor, metaDir);
                                findFolder.refreshLocal(
                                        IResource.DEPTH_INFINITE, monitor);

                                IFolder folderTargetDirectory = ifile
                                        .getProject().getFolder("blanco");
                                if (ifile.getProject().getFolder(metaDir)
                                        .exists() == false) {
                                    folderTargetDirectory.create(true, true,
                                            monitor);
                                }

                                monitor.subTask("tH_쐬: " + "blanco"
                                        + "/maintH_");
                                final IFolder folderTargetDirectoryWithMain = folderTargetDirectory
                                        .getFolder("main");
                                if (ifile.getProject().getFolder(metaDir)
                                        .exists() == false) {
                                    folderTargetDirectoryWithMain.create(true,
                                            true, monitor);
                                }

                                final File blancoTargetDirectory = folderTargetDirectory
                                        .getLocation().toFile();

                                input.setMetadir(findFolder.getLocation()
                                        .toFile().getAbsolutePath());
                                input.setTmpdir(tempFolder.getLocation()
                                        .toFile().getAbsolutePath());
                                input.setTargetdir(blancoTargetDirectory
                                        .getAbsolutePath());

                                final BlancoServiceProcessImpl impl = new BlancoServiceProcessImpl() {
                                    public boolean progress(
                                            final String argProgressMessage) {
                                        if (monitor.isCanceled()) {
                                            // f܂B
                                            return true;
                                        }
                                        monitor.subTask(argProgressMessage);
                                        return false;
                                    }
                                };
                                impl.execute(input);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("tH_XV: tmptH_");
                                monitor.worked(1);

                                tempFolder.refreshLocal(
                                        IResource.DEPTH_INFINITE, monitor);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                folderTargetDirectory.refreshLocal(
                                        IResource.DEPTH_INFINITE, monitor);

                                if (BlancoServicePluginConstants.IS_DEBUG) {
                                    Thread.sleep(1000);
                                }
                            } catch (Exception e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } catch (Error e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } finally {
                                // Ō̍Ōł doneƂ܂B
                                monitor.done();
                            }
                        }
                    });
        } catch (InvocationTargetException ex) {
            BlancoServicePlugin.log(ex);
            // O̒{̌oƂ|CgłB
            MessageDialog.openWarning(shell, "\[XR[h",
                    "O܂B𒆒f܂B\n" + ex.getCause().toString());
            ex.printStackTrace();
        } catch (InterruptedException ex) {
            BlancoServicePlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "荞ݒfO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Exception ex) {
            BlancoServicePlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʗO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Error er) {
            BlancoServicePlugin.log(er);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʃG[܂B𒆒f܂B\n" + er.toString());
            er.printStackTrace();
        }
    }
}