/*******************************************************************************
 * Copyright (c) 2010 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2004-2010 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.service.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.service.BlancoServiceConstants;
import blanco.service.BlancoServiceMeta2Xml;
import blanco.service.BlancoServiceXml2SourceFile;
import blanco.service.resourcebundle.BlancoServiceResourceBundle;
import blanco.service.task.valueobject.BlancoServiceProcessInput;

public class BlancoServiceProcessImpl implements BlancoServiceProcess {
    /**
     * ̃v_Ng̃\[Xohւ̃ANZXIuWFNgB
     */
    private final BlancoServiceResourceBundle fBundle = new BlancoServiceResourceBundle();

    /**
     * {@inheritDoc}
     */
    public int execute(final BlancoServiceProcessInput input)
            throws IOException, IllegalArgumentException {
        System.out.println("- " + BlancoServiceConstants.PRODUCT_NAME + " ("
                + BlancoServiceConstants.VERSION + ")");

        try {
            final File fileMetadir = new File(input.getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException(fBundle
                        .getAnttaskErr001(input.getMetadir()));
            }

            // e|fBNg쐬B
            new File(input.getTmpdir()
                    + BlancoServiceConstants.TARGET_SUBDIRECTORY).mkdirs();

            // w肳ꂽ^fBNg܂B
            new BlancoServiceMeta2Xml().processDirectory(fileMetadir, input
                    .getTmpdir()
                    + BlancoServiceConstants.TARGET_SUBDIRECTORY);

            // XMLꂽԃt@C\[XR[h𐶐
            final File[] fileMeta2 = new File(input.getTmpdir()
                    + BlancoServiceConstants.TARGET_SUBDIRECTORY).listFiles();
            for (int index = 0; index < fileMeta2.length; index++) {
                if (fileMeta2[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                new BlancoServiceXml2SourceFile().process(input,
                        fileMeta2[index]);
            }
        } catch (IOException ex) {
            throw new IllegalArgumentException(ex.toString());
        } catch (TransformerException ex) {
            throw new IllegalArgumentException(ex.toString());
        } catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            throw ex;
        }

        return 0;
    }

    /**
     * {@inheritDoc}
     */
    public boolean progress(final String argProgressMessage) {
        System.out.println(argProgressMessage);
        return false;
    }

}
