/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.internal.databinding.BindingMessages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public final class AggregateValidationStatus
implements IObservableValue {
    private IObservableValue implementation;
    public static final int MERGED = 1;
    public static final int MAX_SEVERITY = 2;
    static /* synthetic */ Class class$0;

    public AggregateValidationStatus(DataBindingContext dbc, int strategy) {
        this(dbc.getValidationRealm(), dbc.getValidationStatusProviders(), strategy);
    }

    public AggregateValidationStatus(IObservableCollection validationStatusProviders, int strategy) {
        this(Realm.getDefault(), validationStatusProviders, strategy);
    }

    public AggregateValidationStatus(Realm realm, final IObservableCollection validationStatusProviders, int strategy) {
        if (strategy == 1) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.runtime.IStatus");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.implementation = new ComputedValue(realm, clazz){

                protected Object calculate() {
                    return AggregateValidationStatus.getStatusMerged(validationStatusProviders);
                }
            };
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.runtime.IStatus");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.implementation = new ComputedValue(realm, clazz){

                protected Object calculate() {
                    return AggregateValidationStatus.getStatusMaxSeverity(validationStatusProviders);
                }
            };
        }
    }

    public void addChangeListener(IChangeListener listener) {
        this.implementation.addChangeListener(listener);
    }

    public void addStaleListener(IStaleListener listener) {
        this.implementation.addStaleListener(listener);
    }

    public void addValueChangeListener(IValueChangeListener listener) {
        this.implementation.addValueChangeListener(listener);
    }

    public void dispose() {
        this.implementation.dispose();
    }

    public Realm getRealm() {
        return this.implementation.getRealm();
    }

    public Object getValue() {
        return this.implementation.getValue();
    }

    public Object getValueType() {
        return this.implementation.getValueType();
    }

    public boolean isStale() {
        return this.implementation.isStale();
    }

    public void removeChangeListener(IChangeListener listener) {
        this.implementation.removeChangeListener(listener);
    }

    public void removeStaleListener(IStaleListener listener) {
        this.implementation.removeStaleListener(listener);
    }

    public void removeValueChangeListener(IValueChangeListener listener) {
        this.implementation.removeValueChangeListener(listener);
    }

    public void setValue(Object value) {
        this.implementation.setValue(value);
    }

    public static IStatus getStatusMerged(Collection validationStatusProviders) {
        IStatus status;
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        Iterator it = validationStatusProviders.iterator();
        while (it.hasNext()) {
            ValidationStatusProvider validationStatusProvider = (ValidationStatusProvider)it.next();
            status = (IStatus)validationStatusProvider.getValidationStatus().getValue();
            if (status.isOK()) continue;
            statuses.add(status);
        }
        if (statuses.size() == 1) {
            return (IStatus)statuses.get(0);
        }
        if (!statuses.isEmpty()) {
            MultiStatus result = new MultiStatus("org.eclipse.core.databinding", 0, BindingMessages.getString("MultipleProblems"), null);
            Iterator it2 = statuses.iterator();
            while (it2.hasNext()) {
                status = (IStatus)it2.next();
                result.merge(status);
            }
            return result;
        }
        return Status.OK_STATUS;
    }

    public static IStatus getStatusMaxSeverity(Collection validationStatusProviders) {
        int maxSeverity = 0;
        IStatus maxStatus = Status.OK_STATUS;
        Iterator it = validationStatusProviders.iterator();
        while (it.hasNext()) {
            ValidationStatusProvider validationStatusProvider = (ValidationStatusProvider)it.next();
            IStatus status = (IStatus)validationStatusProvider.getValidationStatus().getValue();
            if (status.getSeverity() <= maxSeverity) continue;
            maxSeverity = status.getSeverity();
            maxStatus = status;
        }
        return maxStatus;
    }
}

