/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.registerer;

import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileListDialog
extends Dialog {
    CheckboxTableViewer tblview = null;
    ArrayList<String> extensions = new ArrayList();
    ArrayList<String> fileitems = new ArrayList();
    ArrayList<String> selecteditems = new ArrayList();
    FileContentProvider contentprovider = null;
    FileLabelProvider labelprovider = null;
    TableColumn filetc = null;

    void setDefaultChecked() {
        int i = 0;
        while (i < this.fileitems.size()) {
            String ext = FilenameUtils.getExtension((String)this.fileitems.get(i)).toLowerCase();
            this.tblview.setChecked((Object)this.fileitems.get(i), this.extensions.contains(ext));
            ++i;
        }
    }

    void clearAllChecked() {
        this.tblview.setAllChecked(false);
    }

    void allChecked() {
        this.tblview.setAllChecked(true);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Select files to be registered");
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        parent.setLayout((Layout)gl);
        Group base = new Group(parent, 0);
        base.setLayout((Layout)new GridLayout(2, false));
        base.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tblview = CheckboxTableViewer.newCheckList((Composite)base, (int)66304);
        Table tbl = this.tblview.getTable();
        tbl.setLayout((Layout)new GridLayout(1, false));
        tbl.setLayoutData((Object)new GridData(4, 4, true, true));
        tbl.setHeaderVisible(true);
        tbl.setLinesVisible(true);
        this.filetc = new TableColumn(tbl, 16384);
        this.filetc.setText("File");
        this.filetc.setResizable(true);
        this.filetc.setMoveable(false);
        this.filetc.setWidth(400);
        this.contentprovider = new FileContentProvider();
        this.tblview.setContentProvider((IContentProvider)this.contentprovider);
        this.labelprovider = new FileLabelProvider();
        this.labelprovider.setShowFullPath(true);
        this.tblview.setLabelProvider((IBaseLabelProvider)this.labelprovider);
        Composite btncomp = new Composite((Composite)base, 0);
        btncomp.setLayout((Layout)new GridLayout(1, false));
        btncomp.setLayoutData((Object)new GridData(0x1000000, 4, false, true));
        Button btn1 = new Button(btncomp, 0);
        btn1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        btn1.setText("Select all");
        btn1.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileListDialog.this.allChecked();
                FileListDialog.this.tblview.refresh();
            }
        });
        Button btn2 = new Button(btncomp, 0);
        btn2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        btn2.setText("Clear");
        btn2.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileListDialog.this.clearAllChecked();
                FileListDialog.this.tblview.refresh();
            }
        });
        Button btn3 = new Button(btncomp, 0);
        btn3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        btn3.setText("Set default");
        btn3.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileListDialog.this.setDefaultChecked();
                FileListDialog.this.tblview.refresh();
            }
        });
        Button btn4 = new Button(btncomp, 0);
        btn4.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        btn4.setText("Filename only");
        btn4.setData("fullpath", (Object)true);
        btn4.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Button bt = (Button)e.widget;
                Boolean fp = (Boolean)bt.getData("fullpath");
                FileListDialog.this.labelprovider.setShowFullPath(fp == false);
                bt.setText(fp != false ? "Fullpath" : "Filename only");
                bt.setData("fullpath", (Object)(fp == false ? 1 : 0));
                FileListDialog.this.tblview.refresh();
            }
        });
        this.tblview.setInput(this.fileitems);
        this.setDefaultChecked();
        parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent arg0) {
            }

            public void controlResized(ControlEvent arg0) {
                Table tbl = FileListDialog.this.tblview.getTable();
                int w = tbl.getSize().x - 15;
                if (w > 0) {
                    FileListDialog.this.filetc.setWidth(w);
                }
            }
        });
        return base;
    }

    protected void initializeBounds() {
        this.getShell().setSize(480, 480);
    }

    public FileListDialog(Shell parentShell) {
        super(new Shell(parentShell));
        this.setShellStyle(2160);
    }

    public void setCheckExtension(ArrayList<String> exts) {
        this.extensions.addAll(exts);
    }

    public void setFiles(ArrayList<String> files) {
        this.fileitems.addAll(files);
    }

    public ArrayList<String> getFilesToBeRegistered() {
        return this.selecteditems;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            Object[] elems = this.tblview.getCheckedElements();
            int i = 0;
            while (i < elems.length) {
                this.selecteditems.add((String)elems[i]);
                ++i;
            }
        } else {
            this.selecteditems.clear();
        }
        super.buttonPressed(buttonId);
    }

    private class FileContentProvider
    implements IStructuredContentProvider {
        private FileContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((ArrayList)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class FileLabelProvider
    implements ITableLabelProvider {
        private boolean fullpath = true;

        private FileLabelProvider() {
        }

        public void setShowFullPath(boolean fullpath) {
            this.fullpath = fullpath;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.fullpath ? (String)element : FilenameUtils.getName((String)((String)element));
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

