/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.registerer.preferences;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.concierge.plugin.RegistererPlugin;
import jp.sourceforge.concierge.plugin.registerer.preferences.ConditionDialog;
import jp.sourceforge.concierge.plugin.registerer.preferences.DirEntry;
import jp.sourceforge.concierge.plugin.registerer.preferences.DirStatusDialog;
import jp.sourceforge.concierge.plugin.registerer.preferences.DistCondition;
import jp.sourceforge.concierge.plugin.registerer.preferences.ExtensionElement;
import jp.sourceforge.concierge.plugin.registerer.preferences.ExtensionEntry;
import jp.sourceforge.concierge.plugin.registerer.preferences.RegexUtils;
import jp.sourceforge.concierge.widget.TextInputDialog;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistererPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static String numberCharacters = "0123456789";
    private TreeViewer tableview = null;
    private ArrayList<DirEntry> direntries = null;
    private TreeViewer exttree = null;
    private ExtensionEntry extimages = null;
    private ExtensionEntry extsources = null;
    private ExtensionEntry extdocuments = null;
    private ExtensionEntry extothers = null;
    private Image dirplus = RegistererPlugin.getImageDescriptor("icons/dirplus.png").createImage();
    private Image dirminus = RegistererPlugin.getImageDescriptor("icons/dirminus.png").createImage();
    private Image dirminusg = RegistererPlugin.getImageDescriptor("icons/dirminus_g.png").createImage();
    private ToolItem additem = null;
    private ToolItem delitem = null;
    private Action addDirAction = null;
    private Action addTypeAction = null;
    private Action delAction = null;
    private Action editAction = null;
    private Action upAction = null;
    private Action downAction = null;

    public RegistererPreferencePage() {
        super("Registerer");
        this.setPreferenceStore(RegistererPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        super.dispose();
    }

    public boolean performOk() {
        this.DoSave();
        RegistererPlugin.getDefault().monitoringDirectory();
        return super.performOk();
    }

    protected void performDefaults() {
    }

    protected void contributeButtons(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.numColumns = 1;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Button myApplyButton = new Button(parent, 8);
        String[] labels = JFaceResources.getStrings((String[])new String[]{"Apply"});
        myApplyButton.setText(labels[0]);
        Dialog.applyDialogFont((Control)myApplyButton);
        GridData data = new GridData(256);
        Point minButtonSize = myApplyButton.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minButtonSize.x);
        myApplyButton.setLayoutData((Object)data);
        myApplyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RegistererPreferencePage.this.performApply();
            }
        });
        myApplyButton.setEnabled(this.isValid());
        this.applyDialogFont(parent);
    }

    private void DoSave() {
        String extvalue = this.extimages.toString();
        if (extvalue.length() > 0) {
            extvalue = String.valueOf(extvalue) + ",";
        }
        if ((extvalue = String.valueOf(extvalue) + this.extdocuments.toString()).length() > 0) {
            extvalue = String.valueOf(extvalue) + ",";
        }
        if ((extvalue = String.valueOf(extvalue) + this.extsources.toString()).length() > 0) {
            extvalue = String.valueOf(extvalue) + ",";
        }
        extvalue = String.valueOf(extvalue) + this.extothers.toString();
        this.getPreferenceStore().setValue("filter", extvalue);
        int numofitems = this.direntries.size();
        this.getPreferenceStore().setValue("numoffolders", numofitems);
        int i = 0;
        while (i < numofitems) {
            DirEntry de = this.direntries.get(i);
            this.getPreferenceStore().setValue("folder" + i, de.dirname);
            this.getPreferenceStore().setValue("subdir" + i, de.subdir);
            this.getPreferenceStore().setValue("monitor" + i, de.monitor);
            ArrayList<DistCondition> dc = de.getCondition();
            this.getPreferenceStore().setValue("folder" + i + "numofconditions", dc.size());
            int j = 0;
            while (j < dc.size()) {
                this.getPreferenceStore().setValue("folder" + i + "type" + j, dc.get((int)j).type);
                this.getPreferenceStore().setValue("folder" + i + "regex" + j, dc.get((int)j).regex);
                ++j;
            }
            ++i;
        }
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createDirectorySettingComposite(composite);
        this.createFileFilterSettingComposite(composite);
        return composite;
    }

    private static ArrayList<DirEntry> initializeEntries() {
        IPreferenceStore store = RegistererPlugin.getDefault().getPreferenceStore();
        int sz = store.getInt("numoffolders");
        ArrayList<DirEntry> list = new ArrayList<DirEntry>();
        int i = 0;
        while (i < sz) {
            String name = store.getString("folder" + i);
            boolean subdir = store.getBoolean("subdir" + i);
            boolean monitor = store.getBoolean("monitor" + i);
            DirEntry de = new DirEntry(name, subdir, monitor);
            int csz = store.getInt("folder" + i + "numofconditions");
            int j = 0;
            while (j < csz) {
                String type = store.getString("folder" + i + "type" + j);
                String regex = store.getString("folder" + i + "regex" + j);
                de.setCondition(regex, type);
                ++j;
            }
            list.add(de);
            ++i;
        }
        if (list.size() == 0) {
            list.add(new DirEntry("[MANUAL]", false, false));
        }
        return list;
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.addDirAction);
        manager.add((IAction)this.addTypeAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.editAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.delAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.upAction);
        manager.add((IAction)this.downAction);
    }

    private void setContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RegistererPreferencePage.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.tableview.getTree());
        this.tableview.getTree().setMenu(menu);
    }

    private void createDirectorySettingComposite(Composite parent) {
        Group dirComposite = new Group(parent, 0);
        dirComposite.setText("Register monitor directories");
        dirComposite.setLayoutData((Object)new GridData(1808));
        dirComposite.setLayout((Layout)new GridLayout(1, false));
        this.addDirAction = new Action(){

            public void run() {
                DirectoryDialog dd = new DirectoryDialog(RegistererPreferencePage.this.tableview.getTree().getShell());
                dd.setText("Select Monitoring Directory");
                String path = dd.open();
                if (path == null) {
                    return;
                }
                int i = 0;
                while (i < RegistererPreferencePage.this.direntries.size()) {
                    DirEntry de = (DirEntry)RegistererPreferencePage.this.direntries.get(i);
                    if (de.dirname.equals(path)) {
                        return;
                    }
                    ++i;
                }
                DirEntry de = new DirEntry(path, false, true);
                de.setCondition(".*", "Unclassified");
                RegistererPreferencePage.this.direntries.add(de);
                RegistererPreferencePage.this.tableview.refresh();
            }
        };
        this.addDirAction.setText("Add directory");
        this.delAction = new Action(){

            public void run() {
                Object o;
                IStructuredSelection sel = (IStructuredSelection)RegistererPreferencePage.this.tableview.getSelection();
                if (sel.size() == 0) {
                    return;
                }
                if (sel.size() == 1 && (o = sel.getFirstElement()) instanceof DirEntry && ((DirEntry)o).dirname.equals("[MANUAL]")) {
                    return;
                }
                if (!MessageDialog.openConfirm((Shell)RegistererPreferencePage.this.tableview.getTree().getShell(), (String)"Delete", (String)"Delete OK?")) {
                    return;
                }
                for (Object o2 : sel) {
                    if (o2 instanceof DirEntry) {
                        DirEntry de = (DirEntry)o2;
                        if (de.dirname.equals("[MANUAL]")) continue;
                        RegistererPreferencePage.this.direntries.remove(de);
                        continue;
                    }
                    if (!(o2 instanceof DistCondition)) continue;
                    DistCondition dc = (DistCondition)o2;
                    ((DirEntry)dc.parent).condition.remove(dc);
                }
                RegistererPreferencePage.this.tableview.refresh();
            }
        };
        this.delAction.setText("Delete");
        this.addTypeAction = new Action(){

            public void run() {
                IStructuredSelection sel = (IStructuredSelection)RegistererPreferencePage.this.tableview.getSelection();
                if (sel.size() != 1) {
                    return;
                }
                Object o = sel.getFirstElement();
                DirEntry de = null;
                if (o instanceof DirEntry) {
                    de = (DirEntry)o;
                } else if (o instanceof DistCondition) {
                    de = (DirEntry)((DistCondition)o).parent;
                } else {
                    return;
                }
                ConditionDialog cd = new ConditionDialog(RegistererPreferencePage.this.tableview.getTree().getShell(), null, null, true);
                if (cd.open() != 0) {
                    return;
                }
                de.setCondition(cd.getRegex(), cd.getType());
                RegistererPreferencePage.this.tableview.refresh();
            }
        };
        this.addTypeAction.setText("Add type/reg exp.");
        this.editAction = new Action(){

            public void run() {
                IStructuredSelection sel = (IStructuredSelection)RegistererPreferencePage.this.tableview.getSelection();
                if (sel.size() != 1) {
                    return;
                }
                Object o = sel.getFirstElement();
                if (o instanceof DirEntry) {
                    DirEntry de = (DirEntry)o;
                    DirStatusDialog ds = new DirStatusDialog(RegistererPreferencePage.this.tableview.getTree().getShell(), de.monitor, de.subdir);
                    if (ds.open() != 0) {
                        return;
                    }
                    de.monitor = ds.getMonitor();
                    de.subdir = ds.getSubdir();
                    RegistererPreferencePage.this.tableview.refresh();
                } else if (o instanceof DistCondition) {
                    DistCondition dc = (DistCondition)o;
                    boolean editable = true;
                    ConditionDialog cd = new ConditionDialog(RegistererPreferencePage.this.tableview.getTree().getShell(), dc.type, dc.regex, editable);
                    if (cd.open() != 0) {
                        return;
                    }
                    dc.type = cd.getType();
                    dc.regex = cd.getRegex();
                    RegistererPreferencePage.this.tableview.refresh();
                }
            }
        };
        this.editAction.setText("Edit");
        this.upAction = new Action(){

            public void run() {
                IStructuredSelection sel = (IStructuredSelection)RegistererPreferencePage.this.tableview.getSelection();
                if (sel.size() != 1) {
                    return;
                }
                Object o = sel.getFirstElement();
                if (!(o instanceof DistCondition)) {
                    return;
                }
                DistCondition dc = (DistCondition)o;
                DirEntry de = (DirEntry)dc.parent;
                int idx = de.condition.indexOf(dc);
                if (idx <= 0) {
                    return;
                }
                DistCondition pdc = de.condition.get(idx - 1);
                de.condition.set(idx - 1, dc);
                de.condition.set(idx, pdc);
                RegistererPreferencePage.this.tableview.refresh();
            }
        };
        this.upAction.setText("Up");
        this.downAction = new Action(){

            public void run() {
                IStructuredSelection sel = (IStructuredSelection)RegistererPreferencePage.this.tableview.getSelection();
                if (sel.size() != 1) {
                    return;
                }
                Object o = sel.getFirstElement();
                if (!(o instanceof DistCondition)) {
                    return;
                }
                DistCondition dc = (DistCondition)o;
                DirEntry de = (DirEntry)dc.parent;
                int idx = de.condition.indexOf(dc);
                if (idx < 0 || idx == de.condition.size() - 1) {
                    return;
                }
                DistCondition ndc = de.condition.get(idx + 1);
                de.condition.set(idx + 1, dc);
                de.condition.set(idx, ndc);
                RegistererPreferencePage.this.tableview.refresh();
            }
        };
        this.downAction.setText("Down");
        ToolBar tb = new ToolBar((Composite)dirComposite, 0);
        tb.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.additem = new ToolItem(tb, 0);
        this.additem.setImage(this.dirplus);
        this.additem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                RegistererPreferencePage.this.addDirAction.run();
            }
        });
        this.delitem = new ToolItem(tb, 0);
        this.delitem.setImage(this.dirminus);
        this.delitem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (RegistererPreferencePage.this.delAction.isEnabled()) {
                    RegistererPreferencePage.this.delAction.run();
                }
            }
        });
        this.tableview = new TreeViewer((Composite)dirComposite, 66304);
        this.tableview.getTree().setLayoutData((Object)new GridData(1808));
        this.tableview.getTree().setHeaderVisible(true);
        this.tableview.getTree().setLinesVisible(true);
        this.tableview.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Tree table = (Tree)e.getSource();
                Rectangle r = table.getClientArea();
                TreeColumn[] col = table.getColumns();
                if (!$assertionsDisabled && col.length != 2) {
                    throw new AssertionError();
                }
                col[0].setWidth(r.width - col[1].getWidth());
            }
        });
        TreeColumn tc = null;
        tc = new TreeColumn(this.tableview.getTree(), 16384);
        tc.setText("Directory/Regular exp.");
        tc.setWidth(250);
        tc.setMoveable(false);
        tc.setResizable(true);
        tc.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                TreeColumn tc = (TreeColumn)e.getSource();
                Tree table = tc.getParent();
                Rectangle r = table.getClientArea();
                TreeColumn[] col = table.getColumns();
                if (!$assertionsDisabled && col.length != 2) {
                    throw new AssertionError();
                }
                col[1].setWidth(r.width - tc.getWidth());
            }
        });
        tc = new TreeColumn(this.tableview.getTree(), 16384);
        tc.setText("");
        tc.setWidth(250);
        tc.setMoveable(false);
        tc.setResizable(false);
        this.tableview.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RegistererPreferencePage.this.addDirAction.setEnabled(true);
                RegistererPreferencePage.this.addTypeAction.setEnabled(true);
                RegistererPreferencePage.this.delAction.setEnabled(true);
                RegistererPreferencePage.this.editAction.setEnabled(true);
                RegistererPreferencePage.this.delitem.setImage(RegistererPreferencePage.this.dirminus);
                IStructuredSelection sel = (IStructuredSelection)RegistererPreferencePage.this.tableview.getSelection();
                if (sel == null || sel.size() != 1) {
                    RegistererPreferencePage.this.addTypeAction.setEnabled(false);
                    RegistererPreferencePage.this.delAction.setEnabled(false);
                    RegistererPreferencePage.this.editAction.setEnabled(false);
                    RegistererPreferencePage.this.delitem.setImage(RegistererPreferencePage.this.dirminusg);
                    return;
                }
                Object o = sel.getFirstElement();
                if (o instanceof DirEntry) {
                    DirEntry de = (DirEntry)o;
                    if (de.dirname.equals(".*")) {
                        RegistererPreferencePage.this.editAction.setEnabled(false);
                        RegistererPreferencePage.this.delAction.setEnabled(false);
                        RegistererPreferencePage.this.delitem.setImage(RegistererPreferencePage.this.dirminusg);
                        return;
                    }
                }
            }
        });
        this.tableview.getTree().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                if (RegistererPreferencePage.this.editAction.isEnabled()) {
                    RegistererPreferencePage.this.editAction.run();
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.tableview.setColumnProperties(new String[]{"Directory", "Monitor", "Subdir", "Regular exp.", "Type"});
        this.setContextMenu();
        this.direntries = RegistererPreferencePage.initializeEntries();
        this.tableview.setContentProvider((IContentProvider)new DirContentProvider());
        this.tableview.setLabelProvider((IBaseLabelProvider)new DirLabelProvider());
        this.tableview.setInput(this.direntries);
    }

    private ExtensionEntry getSelectedType() {
        IStructuredSelection s = (IStructuredSelection)this.exttree.getSelection();
        if (s == null || s.isEmpty()) {
            return null;
        }
        Object elem = s.getFirstElement();
        if (elem instanceof ExtensionEntry) {
            return (ExtensionEntry)elem;
        }
        if (elem instanceof ExtensionElement) {
            return (ExtensionEntry)((ExtensionElement)elem).getParent();
        }
        return null;
    }

    private ExtensionElement getSelectedExtension() {
        IStructuredSelection s = (IStructuredSelection)this.exttree.getSelection();
        if (s == null || s.isEmpty()) {
            return null;
        }
        Object elem = s.getFirstElement();
        if (elem instanceof ExtensionElement) {
            return (ExtensionElement)elem;
        }
        return null;
    }

    private void createFileFilterSettingComposite(Composite parent) {
        Group ffComposite = new Group(parent, 0);
        ffComposite.setText("File extensions of files to be registered");
        ffComposite.setLayoutData((Object)new GridData(1808));
        ffComposite.setLayout((Layout)new GridLayout(2, false));
        this.exttree = new TreeViewer((Composite)ffComposite, 66304);
        this.exttree.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.exttree.getTree().setHeaderVisible(true);
        this.exttree.getTree().setLinesVisible(true);
        TreeColumn tc = new TreeColumn(this.exttree.getTree(), 16384);
        tc.setWidth(200);
        tc.setResizable(true);
        tc.setText("type");
        tc = new TreeColumn(this.exttree.getTree(), 16384);
        tc.setWidth(200);
        tc.setResizable(true);
        tc.setText("extension");
        Composite btncomp = new Composite((Composite)ffComposite, 0);
        btncomp.setLayout((Layout)new GridLayout(1, true));
        btncomp.setLayoutData((Object)new GridData(0x1000000, 4, false, true));
        Button btn = new Button(btncomp, 0);
        btn.setText("Add");
        btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtensionEntry entry = RegistererPreferencePage.this.getSelectedType();
                if (entry == null) {
                    return;
                }
                TextInputDialog tid = new TextInputDialog(RegistererPreferencePage.this.exttree.getControl().getShell(), "Add extension", "Extension of type (" + entry.getType() + ")");
                tid.open();
                String ext = tid.getValue();
                if (ext != null) {
                    entry.addExtension(ext);
                }
                RegistererPreferencePage.this.exttree.refresh();
            }
        });
        btn = new Button(btncomp, 0);
        btn.setText("Edit");
        btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtensionElement elem = RegistererPreferencePage.this.getSelectedExtension();
                if (elem == null) {
                    return;
                }
                ExtensionEntry ee = (ExtensionEntry)elem.getParent();
                TextInputDialog tid = new TextInputDialog(RegistererPreferencePage.this.exttree.getControl().getShell(), "Add extension", "Extension of type (" + ee.getType() + ")");
                tid.setValue(elem.getExtension());
                tid.open();
                String ext = tid.getValue();
                if (ext != null && ext.length() > 0) {
                    elem.setExtension(ext);
                }
                RegistererPreferencePage.this.exttree.refresh();
            }
        });
        btn = new Button(btncomp, 0);
        btn.setText("Delete");
        btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtensionElement elem = RegistererPreferencePage.this.getSelectedExtension();
                if (elem == null) {
                    return;
                }
                ExtensionEntry ee = (ExtensionEntry)elem.getParent();
                ee.removeExtension(elem.getExtension());
                RegistererPreferencePage.this.exttree.refresh();
            }
        });
        this.exttree.setContentProvider((IContentProvider)new ExtensionContentProvider());
        this.exttree.setLabelProvider((IBaseLabelProvider)new ExtensionLabelProvider(this.exttree));
        IPreferenceStore store = RegistererPlugin.getDefault().getPreferenceStore();
        String extvalue = store.getString("filter");
        this.extimages = new ExtensionEntry("Image");
        this.extsources = new ExtensionEntry("Source");
        this.extdocuments = new ExtensionEntry("Document");
        this.extothers = new ExtensionEntry("Other");
        String[] evs = extvalue.split(",");
        int i = 0;
        while (i < evs.length) {
            String[] kv;
            String ev = evs[i].trim();
            if (ev.length() != 0 && (kv = ev.split("/")).length >= 2) {
                if (kv[0].compareTo("Image") == 0) {
                    this.extimages.addExtension(kv[1]);
                } else if (kv[0].compareTo("Source") == 0) {
                    this.extsources.addExtension(kv[1]);
                } else if (kv[0].compareTo("Document") == 0) {
                    this.extdocuments.addExtension(kv[1]);
                } else {
                    this.extothers.addExtension(kv[1]);
                }
            }
            ++i;
        }
        ArrayList<ExtensionEntry> ee = new ArrayList<ExtensionEntry>();
        ee.add(this.extimages);
        ee.add(this.extsources);
        ee.add(this.extdocuments);
        ee.add(this.extothers);
        this.exttree.setInput(ee);
    }

    public static ArrayList<DirEntry> getMonitoringList() {
        return DirEntry.getValidatedList(RegistererPreferencePage.initializeEntries());
    }

    private static void getTypes(ArrayList<DistCondition> conditions, ArrayList<String> files, ArrayList<String> ptypes) {
        DistCondition dc = null;
        int i = 0;
        while (i < conditions.size()) {
            dc = conditions.get(i);
            String regex = null;
            try {
                regex = RegexUtils.convert(dc.regex);
            }
            catch (Exception exception) {
                regex = dc.regex;
            }
            Pattern p = Pattern.compile(regex);
            int j = 0;
            while (j < files.size()) {
                if (ptypes.get(j) == null) {
                    String fname = null;
                    try {
                        fname = RegexUtils.convert(FilenameUtils.getName((String)files.get(j)));
                    }
                    catch (Exception exception) {
                        fname = FilenameUtils.getName((String)files.get(j));
                    }
                    Matcher m = p.matcher(fname);
                    if (m.matches()) {
                        ptypes.set(j, dc.type);
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < ptypes.size()) {
            assert (ptypes.get(i) != null);
            ++i;
        }
    }

    public static ArrayList<String> getTypes(ArrayList<DirEntry> entries, String dir, ArrayList<String> files) {
        ArrayList<DistCondition> condition = null;
        int i = 0;
        while (i < entries.size()) {
            DirEntry edir = entries.get(i);
            if (edir.dirname.equals(dir)) {
                condition = entries.get(i).getCondition();
                break;
            }
            if (dir.startsWith(edir.dirname) && edir.subdir) {
                condition = entries.get(i).getCondition();
                break;
            }
            ++i;
        }
        ArrayList<String> types = new ArrayList<String>();
        if (condition == null) {
            return null;
        }
        int i2 = 0;
        while (i2 < files.size()) {
            types.add(null);
            ++i2;
        }
        RegistererPreferencePage.getTypes(condition, files, types);
        return types;
    }

    public static String getType(ArrayList<DirEntry> entries, String dir, String file) {
        ArrayList<String> files = new ArrayList<String>();
        files.add(file);
        ArrayList<String> types = RegistererPreferencePage.getTypes(entries, dir, files);
        if (types == null) {
            return null;
        }
        return types.get(0);
    }

    public static String getManualType(String path) {
        ArrayList<DirEntry> dirents = DirEntry.getValidatedList(RegistererPreferencePage.initializeEntries());
        DirEntry de = null;
        int i = 0;
        while (i < dirents.size()) {
            if (dirents.get((int)i).dirname.equals("[MANUAL]")) {
                de = dirents.get(i);
                break;
            }
            ++i;
        }
        if (de == null) {
            return null;
        }
        ArrayList<String> files = new ArrayList<String>();
        files.add(path);
        ArrayList<String> pts = new ArrayList<String>();
        pts.add(null);
        RegistererPreferencePage.getTypes(de.condition, files, pts);
        return pts.get(0) == null ? null : pts.get(0);
    }

    public static ArrayList<String> getExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        IPreferenceStore store = RegistererPlugin.getDefault().getPreferenceStore();
        String vals = store.getString("filter");
        String[] kvs = vals.split(",");
        int i = 0;
        while (i < kvs.length) {
            String[] kv = kvs[i].split("/");
            if (kv.length >= 2) {
                extensions.add(kv[1]);
            }
            ++i;
        }
        return extensions;
    }

    private class DirContentProvider
    implements ITreeContentProvider {
        private DirContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((ArrayList)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof DirEntry) {
                return ((DirEntry)parentElement).getCondition().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof DistCondition) {
                return ((DistCondition)element).parent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof DirEntry;
        }
    }

    private class DirLabelProvider
    implements ITableLabelProvider {
        private DirLabelProvider() {
        }

        public Image getColumnImage(Object element, int index) {
            return null;
        }

        public String getColumnText(Object element, int index) {
            TreeColumn tc = RegistererPreferencePage.this.tableview.getTree().getColumn(index);
            String title = tc.getText();
            if (element instanceof DirEntry) {
                DirEntry de = (DirEntry)element;
                if (title.equals("Directory/Regular exp.")) {
                    return de.dirname;
                }
                if (title.equals("")) {
                    if (de.dirname.equals("[MANUAL]")) {
                        return "";
                    }
                    return "Monitoring=" + de.monitor + ", Subdir=" + de.subdir;
                }
                return null;
            }
            if (element instanceof DistCondition) {
                DistCondition dc = (DistCondition)element;
                if (title.equals("Directory/Regular exp.")) {
                    return dc.regex;
                }
                if (title.equals("")) {
                    if (dc.type.equals("Unclassified")) {
                        return "Not Classify";
                    }
                    return dc.type;
                }
                return null;
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return null;
        }
    }

    private class ExtensionContentProvider
    implements ITreeContentProvider {
        private ExtensionContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((ArrayList)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ExtensionEntry) {
                return ((ExtensionEntry)parentElement).getExtensions();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof ExtensionElement) {
                return ((ExtensionElement)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ExtensionEntry;
        }
    }

    private class ExtensionLabelProvider
    implements ITableLabelProvider {
        private TreeViewer parent;

        public ExtensionLabelProvider(TreeViewer parent) {
            this.parent = parent;
        }

        public Image getColumnImage(Object element, int index) {
            return null;
        }

        public String getColumnText(Object element, int index) {
            TreeColumn tc = this.parent.getTree().getColumn(index);
            String title = tc.getText();
            if (element instanceof ExtensionEntry) {
                ExtensionEntry ee = (ExtensionEntry)element;
                if (title.equals("type")) {
                    return ee.getType();
                }
                return null;
            }
            if (element instanceof ExtensionElement) {
                ExtensionElement ee = (ExtensionElement)element;
                if (title.equals("extension")) {
                    return ee.getExtension();
                }
                return null;
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return null;
        }
    }
}

