/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.framework.preferences;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.mdocument.UserInformationDomImpl;
import jp.sourceforge.concierge.util.CurriculumVitaeData;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.w3c.dom.Document;

public class UserInformationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private String usernameString = null;
    private String divisionString = null;
    private String organizationString = null;
    private String emailString = null;
    private String urlString = null;
    private ArrayList<CurriculumVitaeData> cvAL = null;
    private Comparator<CurriculumVitaeData> cvComparator = null;
    private Document mDoc = null;
    private TableViewer cvTableViewer = null;

    public UserInformationPreferencePage() {
        super("UserInfotmation");
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        this.createPartControl(comp);
        return comp;
    }

    protected void contributeButtons(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.numColumns = 1;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Button myApplyButton = new Button(parent, 8);
        String[] labels = JFaceResources.getStrings((String[])new String[]{FrameworkPlugin.getString("UserInformationPreferencePage.1")});
        myApplyButton.setText(labels[0]);
        Dialog.applyDialogFont((Control)myApplyButton);
        GridData data = new GridData(256);
        Point minButtonSize = myApplyButton.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minButtonSize.x);
        myApplyButton.setLayoutData((Object)data);
        myApplyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserInformationPreferencePage.this.performApply();
            }
        });
        myApplyButton.setEnabled(this.isValid());
        this.applyDialogFont(parent);
    }

    protected void createPartControl(Composite parent) {
        this.cvComparator = new Comparator<CurriculumVitaeData>(){

            @Override
            public int compare(CurriculumVitaeData obj1, CurriculumVitaeData obj2) {
                CurriculumVitaeData cv2;
                CurriculumVitaeData cv1;
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    block12: {
                                        block11: {
                                            block10: {
                                                cv1 = obj1;
                                                cv2 = obj2;
                                                try {
                                                    if (cv1.getFromYear() >= cv2.getFromYear()) break block10;
                                                    return -1;
                                                }
                                                catch (Exception excp) {
                                                    System.err.println(excp.getMessage());
                                                    return 0;
                                                }
                                            }
                                            if (cv1.getFromYear() <= cv2.getFromYear()) break block11;
                                            return 1;
                                        }
                                        if (cv1.getFromMonth() >= cv2.getFromMonth()) break block12;
                                        return -1;
                                    }
                                    if (cv1.getFromMonth() <= cv2.getFromMonth()) break block13;
                                    return 1;
                                }
                                if (cv1.getToYear() >= cv2.getToYear()) break block14;
                                return -1;
                            }
                            if (cv1.getToYear() <= cv2.getToYear()) break block15;
                            return 1;
                        }
                        if (cv1.getToMonth() >= cv2.getToMonth()) break block16;
                        return -1;
                    }
                    if (cv1.getToMonth() <= cv2.getToMonth()) break block17;
                    return 1;
                }
                return cv1.getTitle().compareToIgnoreCase(cv2.getTitle());
            }
        };
        try {
            this.readUserInformationDocument();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(768));
        Label label = new Label(comp, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(FrameworkPlugin.getString("UserInformationPreferencePage.2"));
        Text text = new Text(comp, 2048);
        text.setLayoutData((Object)new GridData(768));
        text.setText(this.usernameString);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.getSource();
                UserInformationPreferencePage.this.usernameString = text.getText();
            }
        });
        label = new Label(comp, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(FrameworkPlugin.getString("UserInformationPreferencePage.4"));
        text = new Text(comp, 2048);
        text.setLayoutData((Object)new GridData(768));
        text.setText(this.divisionString);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.getSource();
                UserInformationPreferencePage.this.divisionString = text.getText();
            }
        });
        label = new Label(comp, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(FrameworkPlugin.getString("UserInformationPreferencePage.3"));
        text = new Text(comp, 2048);
        text.setLayoutData((Object)new GridData(768));
        text.setText(this.organizationString);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.getSource();
                UserInformationPreferencePage.this.organizationString = text.getText();
            }
        });
        label = new Label(comp, 0);
        label.setLayoutData((Object)new GridData());
        label.setText("E-mail:");
        text = new Text(comp, 2048);
        text.setLayoutData((Object)new GridData(768));
        text.setText(this.emailString);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.getSource();
                UserInformationPreferencePage.this.emailString = text.getText();
            }
        });
        label = new Label(comp, 0);
        label.setLayoutData((Object)new GridData());
        label.setText("URL:");
        text = new Text(comp, 2048);
        text.setLayoutData((Object)new GridData(768));
        text.setText(this.urlString);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.getSource();
                UserInformationPreferencePage.this.urlString = text.getText();
            }
        });
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
        label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(FrameworkPlugin.getString("UserInformationPreferencePage.7"));
        Composite comp2 = new Composite(parent, 0);
        comp2.setLayout((Layout)new GridLayout(2, false));
        comp2.setLayoutData((Object)new GridData(1808));
        this.cvTableViewer = new TableViewer(comp2, 66308);
        this.cvTableViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.cvTableViewer.getTable().setLinesVisible(true);
        this.cvTableViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.cvTableViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.cvTableViewer.getTable().setHeaderVisible(true);
        int[] orders = new int[3];
        TableColumn tc = new TableColumn(this.cvTableViewer.getTable(), 16384, 0);
        tc.setWidth(80);
        tc.setText(FrameworkPlugin.getString("UserInformationPreferencePage.8"));
        tc.setMoveable(false);
        tc.setResizable(true);
        orders[0] = 0;
        tc = new TableColumn(this.cvTableViewer.getTable(), 16384, 1);
        tc.setWidth(80);
        tc.setText(FrameworkPlugin.getString("UserInformationPreferencePage.9"));
        tc.setMoveable(false);
        tc.setResizable(true);
        orders[1] = 1;
        tc = new TableColumn(this.cvTableViewer.getTable(), 16384, 2);
        tc.setWidth(140);
        tc.setText(FrameworkPlugin.getString("UserInformationPreferencePage.10"));
        tc.setMoveable(false);
        tc.setResizable(true);
        orders[2] = 2;
        this.cvTableViewer.getTable().setColumnOrder(orders);
        this.cvTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null) {
                    return;
                }
            }
        });
        this.cvTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                if (obj == null) {
                    return;
                }
                CurriculumVitaeDialog dlg = new CurriculumVitaeDialog(UserInformationPreferencePage.this.cvTableViewer.getControl().getShell(), (CurriculumVitaeData)obj);
                if (dlg.open() == 0) {
                    try {
                        Collections.sort(UserInformationPreferencePage.this.cvAL, UserInformationPreferencePage.this.cvComparator);
                    }
                    catch (Exception exception) {}
                    UserInformationPreferencePage.this.cvTableViewer.setInput(null);
                    UserInformationPreferencePage.this.cvTableViewer.setInput((Object)UserInformationPreferencePage.this.cvAL);
                    UserInformationPreferencePage.this.cvTableViewer.reveal(obj);
                }
            }
        });
        try {
            Collections.sort(this.cvAL, this.cvComparator);
        }
        catch (Exception exception) {}
        this.cvTableViewer.setInput(null);
        this.cvTableViewer.setInput(this.cvAL);
        Composite actionComp = new Composite(comp2, 0);
        actionComp.setLayout((Layout)new GridLayout(1, false));
        actionComp.setLayoutData((Object)new GridData(1040));
        Button newButton = new Button(actionComp, 8);
        newButton.setText(FrameworkPlugin.getString("UserInformationPreferencePage.11"));
        newButton.setLayoutData((Object)new GridData(768));
        newButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button bt = (Button)e.getSource();
                CurriculumVitaeDialog dlg = new CurriculumVitaeDialog(bt.getShell());
                if (dlg.open() == 0) {
                    CurriculumVitaeData cv = dlg.getCV();
                    UserInformationPreferencePage.this.cvAL.add(cv);
                    try {
                        Collections.sort(UserInformationPreferencePage.this.cvAL, UserInformationPreferencePage.this.cvComparator);
                    }
                    catch (Exception exception) {}
                    UserInformationPreferencePage.this.cvTableViewer.setInput(null);
                    UserInformationPreferencePage.this.cvTableViewer.setInput((Object)UserInformationPreferencePage.this.cvAL);
                    UserInformationPreferencePage.this.cvTableViewer.setSelection((ISelection)new StructuredSelection((Object)cv), true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button deleteButton = new Button(actionComp, 8);
        deleteButton.setText(FrameworkPlugin.getString("UserInformationPreferencePage.12"));
        deleteButton.setLayoutData((Object)new GridData(768));
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)UserInformationPreferencePage.this.cvTableViewer.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                if (obj == null) {
                    return;
                }
                UserInformationPreferencePage.this.cvAL.remove(obj);
                UserInformationPreferencePage.this.cvTableViewer.setInput(null);
                UserInformationPreferencePage.this.cvTableViewer.setInput((Object)UserInformationPreferencePage.this.cvAL);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button editButton = new Button(actionComp, 8);
        editButton.setText(FrameworkPlugin.getString("UserInformationPreferencePage.13"));
        editButton.setLayoutData((Object)new GridData(768));
        editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)UserInformationPreferencePage.this.cvTableViewer.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                if (obj == null) {
                    return;
                }
                Button bt = (Button)e.getSource();
                CurriculumVitaeDialog dlg = new CurriculumVitaeDialog(bt.getShell(), (CurriculumVitaeData)obj);
                if (dlg.open() == 0) {
                    try {
                        Collections.sort(UserInformationPreferencePage.this.cvAL, UserInformationPreferencePage.this.cvComparator);
                    }
                    catch (Exception exception) {}
                    UserInformationPreferencePage.this.cvTableViewer.setInput(null);
                    UserInformationPreferencePage.this.cvTableViewer.setInput((Object)UserInformationPreferencePage.this.cvAL);
                    UserInformationPreferencePage.this.cvTableViewer.setSelection((ISelection)new StructuredSelection(obj), true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public boolean performOk() {
        this.writeUserInformationDocument();
        return super.performOk();
    }

    private void readUserInformationDocument() {
        this.usernameString = "";
        this.divisionString = "";
        this.organizationString = "";
        this.emailString = "";
        this.urlString = "";
        if (this.cvAL != null) {
            this.cvAL.clear();
        } else {
            this.cvAL = new ArrayList();
        }
        Document doc = UserInformationDomImpl.getDoc();
        if (doc != null) {
            this.mDoc = doc;
            this.usernameString = UserInformationDomImpl.getUserName(this.mDoc);
            this.divisionString = UserInformationDomImpl.getDivision(this.mDoc);
            this.organizationString = UserInformationDomImpl.getOrganization(this.mDoc);
            this.emailString = UserInformationDomImpl.getEmail(this.mDoc);
            this.urlString = UserInformationDomImpl.getURL(this.mDoc);
            UserInformationDomImpl.getCurriculumVitaeAL(this.mDoc, this.cvAL);
        }
    }

    private void writeUserInformationDocument() {
        int command = 3;
        if (this.mDoc == null) {
            this.mDoc = DomImpl.createDocument("userinformation");
            command = 1;
        }
        UserInformationDomImpl.updateUserName(this.mDoc, this.usernameString);
        UserInformationDomImpl.updateDivision(this.mDoc, this.divisionString);
        UserInformationDomImpl.updateOrganization(this.mDoc, this.organizationString);
        UserInformationDomImpl.updateEmail(this.mDoc, this.emailString);
        UserInformationDomImpl.updateURL(this.mDoc, this.urlString);
        UserInformationDomImpl.updateCurriculumVitae(this.mDoc, this.cvAL);
        ArrayList<Request> reqs = new ArrayList<Request>();
        reqs.add(new Request(command, this.mDoc, "userinformation"));
        if (reqs.size() > 0) {
            FrameworkPlugin.updateDocuments(reqs, (Object)"jp.sourceforge.concierge.framework.preferences.UserInformationPreferencePage");
        }
        reqs.clear();
        reqs = null;
    }

    public void init(IWorkbench arg0) {
    }

    public class CurriculumVitaeDialog
    extends Dialog {
        public String numberCharacters;
        private Text titleText;
        private Combo fromMonthCombo;
        private Text fromYearText;
        private Combo toMonthCombo;
        private Text toYearText;
        CurriculumVitaeData cv;

        protected CurriculumVitaeDialog(Shell parentShell) {
            super(parentShell);
            this.numberCharacters = "0123456789";
            this.titleText = null;
            this.fromMonthCombo = null;
            this.fromYearText = null;
            this.toMonthCombo = null;
            this.toYearText = null;
            this.cv = null;
        }

        protected CurriculumVitaeDialog(Shell parentShell, CurriculumVitaeData cv) {
            super(parentShell);
            this.numberCharacters = "0123456789";
            this.titleText = null;
            this.fromMonthCombo = null;
            this.fromYearText = null;
            this.toMonthCombo = null;
            this.toYearText = null;
            this.cv = null;
            this.cv = cv;
        }

        protected Point getInitialSize() {
            return new Point(480, 240);
        }

        public CurriculumVitaeData getCV() {
            return this.cv;
        }

        protected Control createDialogArea(Composite parent) {
            Date dNow = new Date();
            Calendar cd = Calendar.getInstance();
            cd.setTime(dNow);
            int fromY = cd.get(1);
            int fromM = 0;
            int toY = cd.get(1);
            int toM = 0;
            if (this.cv == null) {
                this.cv = new CurriculumVitaeData();
            } else {
                fromY = this.cv.getFromYear();
                fromM = this.cv.getFromMonth();
                toY = this.cv.getToYear();
                toM = this.cv.getToMonth();
            }
            this.getShell().setText(FrameworkPlugin.getString("UserInformationPreferencePage.15"));
            parent.setLayout((Layout)new GridLayout(1, false));
            Composite composite = (Composite)super.createDialogArea(parent);
            composite.setLayout((Layout)new GridLayout(1, false));
            composite.setLayoutData((Object)new GridData(1808));
            Composite comp = new Composite(composite, 0);
            comp.setLayout((Layout)new GridLayout(7, false));
            comp.setLayoutData((Object)new GridData(768));
            Label fromLabel = new Label(comp, 0);
            fromLabel.setText(FrameworkPlugin.getString("UserInformationPreferencePage.16"));
            this.fromMonthCombo = new Combo(comp, 8);
            this.fromMonthCombo.setItems(CurriculumVitaeData.monthMMM);
            this.fromMonthCombo.select(fromM);
            this.fromYearText = new Text(comp, 2048);
            if (fromY >= 0) {
                this.fromYearText.setText(String.valueOf(fromY));
            } else {
                this.fromYearText.setText("");
            }
            this.fromYearText.setTextLimit(5);
            this.fromYearText.setLayoutData((Object)new GridData(768));
            this.fromYearText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    e.doit = true;
                    if (e.character == '\b' || e.character == '\u007f') {
                        return;
                    }
                    if (CurriculumVitaeDialog.this.numberCharacters.indexOf(Character.toString(e.character)) == -1) {
                        e.doit = false;
                    }
                }
            });
            Label label = new Label(comp, 0);
            label.setText("");
            Label toLabel = new Label(comp, 0);
            toLabel.setText(FrameworkPlugin.getString("UserInformationPreferencePage.19"));
            this.toMonthCombo = new Combo(comp, 8);
            this.toMonthCombo.setItems(CurriculumVitaeData.monthMMM);
            this.toMonthCombo.select(toM);
            this.toYearText = new Text(comp, 2048);
            if (toY >= 0) {
                this.toYearText.setText(String.valueOf(toY));
            } else {
                this.toYearText.setText("");
            }
            this.toYearText.setTextLimit(5);
            this.toYearText.setLayoutData((Object)new GridData(768));
            this.toYearText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    e.doit = true;
                    if (e.character == '\b' || e.character == '\u007f') {
                        return;
                    }
                    if (CurriculumVitaeDialog.this.numberCharacters.indexOf(Character.toString(e.character)) == -1) {
                        e.doit = false;
                    }
                }
            });
            comp = new Composite(composite, 0);
            comp.setLayout((Layout)new GridLayout(2, false));
            comp.setLayoutData((Object)new GridData(768));
            Label label2 = new Label(comp, 0);
            label2.setText(FrameworkPlugin.getString("UserInformationPreferencePage.21"));
            this.titleText = new Text(comp, 2048);
            this.titleText.setText(this.cv.getTitle());
            this.titleText.setLayoutData((Object)new GridData(768));
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                this.cv.setTitle(this.titleText.getText());
                this.cv.setFrom(this.fromYearText.getText(), this.fromMonthCombo.getSelectionIndex());
                this.cv.setTo(this.toYearText.getText(), this.toMonthCombo.getSelectionIndex());
            }
            this.setReturnCode(buttonId);
            this.close();
            super.buttonPressed(buttonId);
        }
    }

    private class ViewContentProvider
    implements IStructuredContentProvider {
        private ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return ((ArrayList)parent).toArray();
        }
    }

    private class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof CurriculumVitaeData) {
                CurriculumVitaeData cv = (CurriculumVitaeData)obj;
                if (index == 0) {
                    return cv.getViewFrom();
                }
                if (index == 1) {
                    return cv.getViewTo();
                }
                if (index == 2) {
                    return cv.getTitle();
                }
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

