/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.parser;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.parser.ITypeParser;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogParser
implements ITypeParser {
    private static final String PARSERNS = "http://concierge.sourceforge.jp/ns/log";
    private static final String PARSERNSPREFIX = "log";
    private static final String ELEMENTTAGNAME = "comment";
    private static final String DATETAGNAME = "date";
    private static final String BODYTAGNAME = "body";
    public static final String DELIMITER = "\n\t\t\t\t\n";
    public static final String LS = "\r";
    public static final String MESSAGE = "...";

    private Hashtable<String, String> parse(String str) {
        Hashtable<String, String> vals = new Hashtable<String, String>();
        str = str.trim();
        int fbpos = str.indexOf("[");
        int lbpos = str.indexOf("]");
        if (fbpos != 0 || lbpos - fbpos < 7) {
            vals.put(DATETAGNAME, "");
            vals.put(BODYTAGNAME, str);
            return vals;
        }
        try {
            String datestr = str.substring(fbpos + 1, lbpos - 1);
            DateFormat df = DateFormat.getInstance();
            df.parse(datestr);
            vals.put(DATETAGNAME, datestr);
            vals.put(BODYTAGNAME, lbpos + 1 == str.length() ? "" : str.substring(lbpos + 1));
        }
        catch (Exception exception) {
            vals.put(DATETAGNAME, "");
            vals.put(BODYTAGNAME, str);
        }
        return vals;
    }

    @Override
    public String getParserNS() {
        return PARSERNS;
    }

    @Override
    public String getParserNSPrefix() {
        return PARSERNSPREFIX;
    }

    @Override
    public String getSingleText(Element data) {
        String str = "";
        ArrayList<Element> elems = DomImpl.getElements(data, ELEMENTTAGNAME, PARSERNSPREFIX);
        int i = 0;
        while (i < elems.size()) {
            ArrayList<Element> dates;
            Element e = elems.get(i);
            if (str.length() > 0) {
                str = String.valueOf(str) + " / ";
            }
            str = (dates = DataDomImpl.getElements(e, DATETAGNAME, PARSERNSPREFIX)).size() > 0 ? String.valueOf(str) + "[" + DataDomImpl.getElementText(dates.get(0)) + "]" : String.valueOf(str) + "[unknown date]";
            ArrayList<Element> comments = DataDomImpl.getElements(e, BODYTAGNAME, PARSERNSPREFIX);
            if (comments.size() > 0) {
                str = String.valueOf(str) + "(" + DataDomImpl.getElementText(comments.get(0));
                str = String.valueOf(str) + ")";
            }
            ++i;
        }
        return str;
    }

    @Override
    public ArrayList<String> getMultiText(Element data) {
        return null;
    }

    @Override
    public ArrayList<String> getIndexValues(Element data, String abc) {
        return null;
    }

    @Override
    public ArrayList<String> getIndexABC(Element data) {
        return null;
    }

    @Override
    public void putToElement(Element elem, String str) {
        if (str == null) {
            return;
        }
        DomImpl.removeAllChildren(elem);
        if (str.length() == 0) {
            return;
        }
        String[] comments = str.split(DELIMITER);
        int i = 0;
        while (i < comments.length) {
            Hashtable<String, String> v = this.parse(comments[i]);
            Element e = DomImpl.appendElement(elem, ELEMENTTAGNAME, PARSERNSPREFIX);
            Element de = DomImpl.appendElement(e, DATETAGNAME, PARSERNSPREFIX);
            DomImpl.setElementText(de, v.get(DATETAGNAME));
            Element ce = DomImpl.appendElement(e, BODYTAGNAME, PARSERNSPREFIX);
            DomImpl.setElementText(ce, v.get(BODYTAGNAME));
            ++i;
        }
    }

    @Override
    public String getMessage() {
        return MESSAGE;
    }
}

