/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.SchemaSearcher;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.TableInfo;
import zigen.plugin.db.core.TableInfoSorter;
import zigen.plugin.db.core.rule.AbstractTableInfoSearchFactory;
import zigen.plugin.db.core.rule.ITableInfoSearchFactory;

public class TableSearcher {
    public static TableInfo[] execute(Connection con, String schemaPattern, String[] types) throws Exception {
        return TableSearcher.execute(con, schemaPattern, types, null);
    }

    public static TableInfo execute(Connection con, String schemaPattern, String tablePattern, String type) throws Exception {
        return TableSearcher.execute(con, schemaPattern, tablePattern, type, null);
    }

    public static TableInfo[] execute(Connection con, String schemaPattern, String[] types, Character encloseChar) throws Exception {
        TableInfo[] tableInfoArray;
        List<TableInfo> list = new ArrayList();
        ResultSet rs = null;
        Statement st = null;
        try {
            DatabaseMetaData objMet = con.getMetaData();
            ITableInfoSearchFactory factory = AbstractTableInfoSearchFactory.getFactory(objMet);
            if (DBType.getType(objMet) == 1) {
                list = factory.getTableInfoAll(con, schemaPattern, types);
            } else if (DBType.getType(objMet) == 3) {
                list = factory.getTableInfoAll(con, schemaPattern, types);
            } else {
                list = new ArrayList();
                if (DBType.getType(objMet) == 2 && objMet.getDatabaseMajorVersion() >= 5) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("SELECT");
                    sb.append("        TABLE_NAME");
                    sb.append("        ,TABLE_TYPE");
                    sb.append(" ,TABLE_COMMENT REMARKS");
                    sb.append("    FROM");
                    sb.append("        information_schema.TABLES");
                    sb.append("    WHERE");
                    sb.append("        TABLE_SCHEMA = '" + SQLUtil.encodeQuotation(schemaPattern) + "'");
                    if (types.length > 0) {
                        sb.append("    AND (");
                        int i = 0;
                        while (i < types.length) {
                            if (i > 0) {
                                sb.append(" OR ");
                            }
                            sb.append("    TABLE_TYPE Like '%" + SQLUtil.encodeQuotation(types[i]) + "'");
                            ++i;
                        }
                        sb.append("    )");
                    }
                    st = con.createStatement();
                    rs = st.executeQuery(sb.toString());
                } else {
                    rs = SchemaSearcher.isSupport(con) ? objMet.getTables(null, schemaPattern, "%", types) : objMet.getTables(null, "%", "%", types);
                }
                while (rs.next()) {
                    String tableName = rs.getString("TABLE_NAME");
                    TableInfo info = new TableInfo();
                    if (encloseChar != null) {
                        info.setName(SQLUtil.enclose(tableName, encloseChar.charValue()));
                    } else {
                        info.setName(tableName);
                    }
                    info.setTableType(rs.getString("TABLE_TYPE"));
                    info.setComment(rs.getString("REMARKS"));
                    list.add(info);
                }
            }
            Collections.sort(list, new TableInfoSorter());
            tableInfoArray = list.toArray(new TableInfo[0]);
            Object var11_14 = null;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                StatementUtil.close(st);
                ResultSetUtil.close(rs);
                throw throwable;
            }
        }
        StatementUtil.close(st);
        ResultSetUtil.close(rs);
        return tableInfoArray;
    }

    public static TableInfo execute(Connection con, String schemaPattern, String tablePattern, String type, Character encloseChar) throws Exception {
        TableInfo tableInfo;
        TableInfo info = null;
        ResultSet rs = null;
        Statement st = null;
        try {
            DatabaseMetaData objMet = con.getMetaData();
            ITableInfoSearchFactory factory = AbstractTableInfoSearchFactory.getFactory(objMet);
            if (DBType.getType(objMet) == 1) {
                info = factory.getTableInfo(con, schemaPattern, tablePattern, type);
            } else if (DBType.getType(objMet) == 3) {
                info = factory.getTableInfo(con, schemaPattern, tablePattern, type);
            } else {
                info = new TableInfo();
                if (DBType.getType(objMet) == 2 && objMet.getDatabaseMajorVersion() >= 5) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("SELECT");
                    sb.append("        TABLE_NAME");
                    sb.append("        ,TABLE_TYPE");
                    sb.append(" ,TABLE_COMMENT REMARKS");
                    sb.append("    FROM");
                    sb.append("        information_schema.TABLES");
                    sb.append("    WHERE");
                    sb.append("        TABLE_SCHEMA = '" + SQLUtil.encodeQuotation(schemaPattern) + "'");
                    sb.append("        AND TABLE_NAME = '" + SQLUtil.encodeQuotation(tablePattern) + "'");
                    sb.append("        AND TABLE_NAME = '" + SQLUtil.encodeQuotation(tablePattern) + "'");
                    sb.append("        AND TABLE_TYPE Like '%" + SQLUtil.encodeQuotation(type) + "'");
                    st = con.createStatement();
                    rs = st.executeQuery(sb.toString());
                } else {
                    rs = SchemaSearcher.isSupport(con) ? objMet.getTables(null, schemaPattern, "%", new String[]{type}) : objMet.getTables(null, "%", "%", new String[]{type});
                }
                if (rs.next()) {
                    String tableName = rs.getString("TABLE_NAME");
                    if (encloseChar != null) {
                        info.setName(SQLUtil.enclose(tableName, encloseChar.charValue()));
                    } else {
                        info.setName(tableName);
                    }
                    info.setTableType(rs.getString("TABLE_TYPE"));
                    info.setComment(rs.getString("REMARKS"));
                }
            }
            tableInfo = info;
            Object var11_13 = null;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                StatementUtil.close(st);
                ResultSetUtil.close(rs);
                throw throwable;
            }
        }
        StatementUtil.close(st);
        ResultSetUtil.close(rs);
        return tableInfo;
    }
}

