/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.internal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.ConstraintNameSorter;
import zigen.plugin.db.core.ConstraintSeqSorter;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.TableIDXColumn;

public class OracleIndexSearcher {
    private static String getIndexQuery(String schemaPattern, String tableName, boolean uniqueIndex) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT");
        sb.append("        T.*");
        sb.append("    FROM");
        sb.append("        (");
        sb.append("            SELECT");
        sb.append("                    IND.TABLE_OWNER");
        sb.append("                    ,IND.TABLE_NAME");
        sb.append("                    ,IND.INDEX_NAME");
        sb.append("                    ,COL.COLUMN_POSITION AS ORDINAL_POSITION");
        sb.append("                    ,COL.COLUMN_NAME");
        sb.append("                    ,IND.UNIQUENESS");
        sb.append("                    ,IND.INDEX_TYPE");
        sb.append("                FROM");
        sb.append("                    ALL_IND_COLUMNS COL");
        sb.append("                    ,ALL_INDEXES IND");
        sb.append("                WHERE");
        sb.append("                    IND.OWNER = COL.INDEX_OWNER");
        sb.append("                    AND IND.INDEX_NAME = COL.INDEX_NAME");
        sb.append("                    AND IND.TABLE_OWNER = COL.TABLE_OWNER");
        sb.append("                    AND IND.TABLE_NAME = COL.TABLE_NAME");
        if (!uniqueIndex) {
            sb.append("                    AND IND.UNIQUENESS = 'NONUNIQUE'");
        } else {
            sb.append("                    AND IND.UNIQUENESS = 'UNIQUE'");
        }
        sb.append("                    AND IND.TABLE_OWNER = '" + SQLUtil.encodeQuotation(schemaPattern) + "'");
        sb.append("                    AND IND.TABLE_NAME = '" + SQLUtil.encodeQuotation(tableName) + "'");
        sb.append("        ) T, ALL_CONSTRAINTS CONS");
        sb.append("        WHERE T.TABLE_OWNER = CONS.OWNER(+)");
        sb.append("        AND T.TABLE_NAME = CONS.TABLE_NAME(+)");
        sb.append("        AND T.INDEX_NAME = CONS.CONSTRAINT_NAME(+)");
        sb.append("        AND CONS.CONSTRAINT_NAME IS NULL");
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TableIDXColumn[] getIDXColumns(Connection con, String schemaPattern, String tableName, boolean uniqueIndex) throws Exception {
        TableIDXColumn[] tableIDXColumnArray;
        ArrayList<TableIDXColumn> list = new ArrayList<TableIDXColumn>();
        ResultSet rs = null;
        Statement st = null;
        try {
            try {
                st = con.createStatement();
                String sql = OracleIndexSearcher.getIndexQuery(schemaPattern, tableName, uniqueIndex);
                rs = st.executeQuery(sql);
                while (true) {
                    if (!rs.next()) {
                        Collections.sort(list, new ConstraintSeqSorter());
                        Collections.sort(list, new ConstraintNameSorter());
                        tableIDXColumnArray = list.toArray(new TableIDXColumn[0]);
                        Object var10_14 = null;
                        break;
                    }
                    String indexName = rs.getString("INDEX_NAME");
                    if (indexName == null) continue;
                    TableIDXColumn column = new TableIDXColumn();
                    column.setName(indexName);
                    column.setOrdinal_position(rs.getInt("ORDINAL_POSITION"));
                    column.setColumnName(rs.getString("COLUMN_NAME"));
                    if ("UNIQUE".equals(rs.getString("UNIQUENESS"))) {
                        column.setNonUnique(false);
                    } else {
                        column.setNonUnique(true);
                    }
                    column.setIndexType(rs.getString("INDEX_TYPE"));
                    list.add(column);
                }
            }
            catch (SQLException e) {
                DbPlugin.log(e);
                TableIDXColumn[] tableIDXColumnArray2 = new TableIDXColumn[]{};
                Object var10_15 = null;
                ResultSetUtil.close(rs);
                StatementUtil.close(st);
                return tableIDXColumnArray2;
            }
            catch (Exception e) {
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            ResultSetUtil.close(rs);
            StatementUtil.close(st);
            throw throwable;
        }
        ResultSetUtil.close(rs);
        StatementUtil.close(st);
        return tableIDXColumnArray;
    }

    private static String getIndexQuery(String schemaPattern, String tableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT");
        sb.append("        T.*");
        sb.append("    FROM");
        sb.append("        (");
        sb.append("            SELECT");
        sb.append("                    IND.TABLE_OWNER");
        sb.append("                    ,IND.TABLE_NAME");
        sb.append("                    ,IND.INDEX_NAME");
        sb.append("                    ,COL.COLUMN_POSITION AS ORDINAL_POSITION");
        sb.append("                    ,COL.COLUMN_NAME");
        sb.append("                    ,IND.UNIQUENESS");
        sb.append("                    ,IND.INDEX_TYPE");
        sb.append("                FROM");
        sb.append("                    ALL_IND_COLUMNS COL");
        sb.append("                    ,ALL_INDEXES IND");
        sb.append("                WHERE");
        sb.append("                    IND.OWNER = COL.INDEX_OWNER");
        sb.append("                    AND IND.INDEX_NAME = COL.INDEX_NAME");
        sb.append("                    AND IND.TABLE_OWNER = COL.TABLE_OWNER");
        sb.append("                    AND IND.TABLE_NAME = COL.TABLE_NAME");
        sb.append("                    AND IND.TABLE_OWNER = '" + SQLUtil.encodeQuotation(schemaPattern) + "'");
        sb.append("                    AND IND.TABLE_NAME = '" + SQLUtil.encodeQuotation(tableName) + "'");
        sb.append("        ) T, ALL_CONSTRAINTS CONS");
        sb.append("        WHERE T.TABLE_OWNER = CONS.OWNER(+)");
        sb.append("        AND T.TABLE_NAME = CONS.TABLE_NAME(+)");
        sb.append("        AND T.INDEX_NAME = CONS.CONSTRAINT_NAME(+)");
        sb.append("        AND CONS.CONSTRAINT_NAME IS NULL");
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TableIDXColumn[][] getIDXColumns(Connection con, String schemaPattern, String tableName) throws Exception {
        TableIDXColumn[][] tableIDXColumnArray;
        ResultSet rs = null;
        Statement st = null;
        ArrayList<TableIDXColumn> uniquelist = new ArrayList<TableIDXColumn>();
        ArrayList<TableIDXColumn> nonUniquelist = new ArrayList<TableIDXColumn>();
        try {
            try {
                st = con.createStatement();
                String sql = OracleIndexSearcher.getIndexQuery(schemaPattern, tableName);
                rs = st.executeQuery(sql);
                while (true) {
                    if (!rs.next()) {
                        TableIDXColumn[][] result;
                        Collections.sort(uniquelist, new ConstraintSeqSorter());
                        Collections.sort(uniquelist, new ConstraintNameSorter());
                        Collections.sort(nonUniquelist, new ConstraintSeqSorter());
                        Collections.sort(nonUniquelist, new ConstraintNameSorter());
                        TableIDXColumn[] uind = uniquelist.toArray(new TableIDXColumn[uniquelist.size()]);
                        TableIDXColumn[] nuind = nonUniquelist.toArray(new TableIDXColumn[nonUniquelist.size()]);
                        tableIDXColumnArray = result = new TableIDXColumn[][]{uind, nuind};
                        Object var11_15 = null;
                        break;
                    }
                    String indexName = rs.getString("INDEX_NAME");
                    if (indexName == null) continue;
                    TableIDXColumn column = new TableIDXColumn();
                    column.setName(indexName);
                    column.setOrdinal_position(rs.getInt("ORDINAL_POSITION"));
                    column.setColumnName(rs.getString("COLUMN_NAME"));
                    if ("UNIQUE".equals(rs.getString("UNIQUENESS"))) {
                        column.setNonUnique(false);
                    } else {
                        column.setNonUnique(true);
                    }
                    column.setIndexType(rs.getString("INDEX_TYPE"));
                    if (!column.isNonUnique()) {
                        uniquelist.add(column);
                        continue;
                    }
                    nonUniquelist.add(column);
                }
            }
            catch (SQLException e) {
                DbPlugin.log(e);
                TableIDXColumn[][] tableIDXColumnArray2 = new TableIDXColumn[0][0];
                Object var11_16 = null;
                ResultSetUtil.close(rs);
                StatementUtil.close(st);
                return tableIDXColumnArray2;
            }
            catch (Exception e) {
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            ResultSetUtil.close(rs);
            StatementUtil.close(st);
            throw throwable;
        }
        ResultSetUtil.close(rs);
        StatementUtil.close(st);
        return tableIDXColumnArray;
    }
}

