/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.ui.PlatformUI;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ui.actions.Messages;

public class GlobalAction
extends Action {
    private int operation;
    private TextViewer viewer;

    public GlobalAction(TextViewer viewer, int operation) {
        this.operation = operation;
        this.viewer = viewer;
        this.setImage(operation);
    }

    public void run() {
        if (!this.viewer.canDoOperation(this.operation)) {
            throw new IllegalAccessError("can't run Action.");
        }
        this.viewer.doOperation(this.operation);
    }

    public void setImage(int operation) {
        String imageName = null;
        switch (operation) {
            case 1: {
                imageName = "IMG_TOOL_UNDO";
                this.setText(Messages.getString("GlobalAction.1"));
                this.setActionDefinitionId("org.eclipse.ui.edit.undo");
                break;
            }
            case 2: {
                imageName = "IMG_TOOL_REDO";
                this.setText(Messages.getString("GlobalAction.2"));
                this.setActionDefinitionId("org.eclipse.ui.edit.redo");
                break;
            }
            case 3: {
                imageName = "IMG_TOOL_CUT";
                this.setText(Messages.getString("GlobalAction.3"));
                this.setActionDefinitionId("org.eclipse.ui.edit.cut");
                break;
            }
            case 4: {
                imageName = "IMG_TOOL_COPY";
                this.setText(Messages.getString("GlobalAction.4"));
                this.setActionDefinitionId("org.eclipse.ui.edit.copy");
                break;
            }
            case 5: {
                imageName = "IMG_TOOL_PASTE";
                this.setText(Messages.getString("GlobalAction.5"));
                this.setActionDefinitionId("org.eclipse.ui.edit.paste");
                break;
            }
            case 6: {
                imageName = "IMG_TOOL_DELETE";
                this.setText(Messages.getString("GlobalAction.6"));
                this.setActionDefinitionId("org.eclipse.ui.edit.delete");
                break;
            }
            case 7: {
                this.setText(Messages.getString("GlobalAction.7"));
                this.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
                imageName = null;
                break;
            }
            case 1003: {
                this.setText(Messages.getString("GlobalAction.8"));
                this.setImageDescriptor(DbPlugin.getDefault().getImageRegistry().getDescriptor("execute.gif"));
                this.setActionDefinitionId("zigen.plugin.SQLExecuteActionCommand");
                imageName = null;
                return;
            }
            case 1004: {
                this.setText(Messages.getString("GlobalAction.10"));
                this.setImageDescriptor(DbPlugin.getDefault().getImageRegistry().getDescriptor("execute.gif"));
                this.setActionDefinitionId("zigen.plugin.SQLCurrentExecuteActionCommand");
                imageName = null;
                return;
            }
            case 1005: {
                this.setText(Messages.getString("GlobalAction.12"));
                this.setImageDescriptor(DbPlugin.getDefault().getImageRegistry().getDescriptor("execute.gif"));
                this.setActionDefinitionId("zigen.plugin.SQLSelectedExecuteActionCommand");
                imageName = null;
                return;
            }
            case 1001: {
                this.setText(Messages.getString("GlobalAction.14"));
                this.setAccelerator(393286);
                this.setImageDescriptor(DbPlugin.getDefault().getImageRegistry().getDescriptor("format.gif"));
                imageName = null;
                return;
            }
            case 1002: {
                this.setText(Messages.getString("GlobalAction.15"));
                this.setAccelerator(393301);
                imageName = null;
                return;
            }
            case 1008: {
                this.setText(Messages.getString("GlobalAction.16"));
                this.setAccelerator(262212);
                return;
            }
            case 1009: {
                this.setText(Messages.getString("GlobalAction.17"));
                this.setAccelerator(262191);
                return;
            }
            case 1006: {
                this.setText(Messages.getString("GlobalAction.18"));
                this.setImageDescriptor(DbPlugin.getDefault().getImageRegistry().getDescriptor("forward.gif"));
                this.setActionDefinitionId("zigen.plugin.SQLNextCommand");
                return;
            }
            case 1007: {
                this.setText(Messages.getString("GlobalAction.20"));
                this.setImageDescriptor(DbPlugin.getDefault().getImageRegistry().getDescriptor("back.gif"));
                this.setActionDefinitionId("zigen.plugin.SQLBackCommand");
                return;
            }
            case 1012: {
                this.setText(Messages.getString("GlobalAction.22"));
                this.setImageDescriptor(DbPlugin.getDefault().getImageRegistry().getDescriptor("clear.gif"));
                return;
            }
            case 1010: {
                this.setText(Messages.getString("GlobalAction.23"));
                this.setImageDescriptor(DbPlugin.getDefault().getImageRegistry().getDescriptor("commit.gif"));
                return;
            }
            case 1011: {
                this.setText(Messages.getString("GlobalAction.24"));
                this.setImageDescriptor(DbPlugin.getDefault().getImageRegistry().getDescriptor("rollback.gif"));
                return;
            }
            case 1013: {
                this.setText(Messages.getString("GlobalAction.25"));
                this.setImageDescriptor(DbPlugin.getDefault().getImageRegistry().getDescriptor("script.gif"));
                return;
            }
        }
        if (imageName != null) {
            this.setImageDescriptor(imageName);
        }
    }

    private void setImageDescriptor(String imageName) {
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(imageName));
    }

    public void setTextViewer(TextViewer viewer) {
        this.viewer = viewer;
    }
}

