/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.contentassist;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.SQLFormatter;
import zigen.plugin.db.core.StringTokenizer;
import zigen.plugin.db.core.StringUtil;

public class SQLTemplateFormatter {
    IDocument fDocument;
    int originalOffset;
    IPreferenceStore ps;

    public SQLTemplateFormatter(IDocument doc, int originalOffset) {
        this.fDocument = doc;
        this.originalOffset = originalOffset;
        this.ps = DbPlugin.getDefault().getPreferenceStore();
    }

    public String format(String templatePattern) {
        try {
            int line = this.fDocument.getLineOfOffset(this.originalOffset);
            int lineOffset = this.fDocument.getLineOffset(line);
            int formattOffset = this.originalOffset - lineOffset;
            boolean onPatch = this.ps.getBoolean("SQLEditorPreferencePage.FormatPatch");
            int type = this.ps.getInt("SQLFormatPreferencePage.UseFormatterType");
            boolean useCodeFormatter = this.ps.getBoolean("org.eclipse.ui.texteditor.templates.preferences.format_templates");
            if (useCodeFormatter) {
                templatePattern = SQLFormatter.format(templatePattern, type, onPatch, formattOffset);
                templatePattern = this.reConvert(templatePattern);
            }
            return templatePattern;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return templatePattern;
        }
    }

    String reConvert(String sql) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(sql, " ");
        String token = null;
        int indent = 0;
        boolean isDoru = false;
        boolean isStart = false;
        boolean isEnd = false;
        while ((token = tokenizer.nextToken()) != null) {
            if (token.trim().length() == 0) {
                ++indent;
                continue;
            }
            String wk = token.trim();
            if (wk.startsWith("$")) {
                isDoru = true;
                sb.append(" ");
                sb.append(StringUtil.indent(token, indent));
                indent = 0;
                continue;
            }
            if (wk.startsWith("{")) {
                isStart = true;
                sb.append(StringUtil.indent(token, indent));
                indent = 0;
                continue;
            }
            if (wk.startsWith("}")) {
                isEnd = true;
                sb.append(StringUtil.indent(token, indent));
                indent = 0;
                continue;
            }
            if (sb.length() == 0) {
                sb.append(token);
            } else if (isDoru || isStart) {
                sb.append(StringUtil.indent(token, indent));
                isDoru = false;
                isStart = false;
            } else if (isEnd) {
                sb.append(" ");
                sb.append(StringUtil.indent(token, indent));
                isEnd = false;
            } else {
                sb.append(" ");
                sb.append(StringUtil.indent(token, indent));
            }
            indent = 0;
        }
        return sb.toString();
    }
}

