/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.rule.DefaultSQLCreatorFactory;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.editors.IPageChangeListener;
import zigen.plugin.db.ui.editors.Messages;
import zigen.plugin.db.ui.internal.ITable;

public class TableViewerPager {
    protected ImageCacher ic = ImageCacher.getInstance();
    int offset = 1;
    int limit = 0;
    int recordCount = 0;
    int pageCount;
    protected int pageNo = 1;
    Label sura;
    Label totalPage;
    Text pageNoTxt;
    ToolItem topPage;
    ToolItem backPage;
    ToolItem nextPage;
    ToolItem endPage;
    ITable table;
    private List listeners = new ArrayList();

    public TableViewerPager(ITable table, int limit) {
        this.table = table;
        this.limit = limit;
    }

    public Control createStackedButtons(Composite composite) {
        Composite c = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(5, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        c.setLayout((Layout)gridLayout);
        ToolBar toolBar4 = new ToolBar(c, 256);
        this.topPage = new ToolItem(toolBar4, 8);
        this.topPage.setImage(this.ic.getImage("top.gif"));
        this.topPage.setToolTipText(Messages.getString("TableViewerPager.0"));
        this.topPage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableViewerPager.this.offset = 1;
                TableViewerPager.this.firePageChangeListener(102, TableViewerPager.this.offset, TableViewerPager.this.limit);
                TableViewerPager.this.setPageNo(1);
            }
        });
        this.backPage = new ToolItem(toolBar4, 0);
        this.backPage.setImage(this.ic.getImage("previous.gif"));
        this.backPage.setToolTipText(Messages.getString("TableViewerPager.8"));
        this.backPage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableViewerPager.this.offset -= TableViewerPager.this.limit;
                TableViewerPager.this.firePageChangeListener(102, TableViewerPager.this.offset, TableViewerPager.this.limit);
                TableViewerPager.this.setPageNo(--TableViewerPager.this.pageNo);
            }
        });
        this.pageNoTxt = new Text(c, 133120);
        this.pageNoTxt.setText("999999999");
        this.pageNoTxt.pack();
        this.pageNoTxt.setEditable(false);
        ToolBar toolBar5 = new ToolBar(c, 256);
        this.nextPage = new ToolItem(toolBar5, 0);
        this.nextPage.setImage(this.ic.getImage("next.gif"));
        this.nextPage.setToolTipText(Messages.getString("TableViewerPager.9"));
        this.nextPage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableViewerPager.this.offset += TableViewerPager.this.limit;
                TableViewerPager.this.firePageChangeListener(102, TableViewerPager.this.offset, TableViewerPager.this.limit);
                TableViewerPager.this.setPageNo(++TableViewerPager.this.pageNo);
            }
        });
        this.endPage = new ToolItem(toolBar5, 8);
        this.endPage.setImage(this.ic.getImage("end.gif"));
        this.endPage.setToolTipText(Messages.getString("TableViewerPager.2"));
        this.endPage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableViewerPager.this.offset = (TableViewerPager.this.pageCount - 1) * TableViewerPager.this.limit + 1;
                TableViewerPager.this.firePageChangeListener(102, TableViewerPager.this.offset, TableViewerPager.this.limit);
                TableViewerPager.this.setPageNo(TableViewerPager.this.pageCount);
            }
        });
        this.sura = new Label(c, 0);
        this.totalPage = new Label(c, 0);
        this.sura.setText("/ ");
        this.sura.pack();
        this.totalPage.setText("999999999");
        this.totalPage.pack();
        this.setEnabledPagerButton();
        return c;
    }

    private void calcPageCount(int aPageSize) {
        int wk_recordCount = this.getRecordCount();
        this.pageCount = aPageSize == 0 ? 1 : (wk_recordCount % aPageSize == 0 ? wk_recordCount / aPageSize : wk_recordCount / aPageSize + 1);
    }

    public void addPageChangeListener(IPageChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removePageChangeListener(IPageChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void firePageChangeListener(int status, int offset, int limit) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            IPageChangeListener element = (IPageChangeListener)iter.next();
            if (element == null) continue;
            element.pageChanged(status, offset, limit);
        }
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void setRecordCount(int totalCount) {
        this.recordCount = totalCount;
        if (this.getRecordCount() > 0) {
            this.calcPageCount(this.limit);
            if (this.pageNo > this.pageCount) {
                throw new RuntimeException(Messages.getString("TableViewerPager.5"));
            }
            NumberFormat format = NumberFormat.getInstance();
            this.sura.setText(" / ");
            this.totalPage.setText(String.valueOf(format.format(this.pageCount)) + Messages.getString("TableViewerPager.7"));
        } else {
            this.sura.setText("");
            this.totalPage.setText("");
        }
        this.setEnabledPagerButton();
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
        this.pageNoTxt.setText(String.valueOf(pageNo));
        this.setEnabledPagerButton();
    }

    private void setEnabledPagerButton() {
        IDBConfig config = this.table.getDbConfig();
        ISQLCreatorFactory factory = DefaultSQLCreatorFactory.getFactory(config, this.table);
        if (this.table != null && factory.isSupportPager()) {
            this.topPage.setEnabled(this.pageNo > 1);
            this.backPage.setEnabled(this.pageNo > 1);
            this.nextPage.setEnabled(this.pageNo < this.pageCount);
            this.endPage.setEnabled(this.pageNo < this.pageCount);
        } else {
            this.topPage.setEnabled(false);
            this.backPage.setEnabled(false);
            this.nextPage.setEnabled(false);
            this.endPage.setEnabled(false);
        }
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }
}

