/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.diff;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.diff.DDLDiffContentProvider;
import zigen.plugin.db.diff.DDLDiffContributor;
import zigen.plugin.db.diff.DDLDiffEditorInput;
import zigen.plugin.db.diff.DDLDiffViewer;
import zigen.plugin.db.diff.DDLLabelProvider;
import zigen.plugin.db.diff.DiffContentProvider;
import zigen.plugin.db.diff.DiffTreeSelectionHandler;
import zigen.plugin.db.diff.IDDLDiff;
import zigen.plugin.db.diff.Messages;
import zigen.plugin.db.diff.ProjectSelectDialog;

public class DDLDiffEditor
extends EditorPart {
    private IDDLDiff[] diffs;
    private DDLDiffViewer diffviewer;
    private TreeViewer treeViewer;
    private SashForm sash;
    private boolean isTableDiff = false;
    public static final String ID = "zigen.plugin.db.diff.DDLDiffEditor";
    boolean dirty = false;

    public void createPartControl(Composite parent) {
        CompareConfiguration cc = new CompareConfiguration();
        if (!this.isTableDiff) {
            this.sash = new SashForm(parent, 512);
            this.treeViewer = new TreeViewer((Composite)this.sash, 8391426);
            this.treeViewer.setContentProvider((IContentProvider)new DiffContentProvider());
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new DDLLabelProvider());
            this.treeViewer.setInput((Object)this.diffs);
            Composite body = new Composite((Composite)this.sash, 0x800800);
            body.setLayoutData((Object)new GridData(768));
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            gridLayout.makeColumnsEqualWidth = false;
            gridLayout.marginHeight = 1;
            gridLayout.marginWidth = 1;
            gridLayout.horizontalSpacing = 2;
            gridLayout.verticalSpacing = 2;
            body.setLayout((Layout)gridLayout);
            ToolBar toolBar = new ToolBar(body, 0x800000);
            toolBar.setLayoutData((Object)new GridData(128));
            ToolBarManager toolBarManager = new ToolBarManager(toolBar);
            Composite lower = new Composite(body, 0x800800);
            lower.setLayout((Layout)new FillLayout(256));
            lower.setLayoutData((Object)new GridData(1808));
            this.diffviewer = new DDLDiffViewer(lower, cc);
            this.diffviewer.addToolItems((IToolBarManager)toolBarManager);
            this.diffviewer.setContentProvider((IContentProvider)new DDLDiffContentProvider(cc));
            if (this.diffs != null && this.diffs.length >= 1) {
                this.diffviewer.setInput(this.diffs[0]);
            }
            this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)new DiffTreeSelectionHandler(this));
            TreeItem topItem = this.treeViewer.getTree().getTopItem();
            this.treeViewer.getTree().setSelection(new TreeItem[]{topItem});
            this.sash.setWeights(new int[]{30, 70});
            toolBarManager.update(true);
            this.hookContextMenu();
        } else {
            parent.setLayoutData((Object)new GridData(768));
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            gridLayout.makeColumnsEqualWidth = false;
            gridLayout.marginHeight = 1;
            gridLayout.marginWidth = 1;
            gridLayout.horizontalSpacing = 2;
            gridLayout.verticalSpacing = 2;
            parent.setLayout((Layout)gridLayout);
            ToolBar toolBar = new ToolBar(parent, 0x800000);
            toolBar.setLayoutData((Object)new GridData(128));
            ToolBarManager toolBarManager = new ToolBarManager(toolBar);
            Composite lower = new Composite(parent, 0x800800);
            lower.setLayout((Layout)new FillLayout(256));
            lower.setLayoutData((Object)new GridData(1808));
            this.diffviewer = new DDLDiffViewer(lower, cc);
            this.diffviewer.addToolItems((IToolBarManager)toolBarManager);
            this.diffviewer.setContentProvider((IContentProvider)new DDLDiffContentProvider(cc));
            if (this.diffs != null && this.diffs.length >= 1) {
                this.diffviewer.setInput(this.diffs[0]);
            }
            toolBarManager.update(true);
        }
    }

    private IToolBarManager getToolBarManager() {
        return this.getEditorSite().getActionBars().getToolBarManager();
    }

    public void dispose() {
        super.dispose();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSave(IProgressMonitor monitor) {
        ObjectOutputStream oos;
        ByteArrayOutputStream out;
        block18: {
            block19: {
                block20: {
                    out = null;
                    oos = null;
                    try {
                        try {
                            out = new ByteArrayOutputStream();
                            oos = new ObjectOutputStream(out);
                            oos.writeObject(this.diffs);
                            Shell shell = DbPlugin.getDefault().getShell();
                            ProjectSelectDialog dialog = new ProjectSelectDialog(shell, Messages.getString("DDLDiffEditor.0"));
                            if (dialog.open() != 0) break block18;
                            this.setDirty(false);
                            IContainer container = dialog.getContainer();
                            IFile file = container.getFile((IPath)new Path(dialog.getSaveFileName()));
                            ByteArrayInputStream is = new ByteArrayInputStream(out.toByteArray());
                            if (file.exists()) {
                                if (DbPlugin.getDefault().confirmDialog(Messages.getString("DDLDiffEditor.1"))) {
                                    file.delete(true, monitor);
                                } else {
                                    this.setDirty(true);
                                    Object var9_10 = null;
                                    if (oos == null) break block19;
                                    break block20;
                                }
                            }
                            file.create((InputStream)is, true, monitor);
                            this.setDirty(false);
                        }
                        catch (Exception e) {
                            DbPlugin.getDefault().showErrorDialog(e);
                            this.setDirty(true);
                        }
                        break block18;
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        if (oos != null) {
                            try {
                                oos.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (out == null) throw throwable;
                        try {
                            out.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                }
                try {}
                catch (IOException iOException) {}
                oos.close();
            }
            if (out == null) return;
            try {}
            catch (IOException iOException) {}
            out.close();
            return;
        }
        Object var9_12 = null;
        if (oos != null) {
            try {}
            catch (IOException iOException) {}
            oos.close();
        }
        if (out == null) return;
        try {}
        catch (IOException iOException) {
            return;
        }
        out.close();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean value) {
        this.dirty = value;
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        try {
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(editorInput);
            if (editorInput instanceof DDLDiffEditorInput) {
                DDLDiffEditorInput input = (DDLDiffEditorInput)editorInput;
                this.diffs = input.getDiffs();
                this.isTableDiff = input.isTableDiff();
                this.setPartName(input.getName());
                this.setDirty(true);
            } else if (editorInput instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
                ObjectInputStream in = new ObjectInputStream(file.getContents());
                this.diffs = (IDDLDiff[])in.readObject();
                in.close();
                this.setPartName(file.getName());
                this.setDirty(false);
                this.isTableDiff = false;
            }
        }
        catch (Exception e) {
            DbPlugin.log(e);
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    public void setFocus() {
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public DDLDiffViewer getDiffviewer() {
        return this.diffviewer;
    }

    public SashForm getSash() {
        return this.sash;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DDLDiffEditor.this.getContributor().fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
    }

    private DDLDiffContributor getContributor() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof DDLDiffContributor) {
            return (DDLDiffContributor)contributor;
        }
        return null;
    }
}

