/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import java.sql.SQLException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ui.actions.ConfirmConnectDBAction;
import zigen.plugin.db.ui.jobs.Messages;
import zigen.plugin.db.ui.jobs.SqlExecJob;

public class ScriptExecJob
extends SqlExecJob {
    public ScriptExecJob(Transaction trans, String sqlString, String secondarlyId) {
        super(trans, sqlString, secondarlyId);
        super.setName(Messages.getString("ScriptExecJob.0"));
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            if (!this.trans.isConneting()) {
                Display.getDefault().syncExec((Runnable)new ConfirmConnectDBAction(this.trans));
                if (!this.trans.isConneting()) {
                    this.showWarningMessage(DbPluginConstant.MSG_NO_CONNECTED_DB);
                    return Status.CANCEL_STATUS;
                }
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.executeSingleSQL(this.trans, this.sqlString);
            return Status.OK_STATUS;
        }
        catch (SQLException e) {
            this.showWarningMessage(e.getMessage());
        }
        catch (Exception e) {
            this.showErrorMessage(Messages.getString("SqlExecJob.2"), e);
        }
        return Status.OK_STATUS;
    }
}

