/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views.internal;

import org.eclipse.jface.text.IDocument;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.parser.util.CurrentSql;
import zigen.sql.parser.ASTVisitor2;
import zigen.sql.parser.INode;
import zigen.sql.parser.IVisitor;
import zigen.sql.parser.SqlParser;
import zigen.sql.parser.ast.ASTRoot;
import zigen.sql.parser.exception.ParserException;

public class ParseSqlThread
implements Runnable {
    INode fNode;
    ASTVisitor2 fVisitor;
    boolean isComplete;
    CurrentSql fCurrentSql;
    protected IDocument fDocument;
    protected int offset;

    public ParseSqlThread(IDocument document, int offset) {
        this.offset = offset;
        this.fDocument = document;
        this.fVisitor = new ASTVisitor2();
    }

    public void run() {
        try {
            this.fCurrentSql = this.createCurrentSql();
            SqlParser parser = new SqlParser(this.fCurrentSql.getSql(), DbPlugin.getSqlFormatRult());
            this.fNode = new ASTRoot();
            parser.parse(this.fNode);
            this.fNode.accept((IVisitor)this.fVisitor, null);
            this.isComplete = true;
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        catch (StackOverflowError e) {
            e.printStackTrace();
        }
    }

    protected CurrentSql createCurrentSql() {
        String demiliter = DbPlugin.getDefault().getPreferenceStore().getString("SQLEditorPreferencePage.SqlDemiliter");
        return new CurrentSql(this.fDocument, this.offset, demiliter);
    }

    public INode getNode() {
        return this.fNode;
    }

    public ASTVisitor2 getVisitor() {
        return this.fVisitor;
    }

    public String getSql() {
        return this.fCurrentSql == null ? null : this.fCurrentSql.getSql();
    }

    public int getBeginOffset() {
        return this.fCurrentSql == null ? 0 : this.fCurrentSql.getBegin();
    }

    public boolean isComplete() {
        return this.isComplete;
    }
}

