unit DMonkey;

(*
  DMS(DMonkey Script) by Project DMonkey
  License: BSD
           ̃Cu͖ۏ؂łB
           gpAρAzzɈ؂̐͂܂B
           ҂ɒʒm⃉CZX\Kv܂B
  History:
  2005/07/29 ver.0.3.9
          Global.nameOf()ŃIuWFNg擾(RXgN^ƓƂ͌Ȃ)
          DynaCall.sendMessage() .postMessage()̈̌^𖾎w肷dlɕύX
          StringBuffer.substr()̏C
          String.substring() StringBuffer.substring()ňȗ͍Ō܂Ŏo悤ɕύX
          ecma_misc.pas MB֐QC

  2005/07/24 ver.0.3.8.1
          TJEngine.Run(), TJEngine.CallFunction() ̏C

  2005/07/23 ver.0.3.8
          StringBuffer.indexOf() .lastIndexOf()AnsiPosgȂ悤ύX
          TJStringBufferObject̓Ył̑𕶎񂩂當ɕύX
          String.multiply()
          String.charAt() .charCodeAt()ŃCfbNX͈̔̓`FbN悤C
          Math.max() .min()3ȏ悤ύX
          StringBuffer.charCodeAt()ŃCfbNX͈̔̓`FbN悤C
          VCLListBox.clearSelection() .deleteSelected() .selectAll()
          Global.isFinite()
          TJActiveXObject.GetValue2ȏ̈n悤C(Excel.cells΍)
          DynaCall̎QƓnp[^(1,2,4,8)NumberIuWFNgnƒlf
          Number.asCharŐl(R[h)𕶎Ŏ擾/ݒ
          OA~ɂCxg[vɓĂ܂ꍇ̂C

  2005/07/08 ver.0.3.7
          DynaCall.copyMemory() .fillMemory()
          StringBuffer.fill()
          DynaCall.sendMessage() .postMessage()Struct|C^n悤C
          String.slice()̏C

  2005/07/05 ver.0.3.6.1
          Object.getKeys() .getMethods() .getProperties() ̏C

  2005/06/26 ver.0.3.6
          TJHTTPObject.DoResponse()ŃvgRG[̏ꍇłwb_擾悤C
          Strings.caseSensitive .duplicates
          regexpr.pasver0.952
          StringBuffer.indexOf() .lastIndexOf() .slice() .substr()
          StringBuffer.substring()C
          VCLListView.ItemIndex
          Dialog.filters
          ecma_type.Get/SetDefaultPropertyChar^悤C
          @VERSION7Kpfor..inŃANZXᔽN邱Ƃ̂C
          File,Directorÿꕔ\bhƂ悤
           (ȗ͍܂Œʂfilename,dirnamevpeB̕񂪑Ώ)
          Keyboard.isDown()ɉzL[R[hn悤ɕύX
          TJRegExpObject.ToString()
          K\eecma_type.AsString(),TypeOf()ŕԂlύX
          String.charCodeAt() .fromCharCode()2oCg悤
          Struct.clear() .define()
          Number.toString()8iɂϊł悤

  2003/05/20 ver.0.3.5
          WScript.ArgumentsɑOs̈nĂ̂C
          Zq^=gȂ̂C
          Global.platformOS 'win32s'|'windows'|'nt'
          TJEngine.EvalStatement̍Ōtemporary objectJ悤ɏC

  2003/04/11 ver.0.3.4
          String.lastIndexOf()̏C
          TJStruct̏C
          VCLMemo.textvpeB

  2003/04/09 ver.0.3.3
          TJEngine.CallArrayExpr()̏C

  2003/04/08 ver.0.3.2
          ֐̃VACŶC

  2003/04/07 ver.0.3.1
          PZq+C
          l^̎Qƕւ̕ϊC
          Date.formatŏw('ggee yyyy/mm/dd(aaaa) ampm hh:nn:ss')
          z̏ZsyntaxG[ɂȂĂ̂C
          /*...**/ƃRgIȂ̂CB
          DynaCallœo^֐'s'p[^nullw肵ƂNULL(0)n悤ɂB
          DynaCallIuWFNgsendMessage()\bhǉB
          DynaCallIuWFNgpostMessage()\bhǉB
          StructIuWFNgǉB
          StringBufferIuWFNg̍쐬gB
          StructIuWFNǧ^'i','w'ǉB
          NumberIuWFNg̔r̂CB
          NaN̈ύXB
          Global.msgBox()̈gB

  2003/02/23 ver.0.3.0
          TvC
          TJObject̃ftHgvpeBNameTag𖳎Ă̂C
          ֐
          HTTPS܂ƂɓĂȂ̂C
          LibraryPathɃJgfBNgǉ
          object쐬QuoteStringNumberg悤C { "a" : 0 }
          StringIuWFNg蒼
          StringBufferIuWFNg String
          Number.toChar()Ő̕R[h𕶎ɕύX
          ()[]̈𓯂ɂ
          ֐ւ̑...̍Ōɑlǉ܂
          newłObjecy쐬Ŋ֐w肷ƃRXgN^
          OnErrorCxg
          ĨG[C
          $ϐɎg悤C
          TJCookieObjectC
          TJArrayObject.GetValueύX
          prototype
          Date.getTime()~bPʂɏC
          deleteC
          TJStringsObject.ToStringC
          Directory.clear() .findfiles() .files .directories
          Global.format() .formatFloat()
          CheckListBox.index
          ecma_expr.pasCalcValueecma_type.pasֈړ
          function.call() .apply() .callee()
          Array.assign()
          File.path
          Directory.path
          undefinedԂ\bhthisIuWFNgԂ悤ɏC
          TJObject.ToInteger .ToDouble폜 .ToNumberɓ
          CalcValue2ŃIuWFNg̉ZC
          ϐ錾varƃ[JAꍇ̓O[o(TDMonkey.DeclareLocalVar)
          ActiveX̃Cxg
          VCLIuWFNg
          OnDoEventsCxg
          GarbageCollectvpeB폜̂ŃR|[lgēo^Ă
          W^Ɨ񋓌^vpeB͕ɕϊ
          TJObject.CreatëύX
          RegExp̓ύX
          eval()܂Ƃɓ悤C
          TJNotifygObject̏Iʒm󂯂邱Ƃł܂
          staticEglobal錾ŐÓIϐ(@varƓ)
          try catch finallyC
          \PbgIuWFNgɃCxg
          TJIniObject.update() writeginiXV邽߂updateĂiCt܂łcj
          TJBaseArrayObject̉z\bhTJObjectֈړ
          String.replace()ŃTu}b`$n̒uAuɊ֐w
          K\̃IuWFNg̏ȗo  $& $' $* $+ $_ $`
          Object.getKeys() .getProperties() .getMethods()ArrayԂ悤ɕύX

  2002/12/29 ver.0.2.1
          caseC
          RpC @set @xxx = [bool|int]
          for..inłArrayftHgŃCfbNXɐݒ u@set @VERSION7 = truev ŗvf
          ɍsԍ܂߂
          K\e[N鎖̂C
          @set @SHORT_CIRCUIT = false ŏ̊S]
          Global.encodeURI,encodeURIComponent,decodeURI,decodeURIComponent

  2002/12/26 ver.0.2.0.3
          caseAŕׂȂ̂C

  2002/12/26 ver.0.2.0.2
          xɕtgȂ̂C

  2002/12/25 ver.0.2.0.1
          ActiveXPropertyGetC

  2002/12/23 ver.0.2.0
          shobohñR[h}[W
          gq̒`(ecma_type.pas)
          gObjectIC|[g邽߂$DEFINE
          ComplieLibPathǉ
          evalC
          QƃJEg̃R[h
          ȇÔƂeĂ̂CB(ecma_lex.pas)
          bZ[W{bNX̃I[i[̗Lw肷$DEFINEǉB(ecma_misc.pas)
          String.crypt([salt]) UnixDES crypt(3)BPerl݊łB
          OnStdinCxgGlobal.read() Global.readln()
          K\e /patern/ig
          switch
          Global.scriptEngineVersion()
          constructorŗONobject̃ANZXᔽC
          RpCς݃oCi(gq .dmc)
          for(var i=0; ... G[ɂȂȂ悤C
          VQƃJEg
          FTPIuWFNg
          RegExp.replaceC
          Global.isConsole()
          z()ŃANZX  a = [1]; println(a(0));
          Global.args폜
          WScriptIuWFNgisSj
          ActiveXObject̃vpeBĂяoC
          RegExp.multiline  mIvV
          EnumeratorIuWFNg
          for..inŃRNVArray̏ꍇ͗vfԂ悤ɏC
          ArrayIuWFNgTJBaseArrayObject`(count,lengthfor..ingObject͌p邱Ƃ𐄏)
          TJStringsTJBaseArrayObjectpɕύX
          TJHtmlParserObjectTJBaseArrayObjectpɕύX
          String.trim() trimLeft() trimRight() E󔒕폜
          TJStringObjectTJBaseArrayObjectpɕύX
          ֐varG[ɂȂĂ̂C
          zvf1̎Az񐔂ɂȂĂ̂C a = [5]

  2002/05/25 ver.0.1.7
          scriptEngine()Ȃǂ`

  2002/05/20 ver.0.1.6
          HtmlParser
          RegExp.test()̏C
          ̑

  2002/05/15 ver.0.1.5
          DatȅC

  2002/05/11 ver.0.1.4
          XNvg̑Sp󔒂𖳎悤ɏC
          RegIni
          DatȅC

  2002/04/23 Ver.0.1.3
          Object̂QC

  2002/04/14 Ver.0.1.2
          TJObjectFactory̎dlύXidvjɂTJObject̓RXgN^TJObjectFactoryɎIɏL܂BNewObject\bh͎gpȂłB
          vpeBFactoryǉ
          QƃJEg̏CiUSE_GCKvj
          CheckListBox
  2002/03/21 Ver.0.1.1
          DynaCall̏C
  2002/03/20 Ver.0.1.0
          Cxg̓o^ύX
          DynaCallIuWFNg
  2002/03/10 Ver.0.0.15
          Datě0`11ɕύX
          ArrayIuWFNg̏
          OnStepCxgǉ(XNvg̒fȂǂɎgp)
          K\Cu̕ύX
          String.toUTF8()ǉ
          String.fromUTF8toSJIS()ǉ
  2002/03/06 Ver.0.0.14
          Objecto̎QƃJEgC
          z񎮂̏C
          ArrayIuWFNg̏C
  2002/02/07 Ver.0.0.13
          oC
  2002/02/06 Ver.0.0.12
          IDispatcȟĂяoC
  2002/02/02 Ver.0.0.11
          ClipboardIuWFNg
  2002/02/01 Ver.0.0.10
          ActiveX\bhƃvpeBĂяoC
  2002/01/28 Ver.0.0.9
            KeyboardMouseIuWFNg
  2002/01/27 Ver.0.0.8
            oOC
  2001/11/16 Ver.0.0.7
            G[o
          published property̕P[X𖳎
  2001/05/09 Ver.0.0.6
            var
  2001/05/06 Ver.0.0.5
            import
  2001/05/04 Ver.0.0.4
            NX`
  2001/05/04 Ver.0.0.3
            ActiveXObject
  2001/05/02 Ver.0.0.2
          breakcontinueC
  2001/04/30 Ver.0.0.1
          
*)


{$IFDEF CONSOLE}
  {$DEFINE NO_VCL}
  {$DEFINE NO_GUI}
{$ENDIF}

interface

uses
  Windows, SysUtils, Classes,
  ecma_lex,ecma_parser,ecma_type,ecma_engine,
{$IFNDEF NO_EXTENSION}
  ecma_extobject,
{$ENDIF}
{$IFNDEF NO_SOCKET}
  ecma_sockobject,
{$ENDIF}
{$IFNDEF NO_ACTIVEX}
  ecma_activex,
{$ENDIF}
{$IFNDEF NO_DYNACALL}
  ecma_dynacall,
{$ENDIF}
{$IFNDEF NO_GUI}
  ecma_guiobject,
{$ENDIF}
{$IFNDEF NO_VCL}
  ecma_vcl,
{$ENDIF}
  ecma_object,ecma_misc;

type
  TDMonkey = class(TJBaseDMonkey)
  private
    FEngine: TJEngine;

    FErrorText: String;
    FTookTimeToCompile: Cardinal;
    FTookTimeToRun: Cardinal;
    FTookTimeToCallFunction: Cardinal;
    FCompiledBinary: Boolean;
    //Cxg
    FOnStdout: TStringEvent;
    FOnDebugout: TStringEvent;
    FOnNewObject: TNewObjectEvent;
    FOnStderr: TStringEvent;
    FOnRun: TNotifyEvent;
    FOnDone: TNotifyEvent;
    FOnStep: TStepEvent;
    FOnStdin: TReadStringEvent;
    FOnError: TErrorEvent;
    FOnDoEvents: TStepEvent;
    //
    procedure EngineOnDebug(Sender: TObject; S: String);
    procedure EngineOnStdout(Sender: TObject; S: String);
    procedure EngineOnStderr(Sender: TObject; S: String);
    procedure EngineOnNewObject(Sender: TObject; JObject: TJObject);
    procedure EngineOnRun(Sender: TObject);
    procedure EngineOnDone(Sender: TObject);
    procedure EngineOnStep(Sender: TObject; var AbortScript: Boolean);
    procedure EngineOnStdin(Sender: TObject; var S: String; var Success: Boolean;
      Count: Integer; Line: Boolean);
    procedure EngineOnError(Sender: TObject; LineNo: Integer; Msg: String);
    procedure EngineOnDoEvents(Sender: TObject; var AbortScript: Boolean);

    function GetLibraryPath: TStrings;
    procedure SetLibraryPath(const Value: TStrings);
    function GetObjectCount: Integer;
    procedure SetOnDone(const Value: TNotifyEvent);
    procedure SetOnNewObject(const Value: TNewObjectEvent);
    procedure SetOnRun(const Value: TNotifyEvent);
    procedure SetOnStderr(const Value: TStringEvent);
    procedure SetOnStep(const Value: TStepEvent);
    procedure SetOnStdout(const Value: TStringEvent);
    procedure SetOnStdin(const Value: TReadStringEvent);
    function GetLineNumber: Integer;
    procedure SetOnError(const Value: TErrorEvent);
    procedure SetOnDebugout(const Value: TStringEvent);
    function GetFilename: String;
    procedure SetOnDoEvents(const Value: TStepEvent);
    function GetFactory: TJObjectFactory;
    function GetRegistVar: TJRegistVarType;
    procedure SetRegistVar(const Value: TJRegistVarType);

  protected
    procedure RegistDMSObjects; virtual;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function Compile(SourceCode: String): Boolean;
    function CompileFile(AFilename: String): Boolean;
    function Run(Args: array of const): Integer; overload;
    function Run(Args: TJValueList): Integer; overload;
    function Run: Integer; overload;
    function CallFunction(Symbol: String; Param: array of const; var RetValue: TJValue): Boolean; overload;
    function CallFunction(Symbol: String; Param: TJValueList; var RetValue: TJValue): Boolean; overload;
    procedure Clear;
    procedure Abort;
    procedure ImportObject(ObjectName: String; ObjectClass: TJObjectClass);
    function IsRunning: Boolean;
    class function ScriptBuild: Integer;
    class function ScriptEngine: String;
    class function ScriptVersion: String;

    property ObjectCount: Integer read GetObjectCount;
    property Factory: TJObjectFactory read GetFactory;
    property TookTimeToCompile: Cardinal read FTookTimeToCompile write FTookTimeToCompile;
    property TookTimeToRun: Cardinal read FTookTimeToRun write FTookTimeToRun;
    property TookTimeToCallFunction: Cardinal read FTookTimeToCallFunction write FTookTimeToCallFunction;
    property ScriptFilename: String read GetFilename;
    property LineNumber: Integer read GetLineNumber;
    //var錾Ȃϐo^̓
    property RegistVar: TJRegistVarType read GetRegistVar write SetRegistVar;
  published
    property LibraryPath: TStrings read GetLibraryPath write SetLibraryPath;
    property CompiledBinary: Boolean read FCompiledBinary write FCompiledBinary;
    //Cxg
    property OnStdout: TStringEvent read FOnStdout write SetOnStdout;
    property OnStderr: TStringEvent read FOnStderr write SetOnStderr;
    property OnDebugout: TStringEvent read FOnDebugout write SetOnDebugout;
    property OnNewObject: TNewObjectEvent read FOnNewObject write SetOnNewObject;
    property OnRun: TNotifyEvent read FOnRun write SetOnRun;
    property OnDone: TNotifyEvent read FOnDone write SetOnDone;
    property OnStep: TStepEvent read FOnStep write SetOnStep;
    property OnStdin: TReadStringEvent read FOnStdin write SetOnStdin;
    property OnError: TErrorEvent read FOnError write SetOnError;
    property OnDoEvents: TStepEvent read FOnDoEvents write SetOnDoEvents;
  end;

  TDMS = class(TDMonkey);


procedure ShowDMonkeyException(DMonkey: TDMonkey);


procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TDMS]);
end;


procedure ShowDMonkeyException(DMonkey: TDMonkey);
//G[\
var
  caption,text: String;
begin
  caption := GetApplicationTitle;
  if DMonkey.ScriptFilename <> '' then
    caption := caption + ' - ' + ExtractFilename(DMonkey.ScriptFilename);

  text := DMonkey.FErrorText;
  MsgBox(PChar(text), PChar(caption), MB_OK or MB_ICONHAND);
end;


{ TDMonkey }

procedure TDMonkey.Abort;
//~
begin
  FEngine.Abort;
end;

function TDMonkey.CallFunction(Symbol: String; Param: TJValueList; var RetValue: TJValue): Boolean;
//֐Ăяo
var
  tmp: Cardinal;
begin
  //Ԍv
  tmp := GetTickCount;
  try
    Result := FEngine.CallFunction(Symbol,Param,RetValue);
  finally
    FTookTimeToCallFunction := GetTickCount - tmp;
  end;
end;

function TDMonkey.CallFunction(Symbol: String;
  Param: array of const; var RetValue: TJValue): Boolean;
//֐Ăяo
var
  list: TJValueList;
  i: Integer;
  v: TJValue;
begin
  list := TJValueList.Create;
  try
    //ϊ
    for i := 0 to High(Param) do
    begin
      v := VarRecToValue(Param[i]);
      //QƃJEg𑝂₷
      if IsObject(@v) then
        v.vObject.IncRef;

      list.Add(v);
    end;

    Result := CallFunction(Symbol,list,RetValue);
  finally
    list.Free;
  end;
end;

procedure TDMonkey.Clear;
//f[^NA
begin
  FEngine.Clear;
end;

function TDMonkey.Compile(SourceCode: String): Boolean;
//͖؂
var
  tmp: Cardinal;
begin
  //RpC
  tmp := GetTickCount;
  try
    Result := FEngine.Compile(SourceCode);
  finally
    //RpC
    FTookTimeToCompile := GetTickCount - tmp;
  end;
end;

function TDMonkey.CompileFile(AFilename: String): Boolean;
var
  tmp: Cardinal;
begin
  tmp := GetTickCount;
  try
    Result := FEngine.CompileFile(AFilename,FCompiledBinary);
  finally
    //RpC
    FTookTimeToCompile := GetTickCount - tmp;
  end;
end;

constructor TDMonkey.Create(AOwner: TComponent);
//쐬
begin
  inherited;
  FEngine := TJEngine.Create(Self);
  //gobjectC|[g
  RegistDMSObjects;
end;

destructor TDMonkey.Destroy;
//j
begin
  Clear;
  FreeAndNil(FEngine);
  inherited;
end;

procedure TDMonkey.EngineOnDone(Sender: TObject);
begin
 if Assigned(FOnDone) then
   FOnDone(Self);
end;

procedure TDMonkey.EngineOnNewObject(Sender: TObject; JObject: TJObject);
//object 쐬Cxg
begin
  if Assigned(FOnNewObject) then
    FOnNewObject(Self,JObject);
end;

procedure TDMonkey.EngineOnRun(Sender: TObject);
begin
  if Assigned(FOnRun) then
    FOnRun(Self);
end;

procedure TDMonkey.EngineOnStderr(Sender: TObject; S: String);
//WG[
begin
  FErrorText := S;
  if Assigned(FOnStderr) then
    FOnStderr(Self,S);
end;

procedure TDMonkey.EngineOnStdout(Sender: TObject; S: String);
//Wo
begin
  if Assigned(FOnStdout) then
    FOnStdout(Self,S);
end;

procedure TDMonkey.EngineOnStep(Sender: TObject; var AbortScript: Boolean);
begin
  if Assigned(FOnStep) then
    FOnStep(Self,AbortScript);
end;

function TDMonkey.GetLibraryPath: TStrings;
begin
  Result := FEngine.Parser.LibPath;
end;

function TDMonkey.GetObjectCount: Integer;
begin
  Result := FEngine.ObjectCount;
end;

procedure TDMonkey.ImportObject(ObjectName: String;
  ObjectClass: TJObjectClass);
//g݃IuWFNgC|[g
begin
  FEngine.ImportObject(ObjectName,ObjectClass);
end;

function TDMonkey.IsRunning: Boolean;
begin
  Result := FEngine.IsRunning;
end;

procedure TDMonkey.EngineOnDebug(Sender: TObject; S: String);
//fobO
begin
  if Assigned(FOnDebugout) then
    FOnDebugout(Self,S);
end;

function TDMonkey.Run(Args: array of const): Integer;
//scripts
var
  i: Integer;
  param: TJValueList;
begin
  param := TJValueList.Create;
  try
    for i := 0 to High(Args) do
      param.Add(VarRecToValue(Args[i]));

    Result := Run(param);
  finally
    param.Free;
  end;
end;

function TDMonkey.Run(Args: TJValueList): Integer;
//s
var
  tmp: Cardinal;
begin
  //s
  tmp := GetTickCount;
  try
    Result := FEngine.Run(nil,Args);
  finally
    FTookTimeToRun := GetTickCount - tmp;
  end;
end;

function TDMonkey.Run: Integer;
//s
begin
  Result := Run([]);
end;

procedure TDMonkey.SetLibraryPath(const Value: TStrings);
begin
  FEngine.Parser.LibPath.Assign(Value);
end;

procedure TDMonkey.SetOnDone(const Value: TNotifyEvent);
begin
  FOnDone := Value;
  if Assigned(Value) then
    FEngine.OnDone := EngineOnDone
  else
    FEngine.OnDone := nil;
end;

procedure TDMonkey.SetOnNewObject(const Value: TNewObjectEvent);
begin
  FOnNewObject := Value;
  if Assigned(Value) then
    FEngine.OnNewObject := EngineOnNewObject
  else
    FEngine.OnNewObject := nil;
end;

procedure TDMonkey.SetOnRun(const Value: TNotifyEvent);
begin
  FOnRun := Value;
  if Assigned(Value) then
    FEngine.OnRun := EngineOnRun
  else
    FEngine.OnRun := nil;
end;

procedure TDMonkey.SetOnStderr(const Value: TStringEvent);
begin
  FOnStderr := Value;
  if Assigned(Value) then
    FEngine.OnStdErr := EngineOnStdErr
  else
    FEngine.OnStdErr := nil;
end;

procedure TDMonkey.SetOnStep(const Value: TStepEvent);
begin
  FOnStep := Value;
  if Assigned(Value) then
    FEngine.OnStep := EngineOnStep
  else
    FEngine.OnStep := nil;
end;

procedure TDMonkey.SetOnStdout(const Value: TStringEvent);
begin
  FOnStdout := Value;
  if Assigned(Value) then
    FEngine.OnStdOut := EngineOnStdOut
  else
    FEngine.OnStdOut := nil;
end;

class function TDMonkey.ScriptBuild: Integer;
begin
  Result := DMS_BUILD;
end;

class function TDMonkey.ScriptEngine: String;
begin
  Result := DMS_ENGINE;
end;

class function TDMonkey.ScriptVersion: String;
begin
  Result := DMS_VERSION;
end;

procedure TDMonkey.EngineOnStdin(Sender: TObject; var S: String; var Success: Boolean;
  Count: Integer; Line: Boolean);
//W
begin
  if Assigned(FOnStdin) then
    FOnStdin(Self,S,Success,Count,Line);
end;

procedure TDMonkey.SetOnStdin(const Value: TReadStringEvent);
begin
  FOnStdin := Value;
  if Assigned(Value) then
    FEngine.OnStdin := EngineOnStdin
  else
    FEngine.OnStdin := nil;
end;

function TDMonkey.GetLineNumber: Integer;
begin
  Result := FEngine.LineNo;
end;

procedure TDMonkey.SetOnError(const Value: TErrorEvent);
begin
  FOnError := Value;
  if Assigned(Value) then
    FEngine.OnError := EngineOnError
  else
    FEngine.OnError := nil;
end;

procedure TDMonkey.EngineOnError(Sender: TObject; LineNo: Integer;
  Msg: String);
begin
  if Assigned(FOnError) then
    FOnError(Self,LineNo,Msg);
end;

procedure TDMonkey.RegistDMSObjects;
//gobjectC|[g
begin
{$IFNDEF NO_EXTENSION}
  ecma_extobject.RegisterDMS(FEngine);
{$ENDIF}
{$IFNDEF NO_SOCKET}
  ecma_sockobject.RegisterDMS(FEngine);
{$ENDIF}
{$IFNDEF NO_ACTIVEX}
  ecma_activex.RegisterDMS(FEngine);
{$ENDIF}
{$IFNDEF NO_DYNACALL}
  ecma_dynacall.RegisterDMS(FEngine);
{$ENDIF}
{$IFNDEF NO_GUI} {$IFNDEF CONSOLE}
  ecma_guiobject.RegisterDMS(FEngine);
{$ENDIF}         {$ENDIF}
{$IFNDEF NO_VCL} {$IFNDEF CONSOLE}
  ecma_vcl.RegisterDMS(FEngine);
{$ENDIF}         {$ENDIF}
end;

procedure TDMonkey.SetOnDebugout(const Value: TStringEvent);
begin
  FOnDebugout := Value;
  if Assigned(Value) then
    FEngine.OnDebugout := EngineOnDebug
  else
    FEngine.OnDebugout := nil;
end;

function TDMonkey.GetFilename: String;
begin
  Result := FEngine.ScriptFilename;
end;

procedure TDMonkey.EngineOnDoEvents(Sender: TObject;
  var AbortScript: Boolean);
begin
  if Assigned(FOnDoEvents) then
    FOnDoEvents(Self,AbortScript);
end;

procedure TDMonkey.SetOnDoEvents(const Value: TStepEvent);
begin
  FOnDoEvents := Value;
  if Assigned(Value) then
    FEngine.OnDoEvents := EngineOnDoEvents
  else
    FEngine.OnDoEvents := nil;
end;

function TDMonkey.GetFactory: TJObjectFactory;
begin
  Result := FEngine.Factory;
end;

function TDMonkey.GetRegistVar: TJRegistVarType;
begin
  Result := FEngine.RegistVar;
end;

procedure TDMonkey.SetRegistVar(const Value: TJRegistVarType);
begin
  FEngine.RegistVar := Value;
end;

end.
