/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start.fileinits;

import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.FileInitializer;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.start.Utils;

public class MavenLocalRepoFileInitializer
extends FileInitializer {
    private Path localRepositoryDir;
    private final boolean readonly;

    public MavenLocalRepoFileInitializer(BaseHome baseHome) {
        this(baseHome, null, true);
    }

    public MavenLocalRepoFileInitializer(BaseHome baseHome, Path localRepoDir, boolean readonly) {
        super(baseHome, "maven");
        this.localRepositoryDir = localRepoDir;
        this.readonly = readonly;
    }

    @Override
    public boolean create(URI uri, String location) throws IOException {
        Path localRepoFile;
        Coordinates coords = this.getCoordinates(uri);
        if (coords == null) {
            return false;
        }
        Path destination = this.getDestination(uri, location);
        if (this.isFilePresent(destination)) {
            return false;
        }
        if (this.localRepositoryDir != null && (localRepoFile = this.getLocalRepoFile(coords)) != null) {
            if (FS.ensureDirectoryExists(destination.getParent())) {
                StartLog.log("MKDIR", this._basehome.toShortForm(destination.getParent()));
            }
            StartLog.log("COPY ", "%s to %s", localRepoFile, this._basehome.toShortForm(destination));
            Files.copy(localRepoFile, destination, new CopyOption[0]);
            return true;
        }
        this.download(coords.toCentralURI(), destination);
        return true;
    }

    private Path getLocalRepoFile(Coordinates coords) throws IOException {
        Path localFile = this.localRepositoryDir.resolve(coords.toPath());
        if (FS.canReadFile(localFile)) {
            return localFile;
        }
        if (!this.readonly) {
            this.download(coords.toCentralURI(), localFile);
            return localFile;
        }
        return null;
    }

    public Coordinates getCoordinates(URI uri) {
        if (!"maven".equalsIgnoreCase(uri.getScheme())) {
            return null;
        }
        String ssp = uri.getSchemeSpecificPart();
        if (ssp.startsWith("//")) {
            ssp = ssp.substring(2);
        }
        String[] parts = ssp.split("/");
        if (StartLog.isDebugEnabled()) {
            StartLog.debug("ssp = %s", ssp);
            StartLog.debug("parts = %d", parts.length);
            for (int i = 0; i < parts.length; ++i) {
                StartLog.debug("  part[%2d]: [%s]", i, parts[i]);
            }
        }
        if (parts.length < 3) {
            throw new RuntimeException("Not a valid maven:// uri - " + uri);
        }
        Coordinates coords = new Coordinates();
        coords.groupId = parts[0];
        coords.artifactId = parts[1];
        coords.version = parts[2];
        coords.type = "jar";
        coords.classifier = null;
        if (parts.length >= 4) {
            if (Utils.isNotBlank(parts[3])) {
                coords.type = parts[3];
            }
            if (parts.length == 5 && Utils.isNotBlank(parts[4])) {
                coords.classifier = parts[4];
            }
        }
        return coords;
    }

    public static class Coordinates {
        public String groupId;
        public String artifactId;
        public String version;
        public String type;
        public String classifier;

        public String toPath() {
            StringBuilder pathlike = new StringBuilder();
            pathlike.append(this.groupId.replace('.', '/'));
            pathlike.append('/').append(this.artifactId);
            pathlike.append('/').append(this.version);
            pathlike.append('/').append(this.artifactId);
            pathlike.append('-').append(this.version);
            if (this.classifier != null) {
                pathlike.append('-').append(this.classifier);
            }
            pathlike.append('.').append(this.type);
            return pathlike.toString();
        }

        public URI toCentralURI() {
            return URI.create("http://central.maven.org/maven2/" + this.toPath());
        }
    }
}

