/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start.fileinits;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.FileInitializer;

public class UriFileInitializer
extends FileInitializer {
    public UriFileInitializer(BaseHome baseHome) {
        super(baseHome, "http", "https");
    }

    @Override
    public boolean create(URI uri, String location) throws IOException {
        Path destination = this.getDestination(uri, location);
        if (Files.isDirectory(destination, new LinkOption[0])) {
            destination = destination.resolve(uri.getSchemeSpecificPart().substring(uri.getRawSchemeSpecificPart().lastIndexOf(47) + 1));
        }
        if (this.isFilePresent(destination)) {
            return false;
        }
        this.download(uri, destination);
        return true;
    }
}

