/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.algorithms.implementations;

import com.sun.org.apache.xml.internal.security.algorithms.JCEMapper;
import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithmSpi;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.sun.org.apache.xml.internal.security.utils.JavaUtils;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SignatureDSA
extends SignatureAlgorithmSpi {
    private static Logger log = Logger.getLogger(SignatureDSA.class.getName());
    private Signature signatureAlgorithm = null;
    private int size;

    @Override
    protected String engineGetURI() {
        return "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    }

    public SignatureDSA() throws XMLSignatureException {
        String string = JCEMapper.translateURItoJCEID(this.engineGetURI());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Created SignatureDSA using " + string);
        }
        String string2 = JCEMapper.getProviderId();
        try {
            this.signatureAlgorithm = string2 == null ? Signature.getInstance(string) : Signature.getInstance(string, string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Object[] objectArray = new Object[]{string, noSuchAlgorithmException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            Object[] objectArray = new Object[]{string, noSuchProviderException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.setParameter(algorithmParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLSignatureException("empty", invalidAlgorithmParameterException);
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws XMLSignatureException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Called DSA.verify() on " + Base64.encode(byArray));
            }
            byte[] byArray2 = JavaUtils.convertDsaXMLDSIGtoASN1(byArray, this.size / 8);
            return this.signatureAlgorithm.verify(byArray2);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
        catch (IOException iOException) {
            throw new XMLSignatureException("empty", iOException);
        }
    }

    @Override
    protected void engineInitVerify(Key key) throws XMLSignatureException {
        if (!(key instanceof PublicKey)) {
            String string = key.getClass().getName();
            String string2 = PublicKey.class.getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this.signatureAlgorithm.initVerify((PublicKey)key);
        }
        catch (InvalidKeyException invalidKeyException) {
            Signature signature = this.signatureAlgorithm;
            try {
                this.signatureAlgorithm = Signature.getInstance(this.signatureAlgorithm.getAlgorithm());
            }
            catch (Exception exception) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Exception when reinstantiating Signature:" + exception);
                }
                this.signatureAlgorithm = signature;
            }
            throw new XMLSignatureException("empty", invalidKeyException);
        }
        this.size = ((DSAKey)((Object)key)).getParams().getQ().bitLength();
    }

    @Override
    protected byte[] engineSign() throws XMLSignatureException {
        try {
            byte[] byArray = this.signatureAlgorithm.sign();
            return JavaUtils.convertDsaASN1toXMLDSIG(byArray, this.size / 8);
        }
        catch (IOException iOException) {
            throw new XMLSignatureException("empty", iOException);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    @Override
    protected void engineInitSign(Key key, SecureRandom secureRandom) throws XMLSignatureException {
        if (!(key instanceof PrivateKey)) {
            String string = key.getClass().getName();
            String string2 = PrivateKey.class.getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this.signatureAlgorithm.initSign((PrivateKey)key, secureRandom);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("empty", invalidKeyException);
        }
        this.size = ((DSAKey)((Object)key)).getParams().getQ().bitLength();
    }

    @Override
    protected void engineInitSign(Key key) throws XMLSignatureException {
        if (!(key instanceof PrivateKey)) {
            String string = key.getClass().getName();
            String string2 = PrivateKey.class.getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this.signatureAlgorithm.initSign((PrivateKey)key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("empty", invalidKeyException);
        }
        this.size = ((DSAKey)((Object)key)).getParams().getQ().bitLength();
    }

    @Override
    protected void engineUpdate(byte[] byArray) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.update(byArray);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    @Override
    protected void engineUpdate(byte by) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.update(by);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.update(byArray, n, n2);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    @Override
    protected String engineGetJCEAlgorithmString() {
        return this.signatureAlgorithm.getAlgorithm();
    }

    @Override
    protected String engineGetJCEProviderName() {
        return this.signatureAlgorithm.getProvider().getName();
    }

    @Override
    protected void engineSetHMACOutputLength(int n) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.HMACOutputLengthOnlyForHMAC");
    }

    @Override
    protected void engineInitSign(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.CannotUseAlgorithmParameterSpecOnDSA");
    }

    public static class SHA256
    extends SignatureDSA {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2009/xmldsig11#dsa-sha256";
        }
    }
}

