/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.ConstructorProperties;
import javax.swing.border.AbstractBorder;

public class BevelBorder
extends AbstractBorder {
    public static final int RAISED = 0;
    public static final int LOWERED = 1;
    protected int bevelType;
    protected Color highlightOuter;
    protected Color highlightInner;
    protected Color shadowInner;
    protected Color shadowOuter;

    public BevelBorder(int n) {
        this.bevelType = n;
    }

    public BevelBorder(int n, Color color, Color color2) {
        this(n, color.brighter(), color, color2, color2.brighter());
    }

    @ConstructorProperties(value={"bevelType", "highlightOuterColor", "highlightInnerColor", "shadowOuterColor", "shadowInnerColor"})
    public BevelBorder(int n, Color color, Color color2, Color color3, Color color4) {
        this(n);
        this.highlightOuter = color;
        this.highlightInner = color2;
        this.shadowOuter = color3;
        this.shadowInner = color4;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.bevelType == 0) {
            this.paintRaisedBevel(component, graphics, n, n2, n3, n4);
        } else if (this.bevelType == 1) {
            this.paintLoweredBevel(component, graphics, n, n2, n3, n4);
        }
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.set(2, 2, 2, 2);
        return insets;
    }

    public Color getHighlightOuterColor(Component component) {
        Color color = this.getHighlightOuterColor();
        return color != null ? color : component.getBackground().brighter().brighter();
    }

    public Color getHighlightInnerColor(Component component) {
        Color color = this.getHighlightInnerColor();
        return color != null ? color : component.getBackground().brighter();
    }

    public Color getShadowInnerColor(Component component) {
        Color color = this.getShadowInnerColor();
        return color != null ? color : component.getBackground().darker();
    }

    public Color getShadowOuterColor(Component component) {
        Color color = this.getShadowOuterColor();
        return color != null ? color : component.getBackground().darker().darker();
    }

    public Color getHighlightOuterColor() {
        return this.highlightOuter;
    }

    public Color getHighlightInnerColor() {
        return this.highlightInner;
    }

    public Color getShadowInnerColor() {
        return this.shadowInner;
    }

    public Color getShadowOuterColor() {
        return this.shadowOuter;
    }

    public int getBevelType() {
        return this.bevelType;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    protected void paintRaisedBevel(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        int n5 = n4;
        int n6 = n3;
        graphics.translate(n, n2);
        graphics.setColor(this.getHighlightOuterColor(component));
        graphics.drawLine(0, 0, 0, n5 - 2);
        graphics.drawLine(1, 0, n6 - 2, 0);
        graphics.setColor(this.getHighlightInnerColor(component));
        graphics.drawLine(1, 1, 1, n5 - 3);
        graphics.drawLine(2, 1, n6 - 3, 1);
        graphics.setColor(this.getShadowOuterColor(component));
        graphics.drawLine(0, n5 - 1, n6 - 1, n5 - 1);
        graphics.drawLine(n6 - 1, 0, n6 - 1, n5 - 2);
        graphics.setColor(this.getShadowInnerColor(component));
        graphics.drawLine(1, n5 - 2, n6 - 2, n5 - 2);
        graphics.drawLine(n6 - 2, 1, n6 - 2, n5 - 3);
        graphics.translate(-n, -n2);
        graphics.setColor(color);
    }

    protected void paintLoweredBevel(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        int n5 = n4;
        int n6 = n3;
        graphics.translate(n, n2);
        graphics.setColor(this.getShadowInnerColor(component));
        graphics.drawLine(0, 0, 0, n5 - 1);
        graphics.drawLine(1, 0, n6 - 1, 0);
        graphics.setColor(this.getShadowOuterColor(component));
        graphics.drawLine(1, 1, 1, n5 - 2);
        graphics.drawLine(2, 1, n6 - 2, 1);
        graphics.setColor(this.getHighlightOuterColor(component));
        graphics.drawLine(1, n5 - 1, n6 - 1, n5 - 1);
        graphics.drawLine(n6 - 1, 1, n6 - 1, n5 - 2);
        graphics.setColor(this.getHighlightInnerColor(component));
        graphics.drawLine(2, n5 - 2, n6 - 2, n5 - 2);
        graphics.drawLine(n6 - 2, 2, n6 - 2, n5 - 3);
        graphics.translate(-n, -n2);
        graphics.setColor(color);
    }
}

