/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.instrumentation;

import java.lang.reflect.Method;
import java.util.List;
import jdk.internal.instrumentation.Logger;
import jdk.internal.instrumentation.MaxLocalsTracker;
import jdk.internal.instrumentation.MethodCallInliner;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.ClassVisitor;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Type;
import jdk.internal.org.objectweb.asm.tree.ClassNode;
import jdk.internal.org.objectweb.asm.tree.MethodNode;

final class Inliner
extends ClassVisitor {
    private final String instrumentationClassName;
    private final Logger logger;
    private final ClassNode targetClassNode;
    private final List<Method> instrumentationMethods;
    private final MaxLocalsTracker maxLocalsTracker;

    Inliner(int n, ClassVisitor classVisitor, String string, ClassReader classReader, List<Method> list, MaxLocalsTracker maxLocalsTracker, Logger logger) {
        super(n, classVisitor);
        this.instrumentationClassName = string;
        this.instrumentationMethods = list;
        this.maxLocalsTracker = maxLocalsTracker;
        this.logger = logger;
        ClassNode classNode = new ClassNode(327680);
        classReader.accept(classNode, 8);
        this.targetClassNode = classNode;
    }

    @Override
    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        MethodVisitor methodVisitor = super.visitMethod(n, string, string2, string3, stringArray);
        if (this.isInstrumentationMethod(string, string2)) {
            MethodNode methodNode = this.findTargetMethodNode(string, string2);
            if (methodNode == null) {
                throw new IllegalArgumentException("Could not find the method to instrument in the target class");
            }
            if ((methodNode.access & 0x100) == 1) {
                throw new IllegalArgumentException("Cannot instrument native methods: " + this.targetClassNode.name + "." + methodNode.name + methodNode.desc);
            }
            this.logger.trace("Inliner processing method " + string + string2);
            MethodCallInliner methodCallInliner = new MethodCallInliner(n, string2, methodVisitor, methodNode, this.instrumentationClassName, this.maxLocalsTracker.getMaxLocals(string, string2), this.logger);
            return methodCallInliner;
        }
        return methodVisitor;
    }

    private boolean isInstrumentationMethod(String string, String string2) {
        for (Method method : this.instrumentationMethods) {
            if (!method.getName().equals(string) || !Type.getMethodDescriptor(method).equals(string2)) continue;
            return true;
        }
        return false;
    }

    private MethodNode findTargetMethodNode(String string, String string2) {
        for (MethodNode methodNode : this.targetClassNode.methods) {
            if (!methodNode.desc.equals(string2) || !methodNode.name.equals(string)) continue;
            return methodNode;
        }
        throw new IllegalArgumentException("could not find MethodNode for " + string + string2);
    }
}

