/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource;

import jdk.management.resource.NotifyingMeter;
import jdk.management.resource.ResourceApprover;
import jdk.management.resource.ResourceId;
import jdk.management.resource.ResourceMeter;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceType;

public class BoundedMeter
extends NotifyingMeter
implements ResourceMeter,
ResourceRequest {
    private volatile long bound;

    public static BoundedMeter create(ResourceType resourceType, long l) {
        return BoundedMeter.create(resourceType, l, null, null);
    }

    public static BoundedMeter create(ResourceType resourceType, long l, ResourceRequest resourceRequest) {
        return BoundedMeter.create(resourceType, l, resourceRequest, null);
    }

    public static BoundedMeter create(ResourceType resourceType, long l, ResourceRequest resourceRequest, ResourceApprover resourceApprover) {
        return new BoundedMeter(resourceType, l, resourceRequest, resourceApprover);
    }

    public static BoundedMeter create(ResourceType resourceType, long l, ResourceApprover resourceApprover) {
        return BoundedMeter.create(resourceType, l, null, resourceApprover);
    }

    protected BoundedMeter(ResourceType resourceType, long l, ResourceRequest resourceRequest, ResourceApprover resourceApprover) {
        super(resourceType, resourceRequest, resourceApprover);
        if (l < 0L) {
            throw new IllegalArgumentException("bound must be zero or greater");
        }
        this.bound = l;
    }

    @Override
    protected long validate(long l, long l2, ResourceId resourceId) {
        ResourceApprover resourceApprover = this.getApprover();
        long l3 = l2;
        if (resourceApprover != null) {
            long l4;
            long l5 = this.getGranularity();
            long l6 = l + l2;
            long l7 = Math.floorDiv(l, l5);
            if ((l7 != (l4 = Math.floorDiv(l6, l5)) || this.bound - l6 < 0L) && (l3 = resourceApprover.request(this, l, l2, resourceId)) != l2 && l3 != 0L) {
                l3 = l2;
            }
        }
        if (this.bound - (l + l3) < 0L) {
            l3 = 0L;
        }
        return l3;
    }

    public final synchronized long getBound() {
        return this.bound;
    }

    public final synchronized long setBound(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("bound must be zero or greater");
        }
        long l2 = this.bound;
        this.bound = l;
        return l2;
    }

    @Override
    synchronized long setGranularityInternal(long l) {
        long l2 = super.setGranularityInternal(l);
        return l2;
    }

    @Override
    public String toString() {
        return super.toString() + "; bound: " + Long.toString(this.bound);
    }
}

