/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal.inst;

import java.io.FileDescriptor;
import java.io.IOException;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.internal.instrumentation.TypeMapping;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceRequestDeniedException;
import jdk.management.resource.internal.ApproverGroup;
import jdk.management.resource.internal.ResourceIdImpl;

@InstrumentationTarget(value="java.net.SocketInputStream")
@TypeMapping(from="jdk.management.resource.internal.inst.SocketInputStreamRMHooks$AbstractPlainSocketImpl", to="java.net.AbstractPlainSocketImpl")
public final class SocketInputStreamRMHooks {
    private AbstractPlainSocketImpl impl = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    private int socketRead(FileDescriptor fileDescriptor, byte[] byArray, int n, int n2, int n3) throws IOException {
        int n4;
        if (n2 < 0) {
            return this.socketRead(fileDescriptor, byArray, n, n2, n3);
        }
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.impl.localport);
        ResourceRequest resourceRequest = ApproverGroup.SOCKET_READ_GROUP.getApprover(this);
        long l = 0L;
        try {
            l = Math.max(resourceRequest.request(n2, resourceIdImpl), 0L);
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited", resourceRequestDeniedException);
        }
        n2 = Math.min(n2, (int)l);
        int n5 = 0;
        try {
            n4 = this.socketRead(fileDescriptor, byArray, n, n2, n3);
            n5 = Math.max(n4, 0);
        }
        finally {
            resourceRequest.request(-(l - (long)n5), resourceIdImpl);
        }
        return n4;
    }

    static class AbstractPlainSocketImpl {
        protected int localport;

        AbstractPlainSocketImpl() {
        }
    }
}

