/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal.inst;

import java.security.AccessControlContext;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceRequestDeniedException;
import jdk.management.resource.internal.ApproverGroup;
import jdk.management.resource.internal.ResourceIdImpl;
import jdk.management.resource.internal.SimpleResourceContext;

@InstrumentationTarget(value="java.lang.Thread")
public final class ThreadRMHooks {
    private long tid;

    private static synchronized long nextThreadID() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    private void init(ThreadGroup threadGroup, Runnable runnable, String string, long l, AccessControlContext accessControlContext, boolean bl) {
        long l2 = ThreadRMHooks.nextThreadID();
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(l2);
        ResourceRequest resourceRequest = ApproverGroup.THREAD_CREATED_GROUP.getApprover(this);
        long l3 = 1L;
        long l4 = 0L;
        try {
            l4 = resourceRequest.request(l3, resourceIdImpl);
            if (l4 == 0L) {
                throw new ResourceRequestDeniedException("Resource limited: thread creation denied by resource manager");
            }
            this.init(threadGroup, runnable, string, l, accessControlContext, bl);
            SimpleResourceContext simpleResourceContext = (SimpleResourceContext)SimpleResourceContext.getThreadContext(Thread.currentThread());
            ThreadRMHooks threadRMHooks = this;
            simpleResourceContext.bindNewThreadContext((Thread)((Object)threadRMHooks));
        }
        finally {
            resourceRequest.request(-(l4 - l3), resourceIdImpl);
        }
        this.tid = l2;
    }

    @InstrumentationMethod
    private void exit() {
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.tid);
        ResourceRequest resourceRequest = ApproverGroup.THREAD_CREATED_GROUP.getApprover(this);
        try {
            resourceRequest.request(-1L, resourceIdImpl);
            SimpleResourceContext.removeThreadContext();
        }
        finally {
            this.exit();
        }
    }
}

