/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpStandardObjectServer;
import java.lang.management.ThreadInfo;
import java.util.Map;
import java.util.TreeMap;
import sun.management.snmp.jvminstr.JVM_MANAGEMENT_MIB_IMPL;
import sun.management.snmp.jvminstr.JvmThreadInstanceEntryImpl;
import sun.management.snmp.jvminstr.JvmThreadingImpl;
import sun.management.snmp.jvmmib.JvmThreadInstanceTableMeta;
import sun.management.snmp.util.JvmContextFactory;
import sun.management.snmp.util.MibLogger;
import sun.management.snmp.util.SnmpCachedData;
import sun.management.snmp.util.SnmpTableCache;
import sun.management.snmp.util.SnmpTableHandler;

public class JvmThreadInstanceTableMetaImpl
extends JvmThreadInstanceTableMeta {
    static final long serialVersionUID = -8432271929226397492L;
    public static final int MAX_STACK_TRACE_DEPTH = 0;
    protected SnmpTableCache cache;
    static final MibLogger log = new MibLogger(JvmThreadInstanceTableMetaImpl.class);

    static SnmpOid makeOid(long l) {
        long[] lArray = new long[]{l >> 56 & 0xFFL, l >> 48 & 0xFFL, l >> 40 & 0xFFL, l >> 32 & 0xFFL, l >> 24 & 0xFFL, l >> 16 & 0xFFL, l >> 8 & 0xFFL, l & 0xFFL};
        return new SnmpOid(lArray);
    }

    static long makeId(SnmpOid snmpOid) {
        long l = 0L;
        long[] lArray = snmpOid.longValue(false);
        l |= lArray[0] << 56;
        l |= lArray[1] << 48;
        l |= lArray[2] << 40;
        l |= lArray[3] << 32;
        l |= lArray[4] << 24;
        l |= lArray[5] << 16;
        l |= lArray[6] << 8;
        return l |= lArray[7];
    }

    public JvmThreadInstanceTableMetaImpl(SnmpMib snmpMib, SnmpStandardObjectServer snmpStandardObjectServer) {
        super(snmpMib, snmpStandardObjectServer);
        this.cache = new JvmThreadInstanceTableCache(this, ((JVM_MANAGEMENT_MIB_IMPL)snmpMib).validity());
        log.debug("JvmThreadInstanceTableMetaImpl", "Create Thread meta");
    }

    @Override
    protected SnmpOid getNextOid(Object object) throws SnmpStatusException {
        log.debug("JvmThreadInstanceTableMetaImpl", "getNextOid");
        return this.getNextOid(null, object);
    }

    @Override
    protected SnmpOid getNextOid(SnmpOid snmpOid, Object object) throws SnmpStatusException {
        log.debug("getNextOid", "previous=" + snmpOid);
        SnmpTableHandler snmpTableHandler = this.getHandler(object);
        if (snmpTableHandler == null) {
            log.debug("getNextOid", "handler is null!");
            throw new SnmpStatusException(224);
        }
        SnmpOid snmpOid2 = snmpOid;
        while ((snmpOid2 = snmpTableHandler.getNext(snmpOid2)) != null && this.getJvmThreadInstance(object, snmpOid2) == null) {
        }
        log.debug("*** **** **** **** getNextOid", "next=" + snmpOid2);
        if (snmpOid2 == null) {
            throw new SnmpStatusException(224);
        }
        return snmpOid2;
    }

    @Override
    protected boolean contains(SnmpOid snmpOid, Object object) {
        SnmpTableHandler snmpTableHandler = this.getHandler(object);
        if (snmpTableHandler == null) {
            return false;
        }
        if (!snmpTableHandler.contains(snmpOid)) {
            return false;
        }
        JvmThreadInstanceEntryImpl jvmThreadInstanceEntryImpl = this.getJvmThreadInstance(object, snmpOid);
        return jvmThreadInstanceEntryImpl != null;
    }

    @Override
    public Object getEntry(SnmpOid snmpOid) throws SnmpStatusException {
        log.debug("*** **** **** **** getEntry", "oid [" + snmpOid + "]");
        if (snmpOid == null || snmpOid.getLength() != 8) {
            log.debug("getEntry", "Invalid oid [" + snmpOid + "]");
            throw new SnmpStatusException(224);
        }
        Map<Object, Object> map = JvmContextFactory.getUserData();
        SnmpTableHandler snmpTableHandler = this.getHandler(map);
        if (snmpTableHandler == null || !snmpTableHandler.contains(snmpOid)) {
            throw new SnmpStatusException(224);
        }
        JvmThreadInstanceEntryImpl jvmThreadInstanceEntryImpl = this.getJvmThreadInstance(map, snmpOid);
        if (jvmThreadInstanceEntryImpl == null) {
            throw new SnmpStatusException(224);
        }
        return jvmThreadInstanceEntryImpl;
    }

    protected SnmpTableHandler getHandler(Object object) {
        SnmpTableHandler snmpTableHandler;
        Map map = object instanceof Map ? (Map)Util.cast(object) : null;
        if (map != null && (snmpTableHandler = (SnmpTableHandler)map.get("JvmThreadInstanceTable.handler")) != null) {
            return snmpTableHandler;
        }
        snmpTableHandler = this.cache.getTableHandler();
        if (map != null && snmpTableHandler != null) {
            map.put("JvmThreadInstanceTable.handler", snmpTableHandler);
        }
        return snmpTableHandler;
    }

    private ThreadInfo getThreadInfo(long l) {
        return JvmThreadingImpl.getThreadMXBean().getThreadInfo(l, 0);
    }

    private ThreadInfo getThreadInfo(SnmpOid snmpOid) {
        return this.getThreadInfo(JvmThreadInstanceTableMetaImpl.makeId(snmpOid));
    }

    private JvmThreadInstanceEntryImpl getJvmThreadInstance(Object object, SnmpOid snmpOid) {
        JvmThreadInstanceEntryImpl jvmThreadInstanceEntryImpl = null;
        String string = null;
        Map map = null;
        boolean bl = log.isDebugOn();
        if (object instanceof Map) {
            map = (Map)Util.cast(object);
            string = "JvmThreadInstanceTable.entry." + snmpOid.toString();
            jvmThreadInstanceEntryImpl = (JvmThreadInstanceEntryImpl)map.get(string);
        }
        if (jvmThreadInstanceEntryImpl != null) {
            if (bl) {
                log.debug("*** getJvmThreadInstance", "Entry found in cache: " + string);
            }
            return jvmThreadInstanceEntryImpl;
        }
        if (bl) {
            log.debug("*** getJvmThreadInstance", "Entry [" + snmpOid + "] is not in cache");
        }
        ThreadInfo threadInfo = null;
        try {
            threadInfo = this.getThreadInfo(snmpOid);
        }
        catch (RuntimeException runtimeException) {
            log.trace("*** getJvmThreadInstance", "Failed to get thread info for rowOid: " + snmpOid);
            log.debug("*** getJvmThreadInstance", runtimeException);
        }
        if (threadInfo == null) {
            if (bl) {
                log.debug("*** getJvmThreadInstance", "No entry by that oid [" + snmpOid + "]");
            }
            return null;
        }
        jvmThreadInstanceEntryImpl = new JvmThreadInstanceEntryImpl(threadInfo, snmpOid.toByte());
        if (map != null) {
            map.put(string, jvmThreadInstanceEntryImpl);
        }
        if (bl) {
            log.debug("*** getJvmThreadInstance", "Entry created for Thread OID [" + snmpOid + "]");
        }
        return jvmThreadInstanceEntryImpl;
    }

    private static class JvmThreadInstanceTableCache
    extends SnmpTableCache {
        static final long serialVersionUID = 4947330124563406878L;
        private final JvmThreadInstanceTableMetaImpl meta;

        JvmThreadInstanceTableCache(JvmThreadInstanceTableMetaImpl jvmThreadInstanceTableMetaImpl, long l) {
            this.validity = l;
            this.meta = jvmThreadInstanceTableMetaImpl;
        }

        @Override
        public SnmpTableHandler getTableHandler() {
            Map<Object, Object> map = JvmContextFactory.getUserData();
            return this.getTableDatas(map);
        }

        @Override
        protected SnmpCachedData updateCachedDatas(Object object) {
            long[] lArray = JvmThreadingImpl.getThreadMXBean().getAllThreadIds();
            long l = System.currentTimeMillis();
            SnmpOid[] snmpOidArray = new SnmpOid[lArray.length];
            TreeMap<SnmpOid, Object> treeMap = new TreeMap<SnmpOid, Object>(SnmpCachedData.oidComparator);
            for (int i = 0; i < lArray.length; ++i) {
                log.debug("", "Making index for thread id [" + lArray[i] + "]");
                SnmpOid snmpOid = JvmThreadInstanceTableMetaImpl.makeOid(lArray[i]);
                treeMap.put(snmpOid, snmpOid);
            }
            return new SnmpCachedData(l, treeMap);
        }
    }
}

