<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Jumps to a given relative or Moodle absolute URL.
 * Mostly used for accessibility.
 *
 * @copyright 1999 Martin Dougiamas  http://dougiamas.com
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @package course
 */

require('../config.php');

$jump = required_param('jump', PARAM_RAW);

$PAGE->set_url('/course/jumpto.php');

if (!confirm_sesskey()) {
    print_error('confirmsesskeybad');
}

// (Shirai018): プロキシを利用しているコース（wwwrootと実際のURLが異なる）で発生する諸問題への対処 (2014/04/21)
// (Shirai018): ここから修正
// if (strpos($jump, '/') === 0 || strpos($jump, $CFG->wwwroot) === 0) {
if (strpos($jump, '/') === 0 || strpos($jump, $CFG->wwwroot) === 0 || (fs_function_enable('FS_ENABLE_USEPUBLICWWWROOT') && strpos($jump, $fsCFG->publicwwwroot) === 0)) {
// (Shirai018): ここまで修正
    redirect(new moodle_url($jump));
} else {
// (Shirai018): ここから修正
//  print_error('error');
    print_error('errorbyproxy', 'fs_moodle');
// (Shirai018): ここまで修正
}
