<?php
// fs_moodleライブラリのスタートアップ後半
// lib/dmllib.phpなどの高度なライブラリを利用するために，lib/setup.phpの後半にて読み込む
// 前半部は主にfs化のためのライブラリの読み込みと初期設定（lib/setuplib.php中にfs化関数が存在するため）

//------------------------------------------------------------------------
// Moodle1.8では以下の関数が定義されていません
if (fs_get_moodle_version() < 2007101500) {
    if (!function_exists('check_browser_operating_system')) {
        function check_browser_operating_system($brand) {
            if (empty($_SERVER['HTTP_USER_AGENT'])) {
                return false;
            }

            if (preg_match("/$brand/i", $_SERVER['HTTP_USER_AGENT'])) {
                return true;
            }

            return false;
         }
    }
    if (!function_exists('is_siteadmin')) {
        function is_siteadmin($userid) {
            global $CFG;

            $sql = "SELECT SUM(rc.permission)
                    FROM " . $CFG->prefix . "role_capabilities rc
                    JOIN " . $CFG->prefix . "context ctx 
                      ON ctx.id=rc.contextid
                    JOIN " . $CFG->prefix . "role_assignments ra
                      ON ra.roleid=rc.roleid AND ra.contextid=ctx.id
                    WHERE ctx.contextlevel=10
                      AND ra.userid={$userid}
                      AND rc.capability IN ('moodle/site:config', 'moodle/legacy:admin', 'moodle/site:doanything')       
                    GROUP BY rc.capability
                    HAVING SUM(rc.permission) > 0";

            $isadmin = record_exists_sql($sql);
            return $isadmin;
        }
    }
}

//------------------------------------------------------------------------

    // fsconfig.phpが存在しない場合
    if (isset($needtocreatefsconfig) && $needtocreatefsconfig) {
        global $USER;
        if (isset($USER)) {
            echo '<b>警告！</b><br />';
            echo 'fs_moodleの設定ファイル（fsconfig.php）が存在しません．';
            echo 'もしあなたがこのサイトの管理者ではないならば，管理者に速やかに連絡して下さい．';
            echo 'なお，インストール作業中はこの警告が出ても問題ありません．';
            echo '<hr />';
            if (is_siteadmin($USER->id)) {
                require_once($CFG->libdir.'/fs_moodle/fs_status/lib.php');
                require_once($CFG->libdir.'/fs_moodle/fs_status/output_lib.php');
                // moodledata/configフォルダのチェックと作成
                fs_check_config_folder();
                // fsconfigの初期化
                fs_config_set2default();
                // 一時ファイルとしてmoodledata/configにfsconfig.phpを作成
                $fsout = new fsconfig_output;
                $fsout->set_overwrite();
                $fsout->overwrite_fsconfig();
                echo '<b>fsconfig.phpを自動作成しました．</b>';
            }
        }
    }

    // バックアップの拡張に関する関数群の読み込み
    require_once($CFG->libdir.'/fs_moodle/fs_backup.php');

    // fsconfig_option.phpの読み込み
    // もし外部ファイルで設定している場合は読み込む
    if (file_exists(FSCONFIGDIR.'/fsconfig_option.php'))          require_once(FSCONFIGDIR.'/fsconfig_option.php');
      else if (file_exists($CFG->dirroot.'/fsconfig_option.php')) require_once($CFG->dirroot.'/fsconfig_option.php');

// (Shirai064): MS-Office2007より採用された新しい拡張子(Word, Excel, PoerPoint)のMimetypeの設定が不十分なために，ブラウザでダウンロード時に拡張子が変更されてしまう問題 (2008/04/11)
    fs_add_mimetype('jtd', 'application/x-js-taro', 'text');

    // バックアップ制限条件の初期化
    fs_reset_backup_exception();

    // (Shirai187): 電子メールでブログを投稿する機能 (2010/05/12)
    require_once($CFG->libdir.'/fs_moodle/mail2blog/lib.php');

    // (Shirai192): Wikiなどのコンテンツに更新があったことをコースの画面上に表示する機能を追加 (2010/08/03)
    if (fs_function_enable('FS_DISABLE_RA_WIKI') or fs_function_enable('FS_DISABLE_RA_GLOSSARY')) {
        require_once($CFG->libdir.'/fs_moodle/fs_recentActivity.php');
    }

?>
