unit ML_options;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, IniFiles;

type
  TOptions = class
    server_ip: String;
    client_ip: String;
    alck_port: String;
    colinux_xml: String;
    cl_terminal: Bool;
    Xm_optionline: String;
    use_XDMCP: Bool;
    use_xfs: Bool;
    xfs_use_default_ip: Bool;
    xfs_ip: String;
    xfs_port: String;
    co_loc: String;
    xm_loc: String;
    esd_loc: String;
    ime_loc: String;

    constructor Create;
    destructor Destroy; override;

    procedure ReadInifile;
    procedure WriteInifile;

  end;
  TOptionForm = class(TForm)
    PageControl1: TPageControl;
    IPSheet: TTabSheet;
    WindowsIpLabel: TLabel;
    WindowsIpEdit: TEdit;
    CLSheet: TTabSheet;
    XmSheet: TTabSheet;
    MLinuxIpLabel: TLabel;
    MLinuxIpEdit: TEdit;
    AlChkPortLabel: TLabel;
    AlChkPortEdit: TEdit;
    IPSheetBtn: TButton;
    CLSheetBtn: TButton;
    XmSheetBtn: TButton;
    UseTermCB: TCheckBox;
    CLSheetEdit1: TEdit;
    CLSheetLb1: TLabel;
    XmOlineLabel: TLabel;
    XmOlEdit: TEdit;
    XmXDMCPCB: TCheckBox;
    XmxfsPortLb: TLabel;
    XmxfsPortEdit: TEdit;
    XmxfsCB: TCheckBox;
    XmxfsGB: TGroupBox;
    XmxfsDefaultIPCB: TCheckBox;
    XmxfsIPLb: TLabel;
    XmxfsIPEdit: TEdit;
    ProgSheet: TTabSheet;
    ProgCLLabel: TLabel;
    ProgXMLabel: TLabel;
    ProgEsdLabel: TLabel;
    ProgIMELabel: TLabel;
    ProgCLEdit: TEdit;
    ProgXMEdit: TEdit;
    ProgEsdEdit: TEdit;
    ProgIMEEdit: TEdit;
    ProgSheetBtn: TButton;
    OpenDialog1: TOpenDialog;
    ProgClBtn: TButton;
    ProgXMBtn: TButton;
    progEsdBtn: TButton;
    progIMEBtn: TButton;
    procedure XmSheet_update_view;
    procedure IPSheetBtnClick(Sender: TObject);
    procedure XmSheetBtnClick(Sender: TObject);
    procedure CLSheetBtnClick(Sender: TObject);
    procedure ProgSheetBtnClick(Sender: TObject);
    procedure IPSheetBtn2Click(Sender: TObject);
    procedure XmSheetBtn2Click(Sender: TObject);
    procedure CLSheetBtn2Click(Sender: TObject);
    procedure ProgSheetBtn2Click(Sender: TObject);
    procedure XmxfsDefaultIPCBClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ProgCLBtnClick(Sender: TObject);
    procedure ProgXMBtnClick(Sender: TObject);
    procedure progIMEBtnClick(Sender: TObject);
    procedure progEsdBtnClick(Sender: TObject);
    procedure WindowsIpEditChange(Sender: TObject);
    procedure MLinuxIpEditChange(Sender: TObject);
    procedure CLSheetEdit1Change(Sender: TObject);
    procedure UseTermCBClick(Sender: TObject);
    procedure XmOlEditChange(Sender: TObject);
    procedure XmXDMCPCBClick(Sender: TObject);
    procedure XmxfsCBClick(Sender: TObject);
    procedure XmxfsIPEditChange(Sender: TObject);
    procedure XmxfsPortEditChange(Sender: TObject);
    procedure AlChkPortEditChange(Sender: TObject);
    procedure ProgCLEditChange(Sender: TObject);
    procedure ProgXMEditChange(Sender: TObject);
    procedure ProgEsdEditChange(Sender: TObject);
    procedure ProgIMEEditChange(Sender: TObject);

  private
    { Private 錾 }

  public
     CurrentOptions : TOptions;
    { Public 錾 }
  end;

var
  OptionForm: TOptionForm;
  Options: TOptions;

implementation


{$R *.dfm}
//
//  TOptions Member
//
constructor TOptions.Create;
begin
  ReadInifile;
end;


destructor TOptions.Destroy;
begin
   Writeinifile;
end;

procedure TOptions.ReadInifile;
var
Ini: TIniFile;
begin
Ini := TIniFile.Create(ChangeFileExt(Application.ExeName,'.INI' ));
try
server_ip := Ini.ReadString('IPs','server_ip','192.168.0.40');
client_ip := Ini.ReadString('IPs','client_ip','192.168.0.1');
alck_port := Ini.ReadString('Xming','alck_port','22');
colinux_xml := Ini.ReadString('colinux','colinux_xml','default.colinux.xml');
cl_terminal := Ini.ReadBool('colinux','cl_terminal',true);
Xm_optionline := Ini.ReadString('Xming','Xm_optionline','-clipboard -screen 0 1024 768');
use_XDMCP := Ini.ReadBool('Xming','use_XDMCP', true);
use_xfs := Ini.ReadBool('Xming','use_xfs', true);
xfs_use_default_ip := Ini.ReadBool('Xming','xfs_use_default_ip', true);
xfs_ip := Ini.ReadString('Xming','xfs_ip','192.168.0.40');
xfs_port := Ini.ReadString('Xming','xfs_port','7100');
co_loc := Ini.ReadString('Programs','co_loc','colinux-daemon.exe');
xm_loc := Ini.ReadString('Programs','xm_loc','Xming\Xming.exe');
esd_loc := Ini.ReadString('Programs','esd_loc','esd.exe');
ime_loc := Ini.ReadString('Programs','ime_loc','bin\canna2imm32.exe');

finally
Ini.Free;
end;
end;

procedure TOptions.WriteInifile;
var
Ini:TIniFile;
begin
Ini :=TIniFile.Create(ChangeFileExt(Application.ExeName,'.INI' ));
try
Ini.WriteString('IPs','server_ip',server_ip);
Ini.WriteString('IPs','client_ip',client_ip);
Ini.WriteString('Xming','alck_port',alck_port);
Ini.WriteString('colinux','colinux_xml',colinux_xml);
Ini.WriteBool('colinux','cl_terminal',cl_terminal);
Ini.WriteString('Xming','Xm_optionline',Xm_optionline);
Ini.WriteBool('Xming','use_XDMCP', use_XDMCP);
Ini.WriteBool('Xming','use_xfs', use_xfs);
Ini.WriteBool('Xming','xfs_use_default_ip', xfs_use_default_ip);
Ini.WriteString('Xming','xfs_ip',xfs_ip);
Ini.WriteString('Xming','xfs_port',xfs_port);
Ini.WriteString('Programs','co_loc',co_loc);
Ini.WriteString('Programs','xm_loc',xm_loc);
Ini.WriteString('Programs','esd_loc',esd_loc);
Ini.WriteString('Programs','ime_loc',ime_loc);

finally
Ini.Free;
end;
end;


//
//  TOptionForm Member
//

procedure TOptionForm.XmSheet_update_view;
begin
  if OptionForm.XmxfsCB.Checked then
  begin
    OptionForm.XmxfsDefaultIPCB.Enabled := true;
    OptionForm.XmxfsPortLb.Enabled := true;
    OptionForm.XmxfsPortEdit.Enabled := true;
    if OptionForm.XmxfsDefaultIPCB.Checked then
    begin
      OptionForm.XmxfsIPEdit.Enabled := false;
      OptionForm.XmxfsIPLb.Enabled := false;
    end
    else
    begin
      OptionForm.XmxfsIPEdit.Enabled := true;
      OptionForm.XmxfsIPLb.Enabled := true;
    end;
  end
  else
  begin
    OptionForm.XmxfsDefaultIPCB.Enabled := false;
    OptionForm.XmxfsPortLb.Enabled := false;
    OptionForm.XmxfsPortEdit.Enabled := false;
    OptionForm.XmxfsIPLb.Enabled := false;
    OptionForm.XmxfsIPLb.Enabled := false;
  end;
end;

procedure TOptionForm.IPSheetBtnClick(Sender: TObject);
begin
  Options.client_ip := OptionForm.WindowsIpEdit.Text;
  Options.server_ip := OptionForm.MLinuxIpEdit.Text;
  Options.WriteInifile;
  OptionForm.IPSheetBtn.Enabled := false;
end;

procedure TOptionForm.XmSheetBtnClick(Sender: TObject);
begin
  Options.Xm_optionline := OptionForm.XmOlEdit.Text;
  Options.use_XDMCP := OptionForm.XmXDMCPCB.Checked;
  Options.use_xfs := OptionForm.XmxfsCB.Checked;
  Options.xfs_use_default_ip := OptionForm.XmxfsDefaultIPCB.Checked;
  if OptionForm.XmxfsDefaultIPCB.Checked then
    Options.xfs_ip := Options.server_ip
  else
    Options.xfs_ip := OptionForm.XmxfsIPEdit.Text;
  Options.xfs_port := OptionForm.XmxfsPortEdit.Text;
  Options.alck_port := OptionForm.AlChkPortEdit.Text;
  Options.WriteInifile;
  OptionForm.XmSheetBtn.Enabled := false;
end;

procedure TOptionForm.CLSheetBtnClick(Sender: TObject);
begin
  Options.cl_terminal := OptionForm.UseTermCB.Checked;
  Options.colinux_xml := OptionForm.CLSheetEdit1.Text;
  Options.WriteInifile;
  OptionForm.CLSheetBtn.Enabled := false;
end;

procedure TOptionForm.ProgSheetBtnClick(Sender: TObject);
begin
Options.co_loc := OptionForm.ProgCLEdit.Text;
Options.xm_loc := OptionForm.ProgXMEdit.Text;
Options.esd_loc := OptionForm.ProgEsdEdit.Text;
Options.ime_loc := OptionForm.ProgIMEEdit.Text;
Options.WriteInifile;
OptionForm.ProgSheetBtn.Enabled := false;
end;

procedure TOptionForm.IPSheetBtn2Click(Sender: TObject);
begin
  OptionForm.WindowsIpEdit.Text := Options.client_ip;
  OptionForm.MLinuxIpEdit.Text := Options.server_ip;
end;

procedure TOptionForm.XmSheetBtn2Click(Sender: TObject);
begin
  OptionForm.XmOlEdit.Text := Options.Xm_optionline;
  OptionForm.XmXDMCPCB.Checked := Options.use_XDMCP;
  OptionForm.XmxfsCB.Checked :=Options.use_xfs;
  OptionForm.XmxfsDefaultIPCB.Checked := Options.xfs_use_default_ip;
  OptionForm.XmxfsIPEdit.Text := Options.xfs_ip;
  OptionForm.XmxfsPortEdit.Text := Options.xfs_port;
  OptionForm.AlChkPortEdit.Text := Options.alck_port;
end;

procedure TOptionForm.CLSheetBtn2Click(Sender: TObject);
begin
  OptionForm.UseTermCB.Checked := Options.cl_terminal;
  OptionForm.CLSheetEdit1.Text := Options.colinux_xml;
end;

procedure TOptionForm.ProgSheetBtn2Click(Sender: TObject);
begin
OptionForm.ProgCLEdit.Text := Options.co_loc;
OptionForm.ProgXMEdit.Text := Options.xm_loc;
OptionForm.ProgEsdEdit.Text := Options.esd_loc;
OptionForm.ProgIMEEdit.Text := Options.ime_loc;
end;

procedure TOptionForm.FormCreate(Sender: TObject);
begin
  CurrentOptions := TOptions.Create;
  Options := TOptions.Create;
  OptionForm.IPSheetBtn2Click(Sender);
  OptionForm.XmSheetBtn2Click(Sender);
  OptionForm.XmSheet_update_view;
  OptionForm.CLSheetBtn2Click(Sender);
  OptionForm.ProgSheetBtn2Click(Sender);
end;

procedure TOptionForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Options.WriteInifile;
end;



procedure TOptionForm.ProgCLBtnClick(Sender: TObject);
var
  FileName: String;
begin
  FileName := OptionForm.ProgCLEdit.Text;
  OpenDialog1.Execute;
  OptionForm.ProgCLEdit.Text := OpenDialog1.FileName;
end;

procedure TOptionForm.ProgXMBtnClick(Sender: TObject);
var
  FileName: String;
begin
  FileName := OptionForm.ProgXmEdit.Text;
  OpenDialog1.Execute;
  OptionForm.ProgXmEdit.Text := OpenDialog1.FileName;
end;

procedure TOptionForm.progEsdBtnClick(Sender: TObject);
var
  FileName: String;
begin
  FileName := OptionForm.ProgEsdEdit.Text;
  OpenDialog1.Execute;
  OptionForm.ProgEsdEdit.Text := OpenDialog1.FileName;
end;

procedure TOptionForm.progIMEBtnClick(Sender: TObject);
var
  FileName: String;
begin
  FileName := OptionForm.ProgIMEEdit.Text;
  OpenDialog1.Execute;
  OptionForm.ProgIMEEdit.Text := OpenDialog1.FileName;
end;



procedure TOptionForm.WindowsIpEditChange(Sender: TObject);
begin
  OptionForm.IPSheetBtn.Enabled := true;
end;
procedure TOptionForm.MLinuxIpEditChange(Sender: TObject);
begin
  OptionForm.IPSheetBtn.Enabled := true;
end;

procedure TOptionForm.CLSheetEdit1Change(Sender: TObject);
begin
  OptionForm.CLSheetBtn.Enabled := true;
end;
procedure TOptionForm.UseTermCBClick(Sender: TObject);
begin
  OptionForm.CLSheetBtn.Enabled := true;
end;


procedure TOptionForm.XmOlEditChange(Sender: TObject);
begin
  OptionForm.XmSheetBtn.Enabled := true;
end;
procedure TOptionForm.XmXDMCPCBClick(Sender: TObject);
begin
  OptionForm.XmSheetBtn.Enabled := true;
end;

procedure TOptionForm.XmxfsCBClick(Sender: TObject);
begin
  OptionForm.XmSheet_update_view;
  OptionForm.XmSheetBtn.Enabled := true;
end;
procedure TOptionForm.XmxfsDefaultIPCBClick(Sender: TObject);
begin
  OptionForm.XmSheet_update_view;
  OptionForm.XmSheetBtn.Enabled := true;
end;
procedure TOptionForm.XmxfsIPEditChange(Sender: TObject);
begin
  OptionForm.XmSheetBtn.Enabled := true;
end;
procedure TOptionForm.XmxfsPortEditChange(Sender: TObject);
begin
  OptionForm.XmSheetBtn.Enabled := true;
end;
procedure TOptionForm.AlChkPortEditChange(Sender: TObject);
begin
  OptionForm.XmSheetBtn.Enabled := true;
end;


procedure TOptionForm.ProgCLEditChange(Sender: TObject);
begin
  OptionForm.ProgSheetBtn.Enabled := true;
end;
procedure TOptionForm.ProgXMEditChange(Sender: TObject);
begin
  OptionForm.ProgSheetBtn.Enabled := true;
end;
procedure TOptionForm.ProgEsdEditChange(Sender: TObject);
begin
  OptionForm.ProgSheetBtn.Enabled := true;
end;
procedure TOptionForm.ProgIMEEditChange(Sender: TObject);
begin
  OptionForm.ProgSheetBtn.Enabled := true;
end;

End.

