//******************************************************************************
//
// MIDITrail / DIKeyCtrl
//
// DirectInput キー入力制御クラス
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "YNBaseLib.h"
#import "DIKeyCtrl.h"


//******************************************************************************
// コンストラクタ
//******************************************************************************
DIKeyCtrl::DIKeyCtrl(void)
{
	m_isActive = false;
}

//******************************************************************************
// デストラクタ
//******************************************************************************
DIKeyCtrl::~DIKeyCtrl(void)
{
	Terminate();
}

//******************************************************************************
// 初期化
//******************************************************************************
int DIKeyCtrl::Initialize(
		NSView* pView
	)
{
	//ダミーメソッド
	return 0;
}

//******************************************************************************
// 終了処理
//******************************************************************************
void DIKeyCtrl::Terminate()
{
	//ダミーメソッド
}

//******************************************************************************
// デバイスアクセス権取得
//******************************************************************************
int DIKeyCtrl::Acquire()
{
	//ダミーメソッド
	return 0;
}

//******************************************************************************
// デバイスアクセス権解放
//******************************************************************************
int DIKeyCtrl::Unacquire()
{
	//ダミーメソッド
	return 0;
}

//******************************************************************************
// キー状態取得
//******************************************************************************
int DIKeyCtrl::GetKeyStatus()
{
	//ダミーメソッド
	return 0;
}

//******************************************************************************
// キー状態確認
//******************************************************************************
bool DIKeyCtrl::IsKeyDown(
		unsigned char key
	)
{
	bool isDown = false;
	
	isDown = CGEventSourceKeyState(
					kCGEventSourceStateHIDSystemState,
					//kCGEventSourceStateCombinedSessionState,
					(CGKeyCode)key
				);
	
	//アプリケーションが非アクティブ状態の場合はキー押下状態を無視する
	if (!m_isActive) {
		isDown = false;
	}
	
	return isDown;
}

//******************************************************************************
// アクティブ状態設定
//******************************************************************************
void DIKeyCtrl::SetActiveState(bool isActive)
{
	m_isActive = isActive;
}


