//******************************************************************************
//
// OpenGL Utility / OGLH
//
// ヘルパ関数クラス
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "OGLH.h"
#import <math.h>


//******************************************************************************
// パラメータ定義
//******************************************************************************
//円周率：floatの有効桁数は10進数で7桁ほど
#define OGL_MATH_PI  (3.141592)

//******************************************************************************
// ベクトル正規化
//******************************************************************************
void OGLH::Vec3Normalize(
		OGLVECTOR3* pNormalizedVector,
		const OGLVECTOR3* pVector
	)
{
	double x, y, z, r, ri;
	
	x = (double)(pVector->x);
	y = (double)(pVector->y);
	z = (double)(pVector->z);
	r = sqrt((x*x) + (y*y) + (z*z));
	
	if (r < (1e-6)) {
		//正規化できないので同じベクトルを返す
		ri = 1.0;
	}
	else {
		ri = 1.0 / r;
	}
	
	pNormalizedVector->x = (float)(x * ri);
	pNormalizedVector->y = (float)(y * ri);
	pNormalizedVector->z = (float)(z * ri);
}

//******************************************************************************
// ラジアン算出
//******************************************************************************
float OGLH::ToRadian(float degree)
{
	return (degree * OGL_MATH_PI / 180.0);
}


