//******************************************************************************
//
// Simple Base Library / YNErrInfo
//
// エラー情報クラス
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "YNErrInfo.h"


@implementation YNErrInfo

//******************************************************************************
// 初期化
//******************************************************************************
- (id)initWithInfo:(YNErrLevel)errLevel
			lineNo:(unsigned long)lineNo
		  fileName:(NSString*)fileName
		   message:(NSString*)message
		  errInfo1:(unsigned long)errInfo1
		  errInfo2:(unsigned long)errInfo2
{
	[super init];
	m_ErrLevel = errLevel;
	m_LineNo = lineNo;
	m_FileName = [[NSString alloc] initWithString:fileName];
	m_Message = [[NSString alloc] initWithString:message];
	m_ErrInfo1 = errInfo1;
	m_ErrInfo2 = errInfo2;
	return self;
}

//******************************************************************************
// デストラクタ
//******************************************************************************
- (void)dealloc
{
	[m_FileName release];
	[m_Message release];
	[super dealloc];
}

//******************************************************************************
// エラーレベル取得
//******************************************************************************
- (YNErrLevel)errLevel
{
	return m_ErrLevel;
}

//******************************************************************************
// 行番号取得
//******************************************************************************
- (unsigned long)lineNo
{
	return m_LineNo;
}

//******************************************************************************
// ファイル名取得
//******************************************************************************
- (NSString*)fileName
{
	return m_FileName;
}

//******************************************************************************
// メッセージ取得
//******************************************************************************
- (NSString*)message
{
	return m_Message;
}

//******************************************************************************
// エラー情報1取得
//******************************************************************************
- (unsigned long)errInfo1
{
	return m_ErrInfo1;
}

//******************************************************************************
// エラー情報2取得
//******************************************************************************
- (unsigned long)errInfo2
{
	return m_ErrInfo2;
}

@end


