//******************************************************************************
//
// MIDITrail / MTFileEditViewCtrl
//
// ファイル編集ビュー制御クラス
//
// Copyright (C) 2018 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import <UIKit/UIKit.h>


//******************************************************************************
// ファイル編集ビュー制御クラス
//******************************************************************************
@interface MTFileEditViewCtrl : UIViewController <UITextFieldDelegate> {
	
	//テーブルビュー
	IBOutlet UITableView* m_pTableView;

	//ファイル名（拡張子含まず）
	NSString* m_pFileName;
	NSString* m_pExtension;
	
	//編集後ファイル名（拡張子含まず）
	NSString* m_pNewFileName;
}

//ファイル名設定
- (void)setFileName:(NSString*)pFileName;

//生成
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil;

//ビュー登録完了
- (void)viewDidLoad;

//インターフェース自動回転確認
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation;

//インターフェース自動回転確認（iOS6以降）
- (BOOL)shouldAutorotate;
- (NSUInteger)supportedInterfaceOrientations;

//ビュー表示
- (void)viewWillAppear:(BOOL)animated;

//ビュー非表示
- (void)viewWillDisappear:(BOOL)animated;

//セクション数
-(NSInteger)numberOfSectionsInTableView:(UITableView*)tableView;

//セクションヘッダ
- (NSString*)tableView:(UITableView*)tableView titleForHeaderInSection:(NSInteger)section;

//セクションごとの項目数
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section;

//項目表示内容
- (UITableViewCell*)tableView:(UITableView*)tableView cellForRowAtIndexPath:(NSIndexPath*)indexPath;

//テーブルセル作成：列の高さ
- (CGFloat)tableView:(UITableView*)tableView heightForRowAtIndexPath:(NSIndexPath*)indexPath;

//テーブルセル選択イベント
- (void)tableView:(UITableView*)tableView didSelectRowAtIndexPath:(NSIndexPath*)indexPath;

//Saveボタン選択イベント
- (void)onSaveButton:(id)sender;

//保存確認Yesボタン押下
- (void)onAlertSaveYes;

//保存確認Cancelボタン押下
- (void)onAlertSaveCancel;

//新ファイル名取得
- (NSString*)getNewFileName;


@end

