//******************************************************************************
//
// Simple MIDI Library / SMPortList
//
// |[gXgNX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#ifdef SMIDILIB_EXPORTS
#define SMIDILIB_API __declspec(dllexport)
#else
#define SMIDILIB_API __declspec(dllimport)
#endif

#include "SMSimpleList.h"

namespace SMIDILib {


//******************************************************************************
// |[gXgNX
//******************************************************************************
class SMIDILIB_API SMPortList
{
public:

	//RXgN^^fXgN^
	SMPortList(void);
	virtual ~SMPortList(void);

	//NA
	void Clear();

	//|[go^
	int AddPort(unsigned char portNo);

	//|[g擾
	int GetPort(unsigned long index, unsigned char* pPortNo);

	//|[g擾
	unsigned long GetSize();

	//Rs[
	int CopyFrom(SMPortList* pSrcList);

private:

	SMSimpleList m_List;

	//ƃRs[RXgN^̋֎~
	void operator=(const SMPortList&);
	SMPortList(const SMPortList&);

};

} // end of namespace

