//******************************************************************************
//
// MIDITrail / MTFontTexture
//
// tHgeNX`NX
//
// Copyright (C) 2010-2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "MTFontTexture.h"

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
MTFontTexture::MTFontTexture(void)
{
	m_RGB = 0x00FFFFFF;
	m_TexHeight = 0;
	m_TexWidth = 0;
	m_pTexture = NULL;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTFontTexture::~MTFontTexture(void)
{
	Clear();
}

//******************************************************************************
// NA
//******************************************************************************
void MTFontTexture::Clear()
{
	if (m_pTexture) {
		m_pTexture->Release();
		m_pTexture = NULL;
	}
	m_Font2Bmp.Clear();
}

//******************************************************************************
// tHgݒ
//******************************************************************************
int MTFontTexture::SetFont(
		const TCHAR* pFontName,
		unsigned long fontSize,
		unsigned long rgb,
		bool isForceFixedPitch
	)
{
	int result = 0;

	result = m_Font2Bmp.SetFont(pFontName, fontSize, isForceFixedPitch);
	if (result != 0) goto EXIT;

	m_RGB = 0x00FFFFFF & rgb;

EXIT:;
	return result;
}

//******************************************************************************
// eNX`
//******************************************************************************
int MTFontTexture::CreateTexture(
		LPDIRECT3DDEVICE9 pD3DDevice,
		const TCHAR* pStr
	)
{
	int result = 0;
	HRESULT hresult = D3D_OK;
	D3DLOCKED_RECT lockedRect;
	DWORD bmpHeight = 0;
	DWORD bmpWidth = 0;
	DWORD x = 0;
	DWORD y = 0;
	DWORD alpha = 0;
	DWORD argb = 0;
	BYTE bmpPixcel = 0;
	DWORD* pDestPixcel = 0;
	int grayLevelNum = 0;

	if (m_pTexture) {
		m_pTexture->Release();
		m_pTexture = NULL;
	}

	//tHgBMP쐬
	result = m_Font2Bmp.CreateBmp(pStr);
	if (result != 0) goto EXIT;

	m_Font2Bmp.GetBmpSize(&bmpHeight, &bmpWidth);

	//eNX`쐬
	hresult = pD3DDevice->CreateTexture(
							bmpWidth,			//eNX`̕isNZPʁj
							bmpHeight,			//eNX`̍isNZPʁj
							1,					//eNX`x
							D3DUSAGE_DYNAMIC,	//gp@F_obt@Igp
							D3DFMT_A8R8G8B8,	//tH[}bgF32bitAt@tARGBtH[}bg
							D3DPOOL_DEFAULT,	//eNX`zu惁NXFftHg
							&m_pTexture,		//쐬ꂽeNX`
							NULL				//\
						);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, 0);
		goto EXIT;
	}

	//eNX`bNă|C^擾
	hresult = m_pTexture->LockRect(
						0,					//\[Xx
						&lockedRect,		//bNςݗ̈
						NULL,				//bN`FeNX`S
						D3DLOCK_DISCARD		//bN̎ށFݐp
					);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, 0);
		goto EXIT;
	}

	//bNꂽ̈[NA
	ZeroMemory(lockedRect.pBits, lockedRect.Pitch * bmpHeight);

	//OCxFGGO_GRAY4_BITMAPȂ̂17iK
	grayLevelNum = 17;

	//eNX`Ƀrbg}bv
	for (y = 0; y < bmpHeight; y++) {
		for (x = 0; x < bmpWidth; x++) {

			//rbg}bvfF8bit  0x00`0x10(=16)Ԃ  At@lɃ}bsO
			bmpPixcel = m_Font2Bmp.GetBmpPixcel(x, y);

			//eNX`fF32bit ARGB
			alpha = (0xFF * bmpPixcel) / (grayLevelNum - 1);
			if (bmpPixcel == 0) {
				argb = (alpha << 24) | 0x00000000;
			}
			else {
				argb = (alpha << 24) | m_RGB;
			}

			//
			pDestPixcel = (DWORD*)((BYTE*)lockedRect.pBits + (lockedRect.Pitch * y) + (4 * x));
			*pDestPixcel = argb;
		}
	}
	
	//AbN
	hresult = m_pTexture->UnlockRect(0);  //\[Xx0
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, 0);
		goto EXIT;
	}

	m_TexHeight = bmpHeight;
	m_TexWidth = bmpWidth;

EXIT:;
	m_Font2Bmp.Clear();
	return result;
}

//******************************************************************************
// eNX`|C^擾
//******************************************************************************
LPDIRECT3DTEXTURE9 MTFontTexture::GetTexture()
{
	return m_pTexture;
}

//******************************************************************************
// eNX`TCY擾
//******************************************************************************
void MTFontTexture::GetTextureSize(
		unsigned long* pHeight,
		unsigned long* pWidth
	)
{
	*pHeight = m_TexHeight;
	*pWidth = m_TexWidth;
}

