//******************************************************************************
//
// MIDITrail / MTLogo
//
// MIDITrail S`NX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// |S^CɕׂăS̃eNX`\tB
// |S̐F^CƂɍXV邱ƂŃSOf[VB
//
//   +-++-++-++-+
//   |/||/||/||/|...
//   +-++-++-++-+

#include "StdAfx.h"
#include <mmsystem.h>
#include "YNBaseLib.h"
#include "MTLogo.h"

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
MTLogo::MTLogo(void)
{
	m_pVertex = NULL;
	m_StartTime = 0;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTLogo::~MTLogo(void)
{
	Release();
}

//******************************************************************************
// V[
//******************************************************************************
int MTLogo::Create(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;

	Release();

	//eNX`
	result = _CreateTexture(pD3DDevice);
	if (result != 0) goto EXIT;

	//_
	result = _CreateVertex();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// ϊ
//******************************************************************************
int MTLogo::Transform(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;

	//^CgOf[Vݒ
	_SetGradationColor();

	return result;
}

//******************************************************************************
// `
//******************************************************************************
int MTLogo::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	HRESULT hresult = D3D_OK;

	//_OpCvCɃeNX`ݒ
	hresult = pD3DDevice->SetTexture(
					0,							//Xe[Wʎq
					m_FontTexture.GetTexture()	//eNX`IuWFNg
				);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, 0);
		goto EXIT;
	}

	//eNX`Xe[Wݒ
	//  J[ZF1gp  1F|S
	pD3DDevice->SetTextureStageState(0, D3DTSS_COLOROP,   D3DTOP_SELECTARG1);
	pD3DDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_DIFFUSE);
	
	// At@ZF1gp  1FeNX`
	pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAOP,   D3DTOP_SELECTARG1);
	pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);

	//eNX`tB^
	pD3DDevice->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR);
	pD3DDevice->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR);

	//_OpCvCɒ_obt@FVFtH[}bgݒ
	hresult = pD3DDevice->SetFVF(_GetFVFFormat());
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, 0);
		goto EXIT;
	}

	//_OpCvCɃ}eAݒ
	//Ȃ

	//^Cg`
	hresult = pD3DDevice->DrawPrimitiveUP(
					D3DPT_TRIANGLELIST,		//v~eBu
					2 * MTLOGO_TILE_NUM,		//v~eBu
					m_pVertex,				//_f[^
					sizeof(MTLOGO_VERTEX)	//_f[^̃TCY
				);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, MTLOGO_TILE_NUM);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// j
//******************************************************************************
void MTLogo::Release()
{
	m_FontTexture.Clear();

	delete [] m_pVertex;
	m_pVertex = NULL;
}

//******************************************************************************
// eNX`
//******************************************************************************
int MTLogo::_CreateTexture(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	unsigned long color = 0x00FFFFFF;
	bool isForceFixedPitch = false;

	//tHgݒ
	result = m_FontTexture.SetFont(
					_T("Arial"),		//tHg
					40,					//tHgTCY
					color,				//F
					isForceFixedPitch	//Œsb`
				);
	if (result != 0) goto EXIT;

	//^CꗗeNX`쐬
	result = m_FontTexture.CreateTexture(pD3DDevice, MTLOGO_TITLE);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// tHg^C_
//******************************************************************************
int MTLogo::_CreateVertex()
{
	int result = 0;
	unsigned long i = 0;
	MTLOGO_VERTEX* pVertex = NULL;

	//_
	try {
		pVertex = new MTLOGO_VERTEX[6*MTLOGO_TILE_NUM];
	}
	catch (std::bad_alloc) {
		result = YN_SET_ERR("Could not allocate memory.", 0, 0);
		goto EXIT;
	}

	//_Wݒ
	_SetVertexPosition(
			pVertex,		//_Wz
			MTLOGO_POS_X,	//`ʒux
			MTLOGO_POS_Y,	//`ʒuy
			MTLOGO_MAG		//g嗦
		);

	for (i = 0; i < 6*MTLOGO_TILE_NUM; i++) {
		//e_̃fBt[YF
		pVertex[i].c = D3DXCOLOR(0.0f, 0.0f, 0.0f, 1.0f); //R,G,B,A
	}

	m_pVertex = pVertex;
	pVertex = NULL;

EXIT:;
	delete [] pVertex;
	return result;
}

//******************************************************************************
// _ʒuݒ
//******************************************************************************
void MTLogo::_SetVertexPosition(
		MTLOGO_VERTEX* pVertex,
		float x,
		float y,
		float magRate
	)
{
	unsigned long i = 0;
	unsigned long texHeight = 0;
	unsigned long texWidth = 0;
	float height = 0.0f;
	float width = 0.0f;
	float tileNo = 0.0f;

	//^CTCY
	m_FontTexture.GetTextureSize(&texHeight, &texWidth);
	height = texHeight * magRate;
	width  = ((float)texWidth / (float)MTLOGO_TILE_NUM) * magRate;

	//_WFXYʂ(0, 0)Ƃ
	for (i = 0; i < MTLOGO_TILE_NUM; i++) {
		//_W
		pVertex[i*6+0].p = D3DXVECTOR3(width * (i     ),  0.0f,   0.0f);
		pVertex[i*6+1].p = D3DXVECTOR3(width * (i+1.0f),  0.0f,   0.0f);
		pVertex[i*6+2].p = D3DXVECTOR3(width * (i     ), -height, 0.0f);
		pVertex[i*6+3].p = pVertex[i*6+2].p;
		pVertex[i*6+4].p = pVertex[i*6+1].p;
		pVertex[i*6+5].p = D3DXVECTOR3(width * (i+1.0f), -height, 0.0f);

		//eNX`W
		//
		pVertex[i*6+0].t.x = 1.0f * tileNo / (float)MTLOGO_TILE_NUM;
		pVertex[i*6+0].t.y = 0.0f;
		//E
		pVertex[i*6+1].t.x = 1.0f * (tileNo + 1.0f) / (float)MTLOGO_TILE_NUM;
		pVertex[i*6+1].t.y = 0.0f;
		//
		pVertex[i*6+2].t.x = 1.0f * tileNo / (float)MTLOGO_TILE_NUM;
		pVertex[i*6+2].t.y = 1.0f;
		//
		pVertex[i*6+3].t = pVertex[i*6+2].t;
		//E
		pVertex[i*6+4].t = pVertex[i*6+1].t;
		//E
		pVertex[i*6+5].t.x = 1.0f * (tileNo + 1.0f) / (float)MTLOGO_TILE_NUM;
		pVertex[i*6+5].t.y = 1.0f;

		tileNo += 1.0f;
	}

	//@
	for (i = 0; i < 6*MTLOGO_TILE_NUM; i++) {
		pVertex[i].n = D3DXVECTOR3(0.0f, 0.0f, -1.0f);
	}

	//wʒuɈړ
	for (i = 0; i < 6*MTLOGO_TILE_NUM; i++) {
		pVertex[i].p.x += x;
		pVertex[i].p.y += y;
	}

	return;
}

//******************************************************************************
// Of[Vݒ
//******************************************************************************
void MTLogo::_SetGradationColor()
{
	unsigned long i = 0;
	unsigned long sceneTime = 0;
	unsigned long delay = 0;
	unsigned long tileTime = 0;
	float color = 0.0f;
	MTLOGO_VERTEX* pVertex = NULL;

	//V[oߎ
	if (m_StartTime == 0) {
		m_StartTime = timeGetTime();
	}
	sceneTime = timeGetTime() - m_StartTime;

	//Of[V
	for (i = 0; i < MTLOGO_TILE_NUM; i++) {

		//^CƂ̒x
		delay = i * (MTLOGO_GRADATION_TIME / MTLOGO_TILE_NUM);

		//^CɂƂĂ̌oߎ
		if (sceneTime < delay) {
			tileTime = 0;
		}
		else {
			tileTime = sceneTime - delay;
		}

		//^C̐F
		if (tileTime < MTLOGO_GRADATION_TIME) {
			//
			color = (float)tileTime / (float)MTLOGO_GRADATION_TIME;
		}
		else if (tileTime < (MTLOGO_GRADATION_TIME*2)) {
			//
			color = 1.0f - ((float)(tileTime - MTLOGO_GRADATION_TIME) / (float)MTLOGO_GRADATION_TIME);
		}
		else {
			//
			color = 0.0f;
		}

		//^C̐F𒸓_ɐݒ
		pVertex = m_pVertex + (6*i);
		_SetTileColor(pVertex, color);
	}

	return;
}

//******************************************************************************
// ^CFݒ
//******************************************************************************
void MTLogo::_SetTileColor(
		MTLOGO_VERTEX* pVertex,
		float color
	)
{
	unsigned long i = 0;

	for (i = 0; i < 6; i++) {
		pVertex[i].c = D3DXCOLOR(color, color, color, 1.0f); //R,G,B,A
	}
}

