# OSDNClient
OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.jp/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.jp/projects/osdn-codes/releases/p14859 .

This PHP package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 0.0.20160304
- Package version: 0.0.20160711
- Build date: 2016-07-11T13:06:15.944+09:00
- Build package: class io.swagger.codegen.languages.PhpClientCodegen
For more information, please visit [https://osdn.jp/projects/osdn-codes/wiki/APIGuide](https://osdn.jp/projects/osdn-codes/wiki/APIGuide)

## Requirements

PHP 5.4.0 and later

## Installation & Usage
### Composer

To install the bindings via [Composer](http://getcomposer.org/), add the following to `composer.json`:

```
{
  "repositories": [
    {
      "type": "git",
      "url": "https://github.com/OSDN/Client.git"
    }
  ],
  "require": {
    "OSDN/Client": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
    require_once('/path/to/OSDNClient/autoload.php');
```

## Tests

To run the unit tests:

```
composer install
./vendor/bin/phpunit lib/Tests
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\DefaultApi();

try {
    $result = $api_instance->ping();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->ping: ', $e->getMessage(), PHP_EOL;
}

?>
```

## Documentation for API Endpoints

All URIs are relative to *https://osdn.jp/api/v0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**ping**](docs/Api/DefaultApi.md#ping) | **GET** /ping | 
*DefaultApi* | [**token**](docs/Api/DefaultApi.md#token) | **POST** /token | 
*ProjectApi* | [**createNews**](docs/Api/ProjectApi.md#createnews) | **POST** /news | 
*ProjectApi* | [**createNews_0**](docs/Api/ProjectApi.md#createnews_0) | **POST** /project/{id_or_name}/news | 
*ProjectApi* | [**createPackage**](docs/Api/ProjectApi.md#createpackage) | **POST** /project/{id_or_name}/frs | 
*ProjectApi* | [**createRelease**](docs/Api/ProjectApi.md#createrelease) | **POST** /project/{id_or_name}/frs/{package_id} | 
*ProjectApi* | [**createReleaseFile**](docs/Api/ProjectApi.md#createreleasefile) | **POST** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*ProjectApi* | [**deleteNews**](docs/Api/ProjectApi.md#deletenews) | **DELETE** /news/{news_id} | 
*ProjectApi* | [**deleteNews_0**](docs/Api/ProjectApi.md#deletenews_0) | **DELETE** /project/{id_or_name}/news/{news_id} | 
*ProjectApi* | [**deletePackage**](docs/Api/ProjectApi.md#deletepackage) | **DELETE** /project/{id_or_name}/frs/{package_id} | 
*ProjectApi* | [**deleteRelease**](docs/Api/ProjectApi.md#deleterelease) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*ProjectApi* | [**deleteReleaseFile**](docs/Api/ProjectApi.md#deletereleasefile) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
*ProjectApi* | [**draftRelease**](docs/Api/ProjectApi.md#draftrelease) | **GET** /project/{id_or_name}/frs/{package_id}/draft | 
*ProjectApi* | [**getNews**](docs/Api/ProjectApi.md#getnews) | **GET** /news/{news_id} | 
*ProjectApi* | [**getNews_0**](docs/Api/ProjectApi.md#getnews_0) | **GET** /project/{id_or_name}/news/{news_id} | 
*ProjectApi* | [**getPackage**](docs/Api/ProjectApi.md#getpackage) | **GET** /project/{id_or_name}/frs/{package_id} | 
*ProjectApi* | [**getProject**](docs/Api/ProjectApi.md#getproject) | **GET** /project/{id_or_name} | 
*ProjectApi* | [**getRelease**](docs/Api/ProjectApi.md#getrelease) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*ProjectApi* | [**getReleaseFile**](docs/Api/ProjectApi.md#getreleasefile) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
*ProjectApi* | [**listNews**](docs/Api/ProjectApi.md#listnews) | **GET** /news | 
*ProjectApi* | [**listNews_0**](docs/Api/ProjectApi.md#listnews_0) | **GET** /project/{id_or_name}/news | 
*ProjectApi* | [**listPackages**](docs/Api/ProjectApi.md#listpackages) | **GET** /project/{id_or_name}/frs | 
*ProjectApi* | [**updateNews**](docs/Api/ProjectApi.md#updatenews) | **PATCH** /news/{news_id} | 
*ProjectApi* | [**updateNews_0**](docs/Api/ProjectApi.md#updatenews_0) | **PATCH** /project/{id_or_name}/news/{news_id} | 
*ProjectApi* | [**updatePackage**](docs/Api/ProjectApi.md#updatepackage) | **PATCH** /project/{id_or_name}/frs/{package_id} | 
*ProjectApi* | [**updateRelease**](docs/Api/ProjectApi.md#updaterelease) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*ProjectApi* | [**updateReleaseFile**](docs/Api/ProjectApi.md#updatereleasefile) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
*ProjectFrsApi* | [**createPackage**](docs/Api/ProjectFrsApi.md#createpackage) | **POST** /project/{id_or_name}/frs | 
*ProjectFrsApi* | [**createRelease**](docs/Api/ProjectFrsApi.md#createrelease) | **POST** /project/{id_or_name}/frs/{package_id} | 
*ProjectFrsApi* | [**createReleaseFile**](docs/Api/ProjectFrsApi.md#createreleasefile) | **POST** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*ProjectFrsApi* | [**deletePackage**](docs/Api/ProjectFrsApi.md#deletepackage) | **DELETE** /project/{id_or_name}/frs/{package_id} | 
*ProjectFrsApi* | [**deleteRelease**](docs/Api/ProjectFrsApi.md#deleterelease) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*ProjectFrsApi* | [**deleteReleaseFile**](docs/Api/ProjectFrsApi.md#deletereleasefile) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
*ProjectFrsApi* | [**draftRelease**](docs/Api/ProjectFrsApi.md#draftrelease) | **GET** /project/{id_or_name}/frs/{package_id}/draft | 
*ProjectFrsApi* | [**getPackage**](docs/Api/ProjectFrsApi.md#getpackage) | **GET** /project/{id_or_name}/frs/{package_id} | 
*ProjectFrsApi* | [**getRelease**](docs/Api/ProjectFrsApi.md#getrelease) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*ProjectFrsApi* | [**getReleaseFile**](docs/Api/ProjectFrsApi.md#getreleasefile) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
*ProjectFrsApi* | [**listPackages**](docs/Api/ProjectFrsApi.md#listpackages) | **GET** /project/{id_or_name}/frs | 
*ProjectFrsApi* | [**updatePackage**](docs/Api/ProjectFrsApi.md#updatepackage) | **PATCH** /project/{id_or_name}/frs/{package_id} | 
*ProjectFrsApi* | [**updateRelease**](docs/Api/ProjectFrsApi.md#updaterelease) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*ProjectFrsApi* | [**updateReleaseFile**](docs/Api/ProjectFrsApi.md#updatereleasefile) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
*ProjectNewsApi* | [**createNews**](docs/Api/ProjectNewsApi.md#createnews) | **POST** /news | 
*ProjectNewsApi* | [**createNews_0**](docs/Api/ProjectNewsApi.md#createnews_0) | **POST** /project/{id_or_name}/news | 
*ProjectNewsApi* | [**deleteNews**](docs/Api/ProjectNewsApi.md#deletenews) | **DELETE** /news/{news_id} | 
*ProjectNewsApi* | [**deleteNews_0**](docs/Api/ProjectNewsApi.md#deletenews_0) | **DELETE** /project/{id_or_name}/news/{news_id} | 
*ProjectNewsApi* | [**getNews**](docs/Api/ProjectNewsApi.md#getnews) | **GET** /news/{news_id} | 
*ProjectNewsApi* | [**getNews_0**](docs/Api/ProjectNewsApi.md#getnews_0) | **GET** /project/{id_or_name}/news/{news_id} | 
*ProjectNewsApi* | [**listNews**](docs/Api/ProjectNewsApi.md#listnews) | **GET** /news | 
*ProjectNewsApi* | [**listNews_0**](docs/Api/ProjectNewsApi.md#listnews_0) | **GET** /project/{id_or_name}/news | 
*ProjectNewsApi* | [**updateNews**](docs/Api/ProjectNewsApi.md#updatenews) | **PATCH** /news/{news_id} | 
*ProjectNewsApi* | [**updateNews_0**](docs/Api/ProjectNewsApi.md#updatenews_0) | **PATCH** /project/{id_or_name}/news/{news_id} | 
*UserApi* | [**getUser**](docs/Api/UserApi.md#getuser) | **GET** /user/{id_or_name} | 


## Documentation For Models

 - [Group](docs/Model/Group.md)
 - [GroupToolFlags](docs/Model/GroupToolFlags.md)
 - [News](docs/Model/News.md)
 - [Package](docs/Model/Package.md)
 - [Pong](docs/Model/Pong.md)
 - [RelFile](docs/Model/RelFile.md)
 - [Release](docs/Model/Release.md)
 - [SimpleChamber](docs/Model/SimpleChamber.md)
 - [SimpleGroup](docs/Model/SimpleGroup.md)
 - [SimpleUser](docs/Model/SimpleUser.md)
 - [Skill](docs/Model/Skill.md)
 - [Token](docs/Model/Token.md)
 - [User](docs/Model/User.md)


## Documentation For Authorization


## oauth2-code

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: https://osdn.jp/account/oauth2ui/authorize
- **Scopes**: 
 - **profile**: Read basic user profile
 - **group**: read access to group data
 - **group_write**: write access to group data
 - **chamber**: read access to chamber data
 - **chamber_write**: write access to chamber data

## oauth2-implicit

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: https://osdn.jp/account/oauth2ui/authorize
- **Scopes**: 
 - **profile**: Read basic user profile
 - **group**: read access to group data
 - **group_write**: write access to group data
 - **chamber**: read access to chamber data
 - **chamber_write**: write access to chamber data


## Author

admin@osdn.jp


