<?php
/**
 * ProjectFrsApi
 * PHP version 5
 *
 * @category Class
 * @package  OSDN
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * OSDN REST API v0 beta
 *
 * OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.net/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.net/projects/osdn-codes/releases/p14859 .
 *
 * OpenAPI spec version: 0.0.20171120
 * Contact: admin@osdn.net
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace OSDN\Api;

use \OSDN\Configuration;
use \OSDN\ApiClient;
use \OSDN\ApiException;
use \OSDN\ObjectSerializer;

/**
 * ProjectFrsApi Class Doc Comment
 *
 * @category Class
 * @package  OSDN
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ProjectFrsApi
{

    /**
     * API Client
     *
     * @var \OSDN\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \OSDN\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\OSDN\ApiClient $apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://osdn.net/api/v0');
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \OSDN\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \OSDN\ApiClient $apiClient set the API client
     *
     * @return ProjectFrsApi
     */
    public function setApiClient(\OSDN\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation createPackage
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name package name (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @return \OSDN\Model\Package
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createPackage($id_or_name, $name, $visibility = null)
    {
        list($response) = $this->createPackageWithHttpInfo($id_or_name, $name, $visibility);
        return $response;
    }

    /**
     * Operation createPackageWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name package name (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @return Array of \OSDN\Model\Package, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createPackageWithHttpInfo($id_or_name, $name, $visibility = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createPackage');
        }
        // verify the required parameter 'name' is set
        if ($name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $name when calling createPackage');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($visibility !== null) {
            $formParams['visibility'] = $this->apiClient->getSerializer()->toFormValue($visibility);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\Package',
                '/project/{id_or_name}/frs'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\Package', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\Package', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createRelease
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param string $name Release name (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @param \DateTime $time Release datetime. If you set future time, the release hide until specified time. (optional)
     * @param string $release_note Release note body text. (optional)
     * @param string $change_log Changelog body text. (optional)
     * @return \OSDN\Model\Release
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createRelease($id_or_name, $package_id, $name, $visibility = null, $time = null, $release_note = null, $change_log = null)
    {
        list($response) = $this->createReleaseWithHttpInfo($id_or_name, $package_id, $name, $visibility, $time, $release_note, $change_log);
        return $response;
    }

    /**
     * Operation createReleaseWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param string $name Release name (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @param \DateTime $time Release datetime. If you set future time, the release hide until specified time. (optional)
     * @param string $release_note Release note body text. (optional)
     * @param string $change_log Changelog body text. (optional)
     * @return Array of \OSDN\Model\Release, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createReleaseWithHttpInfo($id_or_name, $package_id, $name, $visibility = null, $time = null, $release_note = null, $change_log = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createRelease');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling createRelease');
        }
        // verify the required parameter 'name' is set
        if ($name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $name when calling createRelease');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($visibility !== null) {
            $formParams['visibility'] = $this->apiClient->getSerializer()->toFormValue($visibility);
        }
        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($time !== null) {
            $formParams['time'] = $this->apiClient->getSerializer()->toFormValue($time);
        }
        // form params
        if ($release_note !== null) {
            $formParams['release_note'] = $this->apiClient->getSerializer()->toFormValue($release_note);
        }
        // form params
        if ($change_log !== null) {
            $formParams['change_log'] = $this->apiClient->getSerializer()->toFormValue($change_log);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\Release',
                '/project/{id_or_name}/frs/{package_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\Release', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\Release', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createReleaseFile
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param \SplFileObject $file Upload file in \&quot;multipart/form-data\&quot;. (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @return \OSDN\Model\RelFile
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createReleaseFile($id_or_name, $package_id, $release_id, $file, $visibility = null)
    {
        list($response) = $this->createReleaseFileWithHttpInfo($id_or_name, $package_id, $release_id, $file, $visibility);
        return $response;
    }

    /**
     * Operation createReleaseFileWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param \SplFileObject $file Upload file in \&quot;multipart/form-data\&quot;. (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @return Array of \OSDN\Model\RelFile, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createReleaseFileWithHttpInfo($id_or_name, $package_id, $release_id, $file, $visibility = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createReleaseFile');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling createReleaseFile');
        }
        // verify the required parameter 'release_id' is set
        if ($release_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $release_id when calling createReleaseFile');
        }
        // verify the required parameter 'file' is set
        if ($file === null) {
            throw new \InvalidArgumentException('Missing the required parameter $file when calling createReleaseFile');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}/{release_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('multipart/form-data'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // path params
        if ($release_id !== null) {
            $resourcePath = str_replace(
                "{" . "release_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($release_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($visibility !== null) {
            $formParams['visibility'] = $this->apiClient->getSerializer()->toFormValue($visibility);
        }
        // form params
        if ($file !== null) {
            // PHP 5.5 introduced a CurlFile object that deprecates the old @filename syntax
            // See: https://wiki.php.net/rfc/curl-file-upload
            if (function_exists('curl_file_create')) {
                $formParams['file'] = curl_file_create($this->apiClient->getSerializer()->toFormValue($file));
            } else {
                $formParams['file'] = '@' . $this->apiClient->getSerializer()->toFormValue($file);
            }
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\RelFile',
                '/project/{id_or_name}/frs/{package_id}/{release_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\RelFile', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\RelFile', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deletePackage
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deletePackage($id_or_name, $package_id)
    {
        list($response) = $this->deletePackageWithHttpInfo($id_or_name, $package_id);
        return $response;
    }

    /**
     * Operation deletePackageWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deletePackageWithHttpInfo($id_or_name, $package_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling deletePackage');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling deletePackage');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/project/{id_or_name}/frs/{package_id}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

    /**
     * Operation deleteRelease
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteRelease($id_or_name, $package_id, $release_id)
    {
        list($response) = $this->deleteReleaseWithHttpInfo($id_or_name, $package_id, $release_id);
        return $response;
    }

    /**
     * Operation deleteReleaseWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteReleaseWithHttpInfo($id_or_name, $package_id, $release_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling deleteRelease');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling deleteRelease');
        }
        // verify the required parameter 'release_id' is set
        if ($release_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $release_id when calling deleteRelease');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}/{release_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // path params
        if ($release_id !== null) {
            $resourcePath = str_replace(
                "{" . "release_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($release_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/project/{id_or_name}/frs/{package_id}/{release_id}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

    /**
     * Operation deleteReleaseFile
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param int $file_id  (required)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteReleaseFile($id_or_name, $package_id, $release_id, $file_id)
    {
        list($response) = $this->deleteReleaseFileWithHttpInfo($id_or_name, $package_id, $release_id, $file_id);
        return $response;
    }

    /**
     * Operation deleteReleaseFileWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param int $file_id  (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteReleaseFileWithHttpInfo($id_or_name, $package_id, $release_id, $file_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling deleteReleaseFile');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling deleteReleaseFile');
        }
        // verify the required parameter 'release_id' is set
        if ($release_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $release_id when calling deleteReleaseFile');
        }
        // verify the required parameter 'file_id' is set
        if ($file_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $file_id when calling deleteReleaseFile');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // path params
        if ($release_id !== null) {
            $resourcePath = str_replace(
                "{" . "release_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($release_id),
                $resourcePath
            );
        }
        // path params
        if ($file_id !== null) {
            $resourcePath = str_replace(
                "{" . "file_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($file_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

    /**
     * Operation draftRelease
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @return \OSDN\Model\Release
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function draftRelease($id_or_name, $package_id)
    {
        list($response) = $this->draftReleaseWithHttpInfo($id_or_name, $package_id);
        return $response;
    }

    /**
     * Operation draftReleaseWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @return Array of \OSDN\Model\Release, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function draftReleaseWithHttpInfo($id_or_name, $package_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling draftRelease');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling draftRelease');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}/draft";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\Release',
                '/project/{id_or_name}/frs/{package_id}/draft'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\Release', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\Release', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getFrsAdminprefs
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\FrsAdminPrefs
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getFrsAdminprefs($id_or_name)
    {
        list($response) = $this->getFrsAdminprefsWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation getFrsAdminprefsWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\FrsAdminPrefs, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getFrsAdminprefsWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getFrsAdminprefs');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/admin";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\FrsAdminPrefs',
                '/project/{id_or_name}/frs/admin'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\FrsAdminPrefs', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\FrsAdminPrefs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getPackage
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @return \OSDN\Model\Package
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getPackage($id_or_name, $package_id)
    {
        list($response) = $this->getPackageWithHttpInfo($id_or_name, $package_id);
        return $response;
    }

    /**
     * Operation getPackageWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @return Array of \OSDN\Model\Package, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getPackageWithHttpInfo($id_or_name, $package_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getPackage');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling getPackage');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\Package',
                '/project/{id_or_name}/frs/{package_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\Package', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\Package', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getRelease
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @return \OSDN\Model\Release
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getRelease($id_or_name, $package_id, $release_id)
    {
        list($response) = $this->getReleaseWithHttpInfo($id_or_name, $package_id, $release_id);
        return $response;
    }

    /**
     * Operation getReleaseWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @return Array of \OSDN\Model\Release, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getReleaseWithHttpInfo($id_or_name, $package_id, $release_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getRelease');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling getRelease');
        }
        // verify the required parameter 'release_id' is set
        if ($release_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $release_id when calling getRelease');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}/{release_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // path params
        if ($release_id !== null) {
            $resourcePath = str_replace(
                "{" . "release_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($release_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\Release',
                '/project/{id_or_name}/frs/{package_id}/{release_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\Release', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\Release', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getReleaseFile
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param int $file_id  (required)
     * @return \OSDN\Model\RelFile
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getReleaseFile($id_or_name, $package_id, $release_id, $file_id)
    {
        list($response) = $this->getReleaseFileWithHttpInfo($id_or_name, $package_id, $release_id, $file_id);
        return $response;
    }

    /**
     * Operation getReleaseFileWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param int $file_id  (required)
     * @return Array of \OSDN\Model\RelFile, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getReleaseFileWithHttpInfo($id_or_name, $package_id, $release_id, $file_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getReleaseFile');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling getReleaseFile');
        }
        // verify the required parameter 'release_id' is set
        if ($release_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $release_id when calling getReleaseFile');
        }
        // verify the required parameter 'file_id' is set
        if ($file_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $file_id when calling getReleaseFile');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // path params
        if ($release_id !== null) {
            $resourcePath = str_replace(
                "{" . "release_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($release_id),
                $resourcePath
            );
        }
        // path params
        if ($file_id !== null) {
            $resourcePath = str_replace(
                "{" . "file_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($file_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\RelFile',
                '/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\RelFile', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\RelFile', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listPackages
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\Package[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listPackages($id_or_name)
    {
        list($response) = $this->listPackagesWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation listPackagesWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\Package[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listPackagesWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling listPackages');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\Package[]',
                '/project/{id_or_name}/frs'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\Package[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\Package[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateFrsAdminprefs
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param bool $allow_overwrite Allow overwrite files when filenames are conflict (optional)
     * @return \OSDN\Model\FrsAdminPrefs
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateFrsAdminprefs($id_or_name, $allow_overwrite = null)
    {
        list($response) = $this->updateFrsAdminprefsWithHttpInfo($id_or_name, $allow_overwrite);
        return $response;
    }

    /**
     * Operation updateFrsAdminprefsWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param bool $allow_overwrite Allow overwrite files when filenames are conflict (optional)
     * @return Array of \OSDN\Model\FrsAdminPrefs, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateFrsAdminprefsWithHttpInfo($id_or_name, $allow_overwrite = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateFrsAdminprefs');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/admin";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($allow_overwrite !== null) {
            $formParams['allow_overwrite'] = $this->apiClient->getSerializer()->toFormValue($allow_overwrite);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\FrsAdminPrefs',
                '/project/{id_or_name}/frs/admin'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\FrsAdminPrefs', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\FrsAdminPrefs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updatePackage
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param string $name package name (optional)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @return \OSDN\Model\Package
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updatePackage($id_or_name, $package_id, $name = null, $visibility = null)
    {
        list($response) = $this->updatePackageWithHttpInfo($id_or_name, $package_id, $name, $visibility);
        return $response;
    }

    /**
     * Operation updatePackageWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param string $name package name (optional)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @return Array of \OSDN\Model\Package, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updatePackageWithHttpInfo($id_or_name, $package_id, $name = null, $visibility = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updatePackage');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling updatePackage');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($visibility !== null) {
            $formParams['visibility'] = $this->apiClient->getSerializer()->toFormValue($visibility);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\Package',
                '/project/{id_or_name}/frs/{package_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\Package', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\Package', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateRelease
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @param string $name Release name (optional)
     * @param \DateTime $time Release datetime. If you set future time, the release hide until specified time. (optional)
     * @param int $move_to_package_id If this parameter is specified, the release move to another package. (optional)
     * @return \OSDN\Model\Release
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateRelease($id_or_name, $package_id, $release_id, $visibility = null, $name = null, $time = null, $move_to_package_id = null)
    {
        list($response) = $this->updateReleaseWithHttpInfo($id_or_name, $package_id, $release_id, $visibility, $name, $time, $move_to_package_id);
        return $response;
    }

    /**
     * Operation updateReleaseWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @param string $name Release name (optional)
     * @param \DateTime $time Release datetime. If you set future time, the release hide until specified time. (optional)
     * @param int $move_to_package_id If this parameter is specified, the release move to another package. (optional)
     * @return Array of \OSDN\Model\Release, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateReleaseWithHttpInfo($id_or_name, $package_id, $release_id, $visibility = null, $name = null, $time = null, $move_to_package_id = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateRelease');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling updateRelease');
        }
        // verify the required parameter 'release_id' is set
        if ($release_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $release_id when calling updateRelease');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}/{release_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // path params
        if ($release_id !== null) {
            $resourcePath = str_replace(
                "{" . "release_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($release_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($visibility !== null) {
            $formParams['visibility'] = $this->apiClient->getSerializer()->toFormValue($visibility);
        }
        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($time !== null) {
            $formParams['time'] = $this->apiClient->getSerializer()->toFormValue($time);
        }
        // form params
        if ($move_to_package_id !== null) {
            $formParams['move_to_package_id'] = $this->apiClient->getSerializer()->toFormValue($move_to_package_id);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\Release',
                '/project/{id_or_name}/frs/{package_id}/{release_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\Release', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\Release', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateReleaseFile
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param int $file_id  (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @return \OSDN\Model\RelFile
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateReleaseFile($id_or_name, $package_id, $release_id, $file_id, $visibility = null)
    {
        list($response) = $this->updateReleaseFileWithHttpInfo($id_or_name, $package_id, $release_id, $file_id, $visibility);
        return $response;
    }

    /**
     * Operation updateReleaseFileWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param int $file_id  (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @return Array of \OSDN\Model\RelFile, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateReleaseFileWithHttpInfo($id_or_name, $package_id, $release_id, $file_id, $visibility = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateReleaseFile');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling updateReleaseFile');
        }
        // verify the required parameter 'release_id' is set
        if ($release_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $release_id when calling updateReleaseFile');
        }
        // verify the required parameter 'file_id' is set
        if ($file_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $file_id when calling updateReleaseFile');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // path params
        if ($release_id !== null) {
            $resourcePath = str_replace(
                "{" . "release_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($release_id),
                $resourcePath
            );
        }
        // path params
        if ($file_id !== null) {
            $resourcePath = str_replace(
                "{" . "file_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($file_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($visibility !== null) {
            $formParams['visibility'] = $this->apiClient->getSerializer()->toFormValue($visibility);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\RelFile',
                '/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\RelFile', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\RelFile', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

}
