<?php
/**
 * ProjectNewsApi
 * PHP version 5
 *
 * @category Class
 * @package  OSDN
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * OSDN REST API v0 beta
 *
 * OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.net/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.net/projects/osdn-codes/releases/p14859 .
 *
 * OpenAPI spec version: 0.0.20171120
 * Contact: admin@osdn.net
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace OSDN\Api;

use \OSDN\Configuration;
use \OSDN\ApiClient;
use \OSDN\ApiException;
use \OSDN\ObjectSerializer;

/**
 * ProjectNewsApi Class Doc Comment
 *
 * @category Class
 * @package  OSDN
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ProjectNewsApi
{

    /**
     * API Client
     *
     * @var \OSDN\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \OSDN\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\OSDN\ApiClient $apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://osdn.net/api/v0');
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \OSDN\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \OSDN\ApiClient $apiClient set the API client
     *
     * @return ProjectNewsApi
     */
    public function setApiClient(\OSDN\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation createNews
     *
     * 
     *
     * @param string $title news title (required)
     * @param string $body news body in OSDN Wiki format. (required)
     * @param int $group_id group_id the news created in (required)
     * @return string
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createNews($title, $body, $group_id)
    {
        list($response) = $this->createNewsWithHttpInfo($title, $body, $group_id);
        return $response;
    }

    /**
     * Operation createNewsWithHttpInfo
     *
     * 
     *
     * @param string $title news title (required)
     * @param string $body news body in OSDN Wiki format. (required)
     * @param int $group_id group_id the news created in (required)
     * @return Array of string, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createNewsWithHttpInfo($title, $body, $group_id)
    {
        // verify the required parameter 'title' is set
        if ($title === null) {
            throw new \InvalidArgumentException('Missing the required parameter $title when calling createNews');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling createNews');
        }
        // verify the required parameter 'group_id' is set
        if ($group_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $group_id when calling createNews');
        }
        // parse inputs
        $resourcePath = "/news";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // query params
        if ($group_id !== null) {
            $queryParams['group_id'] = $this->apiClient->getSerializer()->toQueryValue($group_id);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($title !== null) {
            $formParams['title'] = $this->apiClient->getSerializer()->toFormValue($title);
        }
        // form params
        if ($body !== null) {
            $formParams['body'] = $this->apiClient->getSerializer()->toFormValue($body);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                'string',
                '/news'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, 'string', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), 'string', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createNews_0
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $title news title (required)
     * @param string $body news body in OSDN Wiki format. (required)
     * @return string
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createNews_0($id_or_name, $title, $body)
    {
        list($response) = $this->createNews_0WithHttpInfo($id_or_name, $title, $body);
        return $response;
    }

    /**
     * Operation createNews_0WithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $title news title (required)
     * @param string $body news body in OSDN Wiki format. (required)
     * @return Array of string, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createNews_0WithHttpInfo($id_or_name, $title, $body)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createNews_0');
        }
        // verify the required parameter 'title' is set
        if ($title === null) {
            throw new \InvalidArgumentException('Missing the required parameter $title when calling createNews_0');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling createNews_0');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/news";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($title !== null) {
            $formParams['title'] = $this->apiClient->getSerializer()->toFormValue($title);
        }
        // form params
        if ($body !== null) {
            $formParams['body'] = $this->apiClient->getSerializer()->toFormValue($body);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                'string',
                '/project/{id_or_name}/news'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, 'string', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), 'string', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteNews
     *
     * 
     *
     * @param int $news_id  (required)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteNews($news_id)
    {
        list($response) = $this->deleteNewsWithHttpInfo($news_id);
        return $response;
    }

    /**
     * Operation deleteNewsWithHttpInfo
     *
     * 
     *
     * @param int $news_id  (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteNewsWithHttpInfo($news_id)
    {
        // verify the required parameter 'news_id' is set
        if ($news_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $news_id when calling deleteNews');
        }
        // parse inputs
        $resourcePath = "/news/{news_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($news_id !== null) {
            $resourcePath = str_replace(
                "{" . "news_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($news_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/news/{news_id}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

    /**
     * Operation deleteNews_0
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $news_id  (required)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteNews_0($id_or_name, $news_id)
    {
        list($response) = $this->deleteNews_0WithHttpInfo($id_or_name, $news_id);
        return $response;
    }

    /**
     * Operation deleteNews_0WithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $news_id  (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteNews_0WithHttpInfo($id_or_name, $news_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling deleteNews_0');
        }
        // verify the required parameter 'news_id' is set
        if ($news_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $news_id when calling deleteNews_0');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/news/{news_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($news_id !== null) {
            $resourcePath = str_replace(
                "{" . "news_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($news_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/project/{id_or_name}/news/{news_id}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

    /**
     * Operation getNews
     *
     * 
     *
     * @param int $news_id  (required)
     * @return \OSDN\Model\News
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getNews($news_id)
    {
        list($response) = $this->getNewsWithHttpInfo($news_id);
        return $response;
    }

    /**
     * Operation getNewsWithHttpInfo
     *
     * 
     *
     * @param int $news_id  (required)
     * @return Array of \OSDN\Model\News, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getNewsWithHttpInfo($news_id)
    {
        // verify the required parameter 'news_id' is set
        if ($news_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $news_id when calling getNews');
        }
        // parse inputs
        $resourcePath = "/news/{news_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($news_id !== null) {
            $resourcePath = str_replace(
                "{" . "news_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($news_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\News',
                '/news/{news_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\News', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\News', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getNews_0
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $news_id  (required)
     * @return \OSDN\Model\News
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getNews_0($id_or_name, $news_id)
    {
        list($response) = $this->getNews_0WithHttpInfo($id_or_name, $news_id);
        return $response;
    }

    /**
     * Operation getNews_0WithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $news_id  (required)
     * @return Array of \OSDN\Model\News, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getNews_0WithHttpInfo($id_or_name, $news_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getNews_0');
        }
        // verify the required parameter 'news_id' is set
        if ($news_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $news_id when calling getNews_0');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/news/{news_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($news_id !== null) {
            $resourcePath = str_replace(
                "{" . "news_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($news_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\News',
                '/project/{id_or_name}/news/{news_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\News', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\News', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listNews
     *
     * 
     *
     * @param int $group_id filter by group ID (optional)
     * @return \OSDN\Model\News[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listNews($group_id = null)
    {
        list($response) = $this->listNewsWithHttpInfo($group_id);
        return $response;
    }

    /**
     * Operation listNewsWithHttpInfo
     *
     * 
     *
     * @param int $group_id filter by group ID (optional)
     * @return Array of \OSDN\Model\News[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listNewsWithHttpInfo($group_id = null)
    {
        // parse inputs
        $resourcePath = "/news";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // query params
        if ($group_id !== null) {
            $queryParams['group_id'] = $this->apiClient->getSerializer()->toQueryValue($group_id);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\News[]',
                '/news'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\News[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\News[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listNews_0
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\News[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listNews_0($id_or_name)
    {
        list($response) = $this->listNews_0WithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation listNews_0WithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\News[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listNews_0WithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling listNews_0');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/news";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\News[]',
                '/project/{id_or_name}/news'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\News[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\News[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateNews
     *
     * 
     *
     * @param int $news_id  (required)
     * @param string $title news title (optional)
     * @param string $body news body in OSDN Wiki format. (optional)
     * @return \OSDN\Model\News
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateNews($news_id, $title = null, $body = null)
    {
        list($response) = $this->updateNewsWithHttpInfo($news_id, $title, $body);
        return $response;
    }

    /**
     * Operation updateNewsWithHttpInfo
     *
     * 
     *
     * @param int $news_id  (required)
     * @param string $title news title (optional)
     * @param string $body news body in OSDN Wiki format. (optional)
     * @return Array of \OSDN\Model\News, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateNewsWithHttpInfo($news_id, $title = null, $body = null)
    {
        // verify the required parameter 'news_id' is set
        if ($news_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $news_id when calling updateNews');
        }
        // parse inputs
        $resourcePath = "/news/{news_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($news_id !== null) {
            $resourcePath = str_replace(
                "{" . "news_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($news_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($title !== null) {
            $formParams['title'] = $this->apiClient->getSerializer()->toFormValue($title);
        }
        // form params
        if ($body !== null) {
            $formParams['body'] = $this->apiClient->getSerializer()->toFormValue($body);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\News',
                '/news/{news_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\News', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\News', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateNews_0
     *
     * 
     *
     * @param int $news_id  (required)
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $title news title (optional)
     * @param string $body news body in OSDN Wiki format. (optional)
     * @return \OSDN\Model\News
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateNews_0($news_id, $id_or_name, $title = null, $body = null)
    {
        list($response) = $this->updateNews_0WithHttpInfo($news_id, $id_or_name, $title, $body);
        return $response;
    }

    /**
     * Operation updateNews_0WithHttpInfo
     *
     * 
     *
     * @param int $news_id  (required)
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $title news title (optional)
     * @param string $body news body in OSDN Wiki format. (optional)
     * @return Array of \OSDN\Model\News, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateNews_0WithHttpInfo($news_id, $id_or_name, $title = null, $body = null)
    {
        // verify the required parameter 'news_id' is set
        if ($news_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $news_id when calling updateNews_0');
        }
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateNews_0');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/news/{news_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($news_id !== null) {
            $resourcePath = str_replace(
                "{" . "news_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($news_id),
                $resourcePath
            );
        }
        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($title !== null) {
            $formParams['title'] = $this->apiClient->getSerializer()->toFormValue($title);
        }
        // form params
        if ($body !== null) {
            $formParams['body'] = $this->apiClient->getSerializer()->toFormValue($body);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\News',
                '/project/{id_or_name}/news/{news_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\News', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\News', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

}
