<?php
/**
 * ProjectSCMApi
 * PHP version 5
 *
 * @category Class
 * @package  OSDN
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * OSDN REST API v0 beta
 *
 * OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.net/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.net/projects/osdn-codes/releases/p14859 .
 *
 * OpenAPI spec version: 0.0.20171120
 * Contact: admin@osdn.net
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace OSDN\Api;

use \OSDN\Configuration;
use \OSDN\ApiClient;
use \OSDN\ApiException;
use \OSDN\ObjectSerializer;

/**
 * ProjectSCMApi Class Doc Comment
 *
 * @category Class
 * @package  OSDN
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ProjectSCMApi
{

    /**
     * API Client
     *
     * @var \OSDN\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \OSDN\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\OSDN\ApiClient $apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://osdn.net/api/v0');
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \OSDN\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \OSDN\ApiClient $apiClient set the API client
     *
     * @return ProjectSCMApi
     */
    public function setApiClient(\OSDN\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation createProjectBzr
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name  (required)
     * @param string $description  (optional)
     * @return \OSDN\Model\ProjectBzr
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectBzr($id_or_name, $name, $description = null)
    {
        list($response) = $this->createProjectBzrWithHttpInfo($id_or_name, $name, $description);
        return $response;
    }

    /**
     * Operation createProjectBzrWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name  (required)
     * @param string $description  (optional)
     * @return Array of \OSDN\Model\ProjectBzr, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectBzrWithHttpInfo($id_or_name, $name, $description = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createProjectBzr');
        }
        // verify the required parameter 'name' is set
        if ($name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $name when calling createProjectBzr');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/bzr";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectBzr',
                '/project/{id_or_name}/bzr'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectBzr', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectBzr', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createProjectGit
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name  (required)
     * @param string $description  (optional)
     * @param bool $mail_enabled  (optional)
     * @param string $mail_recipients  (optional)
     * @param bool $allow_non_fast_forward  (optional)
     * @param string $default_branch  (optional)
     * @return \OSDN\Model\ProjectGit
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectGit($id_or_name, $name, $description = null, $mail_enabled = null, $mail_recipients = null, $allow_non_fast_forward = null, $default_branch = null)
    {
        list($response) = $this->createProjectGitWithHttpInfo($id_or_name, $name, $description, $mail_enabled, $mail_recipients, $allow_non_fast_forward, $default_branch);
        return $response;
    }

    /**
     * Operation createProjectGitWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name  (required)
     * @param string $description  (optional)
     * @param bool $mail_enabled  (optional)
     * @param string $mail_recipients  (optional)
     * @param bool $allow_non_fast_forward  (optional)
     * @param string $default_branch  (optional)
     * @return Array of \OSDN\Model\ProjectGit, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectGitWithHttpInfo($id_or_name, $name, $description = null, $mail_enabled = null, $mail_recipients = null, $allow_non_fast_forward = null, $default_branch = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createProjectGit');
        }
        // verify the required parameter 'name' is set
        if ($name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $name when calling createProjectGit');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/git";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        // form params
        if ($mail_enabled !== null) {
            $formParams['mail_enabled'] = $this->apiClient->getSerializer()->toFormValue($mail_enabled);
        }
        // form params
        if ($mail_recipients !== null) {
            $formParams['mail_recipients'] = $this->apiClient->getSerializer()->toFormValue($mail_recipients);
        }
        // form params
        if ($allow_non_fast_forward !== null) {
            $formParams['allow_non_fast_forward'] = $this->apiClient->getSerializer()->toFormValue($allow_non_fast_forward);
        }
        // form params
        if ($default_branch !== null) {
            $formParams['default_branch'] = $this->apiClient->getSerializer()->toFormValue($default_branch);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectGit',
                '/project/{id_or_name}/git'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectGit', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectGit', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createProjectGitHook
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @param string $target_url  (required)
     * @return \OSDN\Model\ScmHook
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectGitHook($id_or_name, $repo_id, $target_url)
    {
        list($response) = $this->createProjectGitHookWithHttpInfo($id_or_name, $repo_id, $target_url);
        return $response;
    }

    /**
     * Operation createProjectGitHookWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @param string $target_url  (required)
     * @return Array of \OSDN\Model\ScmHook, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectGitHookWithHttpInfo($id_or_name, $repo_id, $target_url)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createProjectGitHook');
        }
        // verify the required parameter 'repo_id' is set
        if ($repo_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $repo_id when calling createProjectGitHook');
        }
        // verify the required parameter 'target_url' is set
        if ($target_url === null) {
            throw new \InvalidArgumentException('Missing the required parameter $target_url when calling createProjectGitHook');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/git/{repo_id}/hooks";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($repo_id !== null) {
            $resourcePath = str_replace(
                "{" . "repo_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($repo_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($target_url !== null) {
            $formParams['target_url'] = $this->apiClient->getSerializer()->toFormValue($target_url);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ScmHook',
                '/project/{id_or_name}/git/{repo_id}/hooks'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ScmHook', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ScmHook', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createProjectHg
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name  (required)
     * @param string $description  (optional)
     * @param string $mail_recipients  (optional)
     * @return \OSDN\Model\ProjectHg
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectHg($id_or_name, $name, $description = null, $mail_recipients = null)
    {
        list($response) = $this->createProjectHgWithHttpInfo($id_or_name, $name, $description, $mail_recipients);
        return $response;
    }

    /**
     * Operation createProjectHgWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name  (required)
     * @param string $description  (optional)
     * @param string $mail_recipients  (optional)
     * @return Array of \OSDN\Model\ProjectHg, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectHgWithHttpInfo($id_or_name, $name, $description = null, $mail_recipients = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createProjectHg');
        }
        // verify the required parameter 'name' is set
        if ($name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $name when calling createProjectHg');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/hg";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        // form params
        if ($mail_recipients !== null) {
            $formParams['mail_recipients'] = $this->apiClient->getSerializer()->toFormValue($mail_recipients);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectHg',
                '/project/{id_or_name}/hg'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectHg', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectHg', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteProjectGitHook
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @param int $hook_id  (required)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteProjectGitHook($id_or_name, $repo_id, $hook_id)
    {
        list($response) = $this->deleteProjectGitHookWithHttpInfo($id_or_name, $repo_id, $hook_id);
        return $response;
    }

    /**
     * Operation deleteProjectGitHookWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @param int $hook_id  (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteProjectGitHookWithHttpInfo($id_or_name, $repo_id, $hook_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling deleteProjectGitHook');
        }
        // verify the required parameter 'repo_id' is set
        if ($repo_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $repo_id when calling deleteProjectGitHook');
        }
        // verify the required parameter 'hook_id' is set
        if ($hook_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $hook_id when calling deleteProjectGitHook');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/git/{repo_id}/hooks/{hook_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($repo_id !== null) {
            $resourcePath = str_replace(
                "{" . "repo_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($repo_id),
                $resourcePath
            );
        }
        // path params
        if ($hook_id !== null) {
            $resourcePath = str_replace(
                "{" . "hook_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($hook_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/project/{id_or_name}/git/{repo_id}/hooks/{hook_id}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

    /**
     * Operation disableProjectBzr
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return \OSDN\Model\ProjectBzr
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function disableProjectBzr($id_or_name, $repo_id)
    {
        list($response) = $this->disableProjectBzrWithHttpInfo($id_or_name, $repo_id);
        return $response;
    }

    /**
     * Operation disableProjectBzrWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return Array of \OSDN\Model\ProjectBzr, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function disableProjectBzrWithHttpInfo($id_or_name, $repo_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling disableProjectBzr');
        }
        // verify the required parameter 'repo_id' is set
        if ($repo_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $repo_id when calling disableProjectBzr');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/bzr/{repo_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($repo_id !== null) {
            $resourcePath = str_replace(
                "{" . "repo_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($repo_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectBzr',
                '/project/{id_or_name}/bzr/{repo_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectBzr', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectBzr', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation disableProjectGit
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return \OSDN\Model\ProjectGit
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function disableProjectGit($id_or_name, $repo_id)
    {
        list($response) = $this->disableProjectGitWithHttpInfo($id_or_name, $repo_id);
        return $response;
    }

    /**
     * Operation disableProjectGitWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return Array of \OSDN\Model\ProjectGit, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function disableProjectGitWithHttpInfo($id_or_name, $repo_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling disableProjectGit');
        }
        // verify the required parameter 'repo_id' is set
        if ($repo_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $repo_id when calling disableProjectGit');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/git/{repo_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($repo_id !== null) {
            $resourcePath = str_replace(
                "{" . "repo_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($repo_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectGit',
                '/project/{id_or_name}/git/{repo_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectGit', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectGit', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation disableProjectHg
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return \OSDN\Model\ProjectHg
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function disableProjectHg($id_or_name, $repo_id)
    {
        list($response) = $this->disableProjectHgWithHttpInfo($id_or_name, $repo_id);
        return $response;
    }

    /**
     * Operation disableProjectHgWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return Array of \OSDN\Model\ProjectHg, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function disableProjectHgWithHttpInfo($id_or_name, $repo_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling disableProjectHg');
        }
        // verify the required parameter 'repo_id' is set
        if ($repo_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $repo_id when calling disableProjectHg');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/hg/{repo_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($repo_id !== null) {
            $resourcePath = str_replace(
                "{" . "repo_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($repo_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectHg',
                '/project/{id_or_name}/hg/{repo_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectHg', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectHg', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectBzr
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return \OSDN\Model\ProjectBzr
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectBzr($id_or_name, $repo_id)
    {
        list($response) = $this->getProjectBzrWithHttpInfo($id_or_name, $repo_id);
        return $response;
    }

    /**
     * Operation getProjectBzrWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return Array of \OSDN\Model\ProjectBzr, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectBzrWithHttpInfo($id_or_name, $repo_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectBzr');
        }
        // verify the required parameter 'repo_id' is set
        if ($repo_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $repo_id when calling getProjectBzr');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/bzr/{repo_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($repo_id !== null) {
            $resourcePath = str_replace(
                "{" . "repo_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($repo_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectBzr',
                '/project/{id_or_name}/bzr/{repo_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectBzr', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectBzr', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectGit
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return \OSDN\Model\ProjectGit
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectGit($id_or_name, $repo_id)
    {
        list($response) = $this->getProjectGitWithHttpInfo($id_or_name, $repo_id);
        return $response;
    }

    /**
     * Operation getProjectGitWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return Array of \OSDN\Model\ProjectGit, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectGitWithHttpInfo($id_or_name, $repo_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectGit');
        }
        // verify the required parameter 'repo_id' is set
        if ($repo_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $repo_id when calling getProjectGit');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/git/{repo_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($repo_id !== null) {
            $resourcePath = str_replace(
                "{" . "repo_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($repo_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectGit',
                '/project/{id_or_name}/git/{repo_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectGit', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectGit', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectGitHook
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @param int $hook_id  (required)
     * @return \OSDN\Model\ScmHook
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectGitHook($id_or_name, $repo_id, $hook_id)
    {
        list($response) = $this->getProjectGitHookWithHttpInfo($id_or_name, $repo_id, $hook_id);
        return $response;
    }

    /**
     * Operation getProjectGitHookWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @param int $hook_id  (required)
     * @return Array of \OSDN\Model\ScmHook, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectGitHookWithHttpInfo($id_or_name, $repo_id, $hook_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectGitHook');
        }
        // verify the required parameter 'repo_id' is set
        if ($repo_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $repo_id when calling getProjectGitHook');
        }
        // verify the required parameter 'hook_id' is set
        if ($hook_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $hook_id when calling getProjectGitHook');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/git/{repo_id}/hooks/{hook_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($repo_id !== null) {
            $resourcePath = str_replace(
                "{" . "repo_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($repo_id),
                $resourcePath
            );
        }
        // path params
        if ($hook_id !== null) {
            $resourcePath = str_replace(
                "{" . "hook_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($hook_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ScmHook',
                '/project/{id_or_name}/git/{repo_id}/hooks/{hook_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ScmHook', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ScmHook', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectHg
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return \OSDN\Model\ProjectHg
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectHg($id_or_name, $repo_id)
    {
        list($response) = $this->getProjectHgWithHttpInfo($id_or_name, $repo_id);
        return $response;
    }

    /**
     * Operation getProjectHgWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return Array of \OSDN\Model\ProjectHg, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectHgWithHttpInfo($id_or_name, $repo_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectHg');
        }
        // verify the required parameter 'repo_id' is set
        if ($repo_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $repo_id when calling getProjectHg');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/hg/{repo_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($repo_id !== null) {
            $resourcePath = str_replace(
                "{" . "repo_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($repo_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectHg',
                '/project/{id_or_name}/hg/{repo_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectHg', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectHg', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectSvn
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\ProjectSvn
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectSvn($id_or_name)
    {
        list($response) = $this->getProjectSvnWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation getProjectSvnWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\ProjectSvn, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectSvnWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectSvn');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/svn";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectSvn',
                '/project/{id_or_name}/svn'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectSvn', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectSvn', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listProjectBzr
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\ProjectBzr[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectBzr($id_or_name)
    {
        list($response) = $this->listProjectBzrWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation listProjectBzrWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\ProjectBzr[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectBzrWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling listProjectBzr');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/bzr";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectBzr[]',
                '/project/{id_or_name}/bzr'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectBzr[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectBzr[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listProjectGit
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\ProjectGit[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectGit($id_or_name)
    {
        list($response) = $this->listProjectGitWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation listProjectGitWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\ProjectGit[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectGitWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling listProjectGit');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/git";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectGit[]',
                '/project/{id_or_name}/git'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectGit[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectGit[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listProjectGitHook
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return \OSDN\Model\ScmHook[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectGitHook($id_or_name, $repo_id)
    {
        list($response) = $this->listProjectGitHookWithHttpInfo($id_or_name, $repo_id);
        return $response;
    }

    /**
     * Operation listProjectGitHookWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return Array of \OSDN\Model\ScmHook[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectGitHookWithHttpInfo($id_or_name, $repo_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling listProjectGitHook');
        }
        // verify the required parameter 'repo_id' is set
        if ($repo_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $repo_id when calling listProjectGitHook');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/git/{repo_id}/hooks";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($repo_id !== null) {
            $resourcePath = str_replace(
                "{" . "repo_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($repo_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ScmHook[]',
                '/project/{id_or_name}/git/{repo_id}/hooks'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ScmHook[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ScmHook[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listProjectHg
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\ProjectHg[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectHg($id_or_name)
    {
        list($response) = $this->listProjectHgWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation listProjectHgWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\ProjectHg[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectHgWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling listProjectHg');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/hg";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectHg[]',
                '/project/{id_or_name}/hg'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectHg[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectHg[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateProjectBzr
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @param string $description  (optional)
     * @param bool $active  (optional)
     * @return \OSDN\Model\ProjectBzr
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectBzr($id_or_name, $repo_id, $description = null, $active = null)
    {
        list($response) = $this->updateProjectBzrWithHttpInfo($id_or_name, $repo_id, $description, $active);
        return $response;
    }

    /**
     * Operation updateProjectBzrWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @param string $description  (optional)
     * @param bool $active  (optional)
     * @return Array of \OSDN\Model\ProjectBzr, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectBzrWithHttpInfo($id_or_name, $repo_id, $description = null, $active = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateProjectBzr');
        }
        // verify the required parameter 'repo_id' is set
        if ($repo_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $repo_id when calling updateProjectBzr');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/bzr/{repo_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($repo_id !== null) {
            $resourcePath = str_replace(
                "{" . "repo_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($repo_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        // form params
        if ($active !== null) {
            $formParams['active'] = $this->apiClient->getSerializer()->toFormValue($active);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectBzr',
                '/project/{id_or_name}/bzr/{repo_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectBzr', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectBzr', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateProjectGit
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @param string $description  (optional)
     * @param bool $mail_enabled  (optional)
     * @param string $mail_recipients  (optional)
     * @param bool $allow_non_fast_forward  (optional)
     * @param string $default_branch  (optional)
     * @param bool $active  (optional)
     * @return \OSDN\Model\ProjectGit
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectGit($id_or_name, $repo_id, $description = null, $mail_enabled = null, $mail_recipients = null, $allow_non_fast_forward = null, $default_branch = null, $active = null)
    {
        list($response) = $this->updateProjectGitWithHttpInfo($id_or_name, $repo_id, $description, $mail_enabled, $mail_recipients, $allow_non_fast_forward, $default_branch, $active);
        return $response;
    }

    /**
     * Operation updateProjectGitWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @param string $description  (optional)
     * @param bool $mail_enabled  (optional)
     * @param string $mail_recipients  (optional)
     * @param bool $allow_non_fast_forward  (optional)
     * @param string $default_branch  (optional)
     * @param bool $active  (optional)
     * @return Array of \OSDN\Model\ProjectGit, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectGitWithHttpInfo($id_or_name, $repo_id, $description = null, $mail_enabled = null, $mail_recipients = null, $allow_non_fast_forward = null, $default_branch = null, $active = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateProjectGit');
        }
        // verify the required parameter 'repo_id' is set
        if ($repo_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $repo_id when calling updateProjectGit');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/git/{repo_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($repo_id !== null) {
            $resourcePath = str_replace(
                "{" . "repo_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($repo_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        // form params
        if ($mail_enabled !== null) {
            $formParams['mail_enabled'] = $this->apiClient->getSerializer()->toFormValue($mail_enabled);
        }
        // form params
        if ($mail_recipients !== null) {
            $formParams['mail_recipients'] = $this->apiClient->getSerializer()->toFormValue($mail_recipients);
        }
        // form params
        if ($allow_non_fast_forward !== null) {
            $formParams['allow_non_fast_forward'] = $this->apiClient->getSerializer()->toFormValue($allow_non_fast_forward);
        }
        // form params
        if ($default_branch !== null) {
            $formParams['default_branch'] = $this->apiClient->getSerializer()->toFormValue($default_branch);
        }
        // form params
        if ($active !== null) {
            $formParams['active'] = $this->apiClient->getSerializer()->toFormValue($active);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectGit',
                '/project/{id_or_name}/git/{repo_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectGit', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectGit', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateProjectHg
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @param string $description  (optional)
     * @param string $mail_recipients  (optional)
     * @param bool $active  (optional)
     * @return \OSDN\Model\ProjectHg
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectHg($id_or_name, $repo_id, $description = null, $mail_recipients = null, $active = null)
    {
        list($response) = $this->updateProjectHgWithHttpInfo($id_or_name, $repo_id, $description, $mail_recipients, $active);
        return $response;
    }

    /**
     * Operation updateProjectHgWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @param string $description  (optional)
     * @param string $mail_recipients  (optional)
     * @param bool $active  (optional)
     * @return Array of \OSDN\Model\ProjectHg, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectHgWithHttpInfo($id_or_name, $repo_id, $description = null, $mail_recipients = null, $active = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateProjectHg');
        }
        // verify the required parameter 'repo_id' is set
        if ($repo_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $repo_id when calling updateProjectHg');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/hg/{repo_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($repo_id !== null) {
            $resourcePath = str_replace(
                "{" . "repo_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($repo_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        // form params
        if ($mail_recipients !== null) {
            $formParams['mail_recipients'] = $this->apiClient->getSerializer()->toFormValue($mail_recipients);
        }
        // form params
        if ($active !== null) {
            $formParams['active'] = $this->apiClient->getSerializer()->toFormValue($active);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectHg',
                '/project/{id_or_name}/hg/{repo_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectHg', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectHg', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

}
