<?php
/**
 * UserApi
 * PHP version 5
 *
 * @category Class
 * @package  OSDN
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * OSDN REST API v0 beta
 *
 * OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.net/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.net/projects/osdn-codes/releases/p14859 .
 *
 * OpenAPI spec version: 0.0.20171120
 * Contact: admin@osdn.net
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace OSDN\Api;

use \OSDN\Configuration;
use \OSDN\ApiClient;
use \OSDN\ApiException;
use \OSDN\ObjectSerializer;

/**
 * UserApi Class Doc Comment
 *
 * @category Class
 * @package  OSDN
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class UserApi
{

    /**
     * API Client
     *
     * @var \OSDN\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \OSDN\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\OSDN\ApiClient $apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://osdn.net/api/v0');
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \OSDN\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \OSDN\ApiClient $apiClient set the API client
     *
     * @return UserApi
     */
    public function setApiClient(\OSDN\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation getUser
     *
     * 
     *
     * @param string $id_or_name numeric user id or user name (required)
     * @return \OSDN\Model\User
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getUser($id_or_name)
    {
        list($response) = $this->getUserWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation getUserWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric user id or user name (required)
     * @return Array of \OSDN\Model\User, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getUserWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getUser');
        }
        // parse inputs
        $resourcePath = "/user/{id_or_name}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\User',
                '/user/{id_or_name}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\User', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\User', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getUserHistory
     *
     * 
     *
     * @param string $id_or_name numeric user id or user name (required)
     * @return \OSDN\Model\History[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getUserHistory($id_or_name)
    {
        list($response) = $this->getUserHistoryWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation getUserHistoryWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric user id or user name (required)
     * @return Array of \OSDN\Model\History[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getUserHistoryWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getUserHistory');
        }
        // parse inputs
        $resourcePath = "/user/{id_or_name}/history";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\History[]',
                '/user/{id_or_name}/history'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\History[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\History[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getUserStatsDaily
     *
     * 
     *
     * @param string $id_or_name numeric user id or user name (required)
     * @return \OSDN\Model\UserStats[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getUserStatsDaily($id_or_name)
    {
        list($response) = $this->getUserStatsDailyWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation getUserStatsDailyWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric user id or user name (required)
     * @return Array of \OSDN\Model\UserStats[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getUserStatsDailyWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getUserStatsDaily');
        }
        // parse inputs
        $resourcePath = "/user/{id_or_name}/stats/daily";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\UserStats[]',
                '/user/{id_or_name}/stats/daily'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\UserStats[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\UserStats[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getUserStatsMonthly
     *
     * 
     *
     * @param string $id_or_name numeric user id or user name (required)
     * @return \OSDN\Model\UserStats[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getUserStatsMonthly($id_or_name)
    {
        list($response) = $this->getUserStatsMonthlyWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation getUserStatsMonthlyWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric user id or user name (required)
     * @return Array of \OSDN\Model\UserStats[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getUserStatsMonthlyWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getUserStatsMonthly');
        }
        // parse inputs
        $resourcePath = "/user/{id_or_name}/stats/monthly";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\UserStats[]',
                '/user/{id_or_name}/stats/monthly'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\UserStats[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\UserStats[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateUserIcon
     *
     * 
     *
     * @param string $id_or_name numeric user id or user name (required)
     * @param \SplFileObject $image The image data to update, you need to send with multipart/form-data. (required)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateUserIcon($id_or_name, $image)
    {
        list($response) = $this->updateUserIconWithHttpInfo($id_or_name, $image);
        return $response;
    }

    /**
     * Operation updateUserIconWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric user id or user name (required)
     * @param \SplFileObject $image The image data to update, you need to send with multipart/form-data. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateUserIconWithHttpInfo($id_or_name, $image)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateUserIcon');
        }
        // verify the required parameter 'image' is set
        if ($image === null) {
            throw new \InvalidArgumentException('Missing the required parameter $image when calling updateUserIcon');
        }
        // parse inputs
        $resourcePath = "/user/{id_or_name}/icon";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('multipart/form-data'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($image !== null) {
            // PHP 5.5 introduced a CurlFile object that deprecates the old @filename syntax
            // See: https://wiki.php.net/rfc/curl-file-upload
            if (function_exists('curl_file_create')) {
                $formParams['image'] = curl_file_create($this->apiClient->getSerializer()->toFormValue($image));
            } else {
                $formParams['image'] = '@' . $this->apiClient->getSerializer()->toFormValue($image);
            }
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/user/{id_or_name}/icon'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

    /**
     * Operation updateUserPhoto
     *
     * 
     *
     * @param string $id_or_name numeric user id or user name (required)
     * @param \SplFileObject $image The image data to update, you need to send with multipart/form-data. (required)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateUserPhoto($id_or_name, $image)
    {
        list($response) = $this->updateUserPhotoWithHttpInfo($id_or_name, $image);
        return $response;
    }

    /**
     * Operation updateUserPhotoWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric user id or user name (required)
     * @param \SplFileObject $image The image data to update, you need to send with multipart/form-data. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateUserPhotoWithHttpInfo($id_or_name, $image)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateUserPhoto');
        }
        // verify the required parameter 'image' is set
        if ($image === null) {
            throw new \InvalidArgumentException('Missing the required parameter $image when calling updateUserPhoto');
        }
        // parse inputs
        $resourcePath = "/user/{id_or_name}/photo";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('multipart/form-data'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($image !== null) {
            // PHP 5.5 introduced a CurlFile object that deprecates the old @filename syntax
            // See: https://wiki.php.net/rfc/curl-file-upload
            if (function_exists('curl_file_create')) {
                $formParams['image'] = curl_file_create($this->apiClient->getSerializer()->toFormValue($image));
            } else {
                $formParams['image'] = '@' . $this->apiClient->getSerializer()->toFormValue($image);
            }
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/user/{id_or_name}/photo'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

}
