# OSDN\ProjectTicketApi

All URIs are relative to *https://osdn.net/api/v0*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createProjectTicket**](ProjectTicketApi.md#createProjectTicket) | **POST** /project/{id_or_name}/ticket | 
[**createProjectTicketComment**](ProjectTicketApi.md#createProjectTicketComment) | **POST** /project/{id_or_name}/ticket/{ticket_id}/comment | 
[**createProjectTicketComponent**](ProjectTicketApi.md#createProjectTicketComponent) | **POST** /project/{id_or_name}/ticket/component | 
[**createProjectTicketMilestone**](ProjectTicketApi.md#createProjectTicketMilestone) | **POST** /project/{id_or_name}/ticket/milestone | 
[**createProjectTicketType**](ProjectTicketApi.md#createProjectTicketType) | **POST** /project/{id_or_name}/ticket/type | 
[**createProjectTicketTypeInstruction**](ProjectTicketApi.md#createProjectTicketTypeInstruction) | **POST** /project/{id_or_name}/ticket/type/{type_id}/instruction | 
[**deleteProjectTicketComponent**](ProjectTicketApi.md#deleteProjectTicketComponent) | **DELETE** /project/{id_or_name}/ticket/component/{component_id} | 
[**deleteProjectTicketMilestone**](ProjectTicketApi.md#deleteProjectTicketMilestone) | **DELETE** /project/{id_or_name}/ticket/milestone/{milestone_id} | 
[**deleteProjectTicketType**](ProjectTicketApi.md#deleteProjectTicketType) | **DELETE** /project/{id_or_name}/ticket/type/{type_id} | 
[**deleteProjectTicketTypeInstruction**](ProjectTicketApi.md#deleteProjectTicketTypeInstruction) | **DELETE** /project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code} | 
[**getProjectTicket**](ProjectTicketApi.md#getProjectTicket) | **GET** /project/{id_or_name}/ticket/{ticket_id} | 
[**getProjectTicketComponent**](ProjectTicketApi.md#getProjectTicketComponent) | **GET** /project/{id_or_name}/ticket/component/{component_id} | 
[**getProjectTicketMilestone**](ProjectTicketApi.md#getProjectTicketMilestone) | **GET** /project/{id_or_name}/ticket/milestone/{milestone_id} | 
[**getProjectTicketType**](ProjectTicketApi.md#getProjectTicketType) | **GET** /project/{id_or_name}/ticket/type/{type_id} | 
[**getProjectTicketTypeInstruction**](ProjectTicketApi.md#getProjectTicketTypeInstruction) | **GET** /project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code} | 
[**getProjectTicketTypeInstruction_0**](ProjectTicketApi.md#getProjectTicketTypeInstruction_0) | **PATCH** /project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code} | 
[**listProjectTicket**](ProjectTicketApi.md#listProjectTicket) | **GET** /project/{id_or_name}/ticket | 
[**listProjectTicketComment**](ProjectTicketApi.md#listProjectTicketComment) | **GET** /project/{id_or_name}/ticket/{ticket_id}/comment | 
[**listProjectTicketComponent**](ProjectTicketApi.md#listProjectTicketComponent) | **GET** /project/{id_or_name}/ticket/component | 
[**listProjectTicketMilestone**](ProjectTicketApi.md#listProjectTicketMilestone) | **GET** /project/{id_or_name}/ticket/milestone | 
[**listProjectTicketType**](ProjectTicketApi.md#listProjectTicketType) | **GET** /project/{id_or_name}/ticket/type | 
[**listProjectTicketTypeInstruction**](ProjectTicketApi.md#listProjectTicketTypeInstruction) | **GET** /project/{id_or_name}/ticket/type/{type_id}/instruction | 
[**showProjectTicketAdminprefs**](ProjectTicketApi.md#showProjectTicketAdminprefs) | **GET** /project/{id_or_name}/ticket/admin | 
[**showProjectTicketComment**](ProjectTicketApi.md#showProjectTicketComment) | **GET** /project/{id_or_name}/ticket/{ticket_id}/comment/{comment_id} | 
[**updateProjectTicket**](ProjectTicketApi.md#updateProjectTicket) | **PATCH** /project/{id_or_name}/ticket/{ticket_id} | 
[**updateProjectTicketAdminprefs**](ProjectTicketApi.md#updateProjectTicketAdminprefs) | **PATCH** /project/{id_or_name}/ticket/admin | 
[**updateProjectTicketComponent**](ProjectTicketApi.md#updateProjectTicketComponent) | **PATCH** /project/{id_or_name}/ticket/component/{component_id} | 
[**updateProjectTicketMilestone**](ProjectTicketApi.md#updateProjectTicketMilestone) | **PATCH** /project/{id_or_name}/ticket/milestone/{milestone_id} | 
[**updateProjectTicketType**](ProjectTicketApi.md#updateProjectTicketType) | **PATCH** /project/{id_or_name}/ticket/type/{type_id} | 


# **createProjectTicket**
> \OSDN\Model\ProjectTicketItem createProjectTicket($id_or_name, $name, $description, $type_id, $milestone_id, $component_id, $priority, $severity, $owner)



Create project ticket

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$name = "name_example"; // string | Project ticket name (title)
$description = "description_example"; // string | Project ticket description details
$type_id = 56; // int | numeric project ticket type id
$milestone_id = 56; // int | numeric project ticket milestone id
$component_id = 56; // int | numeric project ticket component id
$priority = 56; // int | project ticket priority (min = 1 and max = 9)
$severity = 56; // int | project ticket severity (min = 1 and max = 9)
$owner = 56; // int | numeric project ticket owner user id

try {
    $result = $api_instance->createProjectTicket($id_or_name, $name, $description, $type_id, $milestone_id, $component_id, $priority, $severity, $owner);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->createProjectTicket: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **name** | **string**| Project ticket name (title) |
 **description** | **string**| Project ticket description details |
 **type_id** | **int**| numeric project ticket type id |
 **milestone_id** | **int**| numeric project ticket milestone id | [optional]
 **component_id** | **int**| numeric project ticket component id | [optional]
 **priority** | **int**| project ticket priority (min &#x3D; 1 and max &#x3D; 9) | [optional]
 **severity** | **int**| project ticket severity (min &#x3D; 1 and max &#x3D; 9) | [optional]
 **owner** | **int**| numeric project ticket owner user id | [optional]

### Return type

[**\OSDN\Model\ProjectTicketItem**](../Model/ProjectTicketItem.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createProjectTicketComment**
> \OSDN\Model\ProjectTicketComment createProjectTicketComment($id_or_name, $ticket_id, $comment)



Create new project ticket comment of spscified project.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$ticket_id = 56; // int | numeric project ticket id
$comment = "comment_example"; // string | Ticket comment text

try {
    $result = $api_instance->createProjectTicketComment($id_or_name, $ticket_id, $comment);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->createProjectTicketComment: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **ticket_id** | **int**| numeric project ticket id |
 **comment** | **string**| Ticket comment text |

### Return type

[**\OSDN\Model\ProjectTicketComment**](../Model/ProjectTicketComment.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createProjectTicketComponent**
> \OSDN\Model\ProjectTicketComponent[] createProjectTicketComponent($id_or_name, $name, $description, $owner, $active)



Create new project ticket component of spscified project.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$name = "name_example"; // string | Ticket component name
$description = "description_example"; // string | Ticket component description
$owner = 56; // int | Ticket componet owner user_id
$active = true; // bool | Ticket componet will be shown the component select list when this parameter is true

try {
    $result = $api_instance->createProjectTicketComponent($id_or_name, $name, $description, $owner, $active);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->createProjectTicketComponent: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **name** | **string**| Ticket component name |
 **description** | **string**| Ticket component description |
 **owner** | **int**| Ticket componet owner user_id | [optional]
 **active** | **bool**| Ticket componet will be shown the component select list when this parameter is true | [optional]

### Return type

[**\OSDN\Model\ProjectTicketComponent[]**](../Model/ProjectTicketComponent.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createProjectTicketMilestone**
> \OSDN\Model\ProjectTicketMilestone createProjectTicketMilestone($id_or_name, $name, $description, $start, $end)



Create new project ticket milestone of spscified project.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$name = "name_example"; // string | Ticket milestone name
$description = "description_example"; // string | Ticket milestone description
$start = new \DateTime(); // \DateTime | Ticket milestone start date
$end = new \DateTime(); // \DateTime | Ticket milestone due date

try {
    $result = $api_instance->createProjectTicketMilestone($id_or_name, $name, $description, $start, $end);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->createProjectTicketMilestone: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **name** | **string**| Ticket milestone name |
 **description** | **string**| Ticket milestone description |
 **start** | **\DateTime**| Ticket milestone start date | [optional]
 **end** | **\DateTime**| Ticket milestone due date | [optional]

### Return type

[**\OSDN\Model\ProjectTicketMilestone**](../Model/ProjectTicketMilestone.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createProjectTicketType**
> \OSDN\Model\ProjectTicketType createProjectTicketType($id_or_name, $name, $description, $is_public)



Create new project ticket type of spscified project.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$name = "name_example"; // string | Ticket type name
$description = "description_example"; // string | Ticket type description
$is_public = true; // bool | if set as false, this type will be shown to project members only.

try {
    $result = $api_instance->createProjectTicketType($id_or_name, $name, $description, $is_public);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->createProjectTicketType: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **name** | **string**| Ticket type name |
 **description** | **string**| Ticket type description |
 **is_public** | **bool**| if set as false, this type will be shown to project members only. | [optional]

### Return type

[**\OSDN\Model\ProjectTicketType**](../Model/ProjectTicketType.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createProjectTicketTypeInstruction**
> \OSDN\Model\ProjectTicketTypeInstructionPerLanguage createProjectTicketTypeInstruction($id_or_name, $type_id, $language_code, $instruction)



Create project ticket type instructions for the language

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$type_id = 56; // int | numeric project ticket type id
$language_code = "language_code_example"; // string | Language code for display name and description (example en, ja, zh-TW)
$instruction = "instruction_example"; // string | Ticket submit instruction for the type

try {
    $result = $api_instance->createProjectTicketTypeInstruction($id_or_name, $type_id, $language_code, $instruction);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->createProjectTicketTypeInstruction: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **type_id** | **int**| numeric project ticket type id |
 **language_code** | **string**| Language code for display name and description (example en, ja, zh-TW) |
 **instruction** | **string**| Ticket submit instruction for the type |

### Return type

[**\OSDN\Model\ProjectTicketTypeInstructionPerLanguage**](../Model/ProjectTicketTypeInstructionPerLanguage.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProjectTicketComponent**
> deleteProjectTicketComponent($id_or_name, $component_id, $migrate_to)



Delete project ticket component

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$component_id = 56; // int | numeric project ticket component id
$migrate_to = 56; // int | Tickets that assigned to delete target will be migrate to the ticket component_id

try {
    $api_instance->deleteProjectTicketComponent($id_or_name, $component_id, $migrate_to);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->deleteProjectTicketComponent: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **component_id** | **int**| numeric project ticket component id |
 **migrate_to** | **int**| Tickets that assigned to delete target will be migrate to the ticket component_id |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProjectTicketMilestone**
> deleteProjectTicketMilestone($id_or_name, $milestone_id, $migrate_to)



Delete project ticket milestone

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$milestone_id = 56; // int | numeric project ticket milestone id
$migrate_to = 56; // int | Tickets that assigned to delete target will be migrate to the ticket milestone_id

try {
    $api_instance->deleteProjectTicketMilestone($id_or_name, $milestone_id, $migrate_to);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->deleteProjectTicketMilestone: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **milestone_id** | **int**| numeric project ticket milestone id |
 **migrate_to** | **int**| Tickets that assigned to delete target will be migrate to the ticket milestone_id | [optional]

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProjectTicketType**
> deleteProjectTicketType($id_or_name, $type_id, $migrate_to)



Delete project ticket type

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$type_id = 56; // int | numeric project ticket type id
$migrate_to = 56; // int | Tickets that assigned to delete target will be migrate to the ticket type_id

try {
    $api_instance->deleteProjectTicketType($id_or_name, $type_id, $migrate_to);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->deleteProjectTicketType: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **type_id** | **int**| numeric project ticket type id |
 **migrate_to** | **int**| Tickets that assigned to delete target will be migrate to the ticket type_id |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProjectTicketTypeInstruction**
> deleteProjectTicketTypeInstruction($id_or_name, $type_id, $language_code)



Delete project ticket type instructions on the language

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$type_id = 56; // int | numeric project ticket type id
$language_code = "language_code_example"; // string | Language code for display name and description (example en, ja, zh-TW)

try {
    $api_instance->deleteProjectTicketTypeInstruction($id_or_name, $type_id, $language_code);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->deleteProjectTicketTypeInstruction: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **type_id** | **int**| numeric project ticket type id |
 **language_code** | **string**| Language code for display name and description (example en, ja, zh-TW) |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectTicket**
> \OSDN\Model\ProjectTicketItem getProjectTicket($id_or_name, $ticket_id)



Get project ticket

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$ticket_id = 56; // int | numeric project ticket id

try {
    $result = $api_instance->getProjectTicket($id_or_name, $ticket_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->getProjectTicket: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **ticket_id** | **int**| numeric project ticket id |

### Return type

[**\OSDN\Model\ProjectTicketItem**](../Model/ProjectTicketItem.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectTicketComponent**
> \OSDN\Model\ProjectTicketComponent getProjectTicketComponent($id_or_name, $component_id)



Get project ticket component

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$component_id = 56; // int | numeric project ticket component id

try {
    $result = $api_instance->getProjectTicketComponent($id_or_name, $component_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->getProjectTicketComponent: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **component_id** | **int**| numeric project ticket component id |

### Return type

[**\OSDN\Model\ProjectTicketComponent**](../Model/ProjectTicketComponent.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectTicketMilestone**
> \OSDN\Model\ProjectTicketMilestone getProjectTicketMilestone($id_or_name, $milestone_id)



Get project ticket milestone of spscified milestone_id.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$milestone_id = 56; // int | numeric project ticket milestone id

try {
    $result = $api_instance->getProjectTicketMilestone($id_or_name, $milestone_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->getProjectTicketMilestone: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **milestone_id** | **int**| numeric project ticket milestone id |

### Return type

[**\OSDN\Model\ProjectTicketMilestone**](../Model/ProjectTicketMilestone.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectTicketType**
> \OSDN\Model\ProjectTicketType getProjectTicketType($id_or_name, $type_id)



Get project ticket type

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$type_id = 56; // int | numeric project ticket type id

try {
    $result = $api_instance->getProjectTicketType($id_or_name, $type_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->getProjectTicketType: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **type_id** | **int**| numeric project ticket type id |

### Return type

[**\OSDN\Model\ProjectTicketType**](../Model/ProjectTicketType.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectTicketTypeInstruction**
> \OSDN\Model\ProjectTicketTypeInstructionPerLanguage getProjectTicketTypeInstruction($id_or_name, $type_id, $language_code)



Get project ticket type instructions on the language

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$type_id = 56; // int | numeric project ticket type id
$language_code = "language_code_example"; // string | Language code for display name and description (example en, ja, zh-TW)

try {
    $result = $api_instance->getProjectTicketTypeInstruction($id_or_name, $type_id, $language_code);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->getProjectTicketTypeInstruction: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **type_id** | **int**| numeric project ticket type id |
 **language_code** | **string**| Language code for display name and description (example en, ja, zh-TW) |

### Return type

[**\OSDN\Model\ProjectTicketTypeInstructionPerLanguage**](../Model/ProjectTicketTypeInstructionPerLanguage.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectTicketTypeInstruction_0**
> \OSDN\Model\ProjectTicketTypeInstructionPerLanguage getProjectTicketTypeInstruction_0($id_or_name, $type_id, $language_code, $instruction)



Update project ticket type instructions on the language

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$type_id = 56; // int | numeric project ticket type id
$language_code = "language_code_example"; // string | Language code for display name and description (example en, ja, zh-TW)
$instruction = "instruction_example"; // string | Ticket submit instruction for the type

try {
    $result = $api_instance->getProjectTicketTypeInstruction_0($id_or_name, $type_id, $language_code, $instruction);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->getProjectTicketTypeInstruction_0: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **type_id** | **int**| numeric project ticket type id |
 **language_code** | **string**| Language code for display name and description (example en, ja, zh-TW) |
 **instruction** | **string**| Ticket submit instruction for the type |

### Return type

[**\OSDN\Model\ProjectTicketTypeInstructionPerLanguage**](../Model/ProjectTicketTypeInstructionPerLanguage.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listProjectTicket**
> \OSDN\Model\ProjectTicketItem[] listProjectTicket($id_or_name, $status, $type_id, $not_type_id, $component_id, $not_component_id, $milestone_id, $not_milestone_id, $max_priority, $min_priority, $priority, $max_severity, $min_severity, $severity, $owner, $not_owner, $reporter, $not_reporter, $text)



List project ticket order by submit date descending

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$status = array("status_example"); // string[] | Tickets are assigned to these type_ids
$type_id = array(56); // int[] | Listing tickets are assigned to these type_ids
$not_type_id = array(56); // int[] | Listing tickets are NOT assigned to these type_ids
$component_id = array(56); // int[] | Listing tickets are assigned to these component_ids (If you want to indicate component is not assigned, please use component_id = 0)
$not_component_id = array(56); // int[] | Listing tickets are NOT assigned to these component_ids (If you want to indicate component is not assigned, please use component_id = 0)
$milestone_id = array(56); // int[] | Listing tickets are assigned to these milestone_ids (If you want to indicate milestone is not assigned, please use milestone_id = 0)
$not_milestone_id = array(56); // int[] | Listing tickets are NOT assigned to these milestone_ids (milestone_id = 0 means milestone not assigned)
$max_priority = 56; // int | Listing equal or lower priority tickets
$min_priority = 56; // int | Listing equal or higher priority tickets
$priority = 56; // int | Listing tickets have this priority
$max_severity = 56; // int | Listing equal or lower severity tickets
$min_severity = 56; // int | Listing equal or higher severity tickets
$severity = 56; // int | Listing tickets have this severity
$owner = array(56); // int[] | Listing tickets assigned to these owners (owner = 100 means owner is not assigned)
$not_owner = array(56); // int[] | Listing tickets NOT assigned to these owners (owner = 100 means owner is not assigned)
$reporter = array(56); // int[] | Listing tickets reported by these users (report = 100 means reported by non login user)
$not_reporter = array(56); // int[] | Listing tickets reported by these users (report = 100 means reported by non login user)
$text = "text_example"; // string | Listing tickets title or description or comment include the text

try {
    $result = $api_instance->listProjectTicket($id_or_name, $status, $type_id, $not_type_id, $component_id, $not_component_id, $milestone_id, $not_milestone_id, $max_priority, $min_priority, $priority, $max_severity, $min_severity, $severity, $owner, $not_owner, $reporter, $not_reporter, $text);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->listProjectTicket: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **status** | [**string[]**](../Model/string.md)| Tickets are assigned to these type_ids | [optional]
 **type_id** | [**int[]**](../Model/int.md)| Listing tickets are assigned to these type_ids | [optional]
 **not_type_id** | [**int[]**](../Model/int.md)| Listing tickets are NOT assigned to these type_ids | [optional]
 **component_id** | [**int[]**](../Model/int.md)| Listing tickets are assigned to these component_ids (If you want to indicate component is not assigned, please use component_id &#x3D; 0) | [optional]
 **not_component_id** | [**int[]**](../Model/int.md)| Listing tickets are NOT assigned to these component_ids (If you want to indicate component is not assigned, please use component_id &#x3D; 0) | [optional]
 **milestone_id** | [**int[]**](../Model/int.md)| Listing tickets are assigned to these milestone_ids (If you want to indicate milestone is not assigned, please use milestone_id &#x3D; 0) | [optional]
 **not_milestone_id** | [**int[]**](../Model/int.md)| Listing tickets are NOT assigned to these milestone_ids (milestone_id &#x3D; 0 means milestone not assigned) | [optional]
 **max_priority** | **int**| Listing equal or lower priority tickets | [optional]
 **min_priority** | **int**| Listing equal or higher priority tickets | [optional]
 **priority** | **int**| Listing tickets have this priority | [optional]
 **max_severity** | **int**| Listing equal or lower severity tickets | [optional]
 **min_severity** | **int**| Listing equal or higher severity tickets | [optional]
 **severity** | **int**| Listing tickets have this severity | [optional]
 **owner** | [**int[]**](../Model/int.md)| Listing tickets assigned to these owners (owner &#x3D; 100 means owner is not assigned) | [optional]
 **not_owner** | [**int[]**](../Model/int.md)| Listing tickets NOT assigned to these owners (owner &#x3D; 100 means owner is not assigned) | [optional]
 **reporter** | [**int[]**](../Model/int.md)| Listing tickets reported by these users (report &#x3D; 100 means reported by non login user) | [optional]
 **not_reporter** | [**int[]**](../Model/int.md)| Listing tickets reported by these users (report &#x3D; 100 means reported by non login user) | [optional]
 **text** | **string**| Listing tickets title or description or comment include the text | [optional]

### Return type

[**\OSDN\Model\ProjectTicketItem[]**](../Model/ProjectTicketItem.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listProjectTicketComment**
> \OSDN\Model\ProjectTicketComment[] listProjectTicketComment($id_or_name, $ticket_id)



Get project ticket comment list of spscified project.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$ticket_id = 56; // int | numeric project ticket id

try {
    $result = $api_instance->listProjectTicketComment($id_or_name, $ticket_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->listProjectTicketComment: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **ticket_id** | **int**| numeric project ticket id |

### Return type

[**\OSDN\Model\ProjectTicketComment[]**](../Model/ProjectTicketComment.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listProjectTicketComponent**
> \OSDN\Model\ProjectTicketComponent[] listProjectTicketComponent($id_or_name)



Get project ticket component list of spscified project.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->listProjectTicketComponent($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->listProjectTicketComponent: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\ProjectTicketComponent[]**](../Model/ProjectTicketComponent.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listProjectTicketMilestone**
> \OSDN\Model\ProjectTicketMilestone[] listProjectTicketMilestone($id_or_name)



Get project ticket milestone list of spscified project.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->listProjectTicketMilestone($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->listProjectTicketMilestone: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\ProjectTicketMilestone[]**](../Model/ProjectTicketMilestone.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listProjectTicketType**
> \OSDN\Model\ProjectTicketType[] listProjectTicketType($id_or_name)



Get project ticket type list of spscified project.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->listProjectTicketType($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->listProjectTicketType: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\ProjectTicketType[]**](../Model/ProjectTicketType.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listProjectTicketTypeInstruction**
> \OSDN\Model\ProjectTicketTypeInstructions listProjectTicketTypeInstruction($id_or_name, $type_id)



Get project ticket type instructions

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$type_id = 56; // int | numeric project ticket type id

try {
    $result = $api_instance->listProjectTicketTypeInstruction($id_or_name, $type_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->listProjectTicketTypeInstruction: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **type_id** | **int**| numeric project ticket type id |

### Return type

[**\OSDN\Model\ProjectTicketTypeInstructions**](../Model/ProjectTicketTypeInstructions.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **showProjectTicketAdminprefs**
> \OSDN\Model\ProjectTicketPrefs showProjectTicketAdminprefs($id_or_name)



Get project ticket admin preferences.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->showProjectTicketAdminprefs($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->showProjectTicketAdminprefs: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\ProjectTicketPrefs**](../Model/ProjectTicketPrefs.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **showProjectTicketComment**
> \OSDN\Model\ProjectTicketComment showProjectTicketComment($id_or_name, $ticket_id, $comment_id)



Get project ticket comment spscified project.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$ticket_id = 56; // int | numeric project ticket id
$comment_id = 56; // int | numeric project ticket comment id

try {
    $result = $api_instance->showProjectTicketComment($id_or_name, $ticket_id, $comment_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->showProjectTicketComment: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **ticket_id** | **int**| numeric project ticket id |
 **comment_id** | **int**| numeric project ticket comment id |

### Return type

[**\OSDN\Model\ProjectTicketComment**](../Model/ProjectTicketComment.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProjectTicket**
> \OSDN\Model\ProjectTicketItem updateProjectTicket($id_or_name, $ticket_id, $name, $description, $type_id, $milestone_id, $component_id, $priority, $severity, $owner, $resolution, $status)



Update project ticket

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$ticket_id = 56; // int | numeric project ticket id
$name = "name_example"; // string | Project ticket name (title)
$description = "description_example"; // string | Project ticket description details
$type_id = 56; // int | numeric project ticket type id
$milestone_id = 56; // int | numeric project ticket milestone id
$component_id = 56; // int | numeric project ticket component id
$priority = 56; // int | project ticket priority (min = 1 and max = 9)
$severity = 56; // int | project ticket severity (min = 1 and max = 9)
$owner = 56; // int | numeric project ticket owner user id
$resolution = "resolution_example"; // string | project ticket resolution text
$status = "status_example"; // string | project ticket status (open or close)

try {
    $result = $api_instance->updateProjectTicket($id_or_name, $ticket_id, $name, $description, $type_id, $milestone_id, $component_id, $priority, $severity, $owner, $resolution, $status);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->updateProjectTicket: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **ticket_id** | **int**| numeric project ticket id |
 **name** | **string**| Project ticket name (title) | [optional]
 **description** | **string**| Project ticket description details | [optional]
 **type_id** | **int**| numeric project ticket type id | [optional]
 **milestone_id** | **int**| numeric project ticket milestone id | [optional]
 **component_id** | **int**| numeric project ticket component id | [optional]
 **priority** | **int**| project ticket priority (min &#x3D; 1 and max &#x3D; 9) | [optional]
 **severity** | **int**| project ticket severity (min &#x3D; 1 and max &#x3D; 9) | [optional]
 **owner** | **int**| numeric project ticket owner user id | [optional]
 **resolution** | **string**| project ticket resolution text | [optional]
 **status** | **string**| project ticket status (open or close) | [optional]

### Return type

[**\OSDN\Model\ProjectTicketItem**](../Model/ProjectTicketItem.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProjectTicketAdminprefs**
> \OSDN\Model\ProjectTicketPrefs updateProjectTicketAdminprefs($id_or_name, $allow_anonymouse, $frs_autosync, $mailsend_type, $mailing_list_id, $mail_lang)



Update project ticket admin preferences.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$allow_anonymouse = true; // bool | Non login user allows to post new ticket/comment
$frs_autosync = "frs_autosync_example"; // string | Componet File release autosync type 'Disabled', 'Package', 'Release', 'Package and Release'
$mailsend_type = "mailsend_type_example"; // string | Ticket update mail destination type 'None', 'Ticket Technician', 'Ticket Administrator', 'Ticket Administrator and Technician', 'All project members', 'Mailing List'
$mailing_list_id = 56; // int | Ticket update mail destination mail list id (it is only used when mailsend_type is mailing list)
$mail_lang = "mail_lang_example"; // string | Ticket update mail language

try {
    $result = $api_instance->updateProjectTicketAdminprefs($id_or_name, $allow_anonymouse, $frs_autosync, $mailsend_type, $mailing_list_id, $mail_lang);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->updateProjectTicketAdminprefs: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **allow_anonymouse** | **bool**| Non login user allows to post new ticket/comment | [optional]
 **frs_autosync** | **string**| Componet File release autosync type &#39;Disabled&#39;, &#39;Package&#39;, &#39;Release&#39;, &#39;Package and Release&#39; | [optional]
 **mailsend_type** | **string**| Ticket update mail destination type &#39;None&#39;, &#39;Ticket Technician&#39;, &#39;Ticket Administrator&#39;, &#39;Ticket Administrator and Technician&#39;, &#39;All project members&#39;, &#39;Mailing List&#39; | [optional]
 **mailing_list_id** | **int**| Ticket update mail destination mail list id (it is only used when mailsend_type is mailing list) | [optional]
 **mail_lang** | **string**| Ticket update mail language | [optional]

### Return type

[**\OSDN\Model\ProjectTicketPrefs**](../Model/ProjectTicketPrefs.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProjectTicketComponent**
> \OSDN\Model\ProjectTicketComponent updateProjectTicketComponent($id_or_name, $component_id, $name, $description, $owner, $active)



Update project ticket component

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$component_id = 56; // int | numeric project ticket component id
$name = "name_example"; // string | Ticket component name
$description = "description_example"; // string | Ticket component description
$owner = 56; // int | Ticket componet owner user_id
$active = true; // bool | Ticket componet will be shown the component select list when this parameter is true

try {
    $result = $api_instance->updateProjectTicketComponent($id_or_name, $component_id, $name, $description, $owner, $active);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->updateProjectTicketComponent: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **component_id** | **int**| numeric project ticket component id |
 **name** | **string**| Ticket component name | [optional]
 **description** | **string**| Ticket component description | [optional]
 **owner** | **int**| Ticket componet owner user_id | [optional]
 **active** | **bool**| Ticket componet will be shown the component select list when this parameter is true | [optional]

### Return type

[**\OSDN\Model\ProjectTicketComponent**](../Model/ProjectTicketComponent.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProjectTicketMilestone**
> \OSDN\Model\ProjectTicketComponent updateProjectTicketMilestone($id_or_name, $milestone_id, $name, $description, $start, $end, $force_status)



Update project ticket milestone

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$milestone_id = 56; // int | numeric project ticket milestone id
$name = "name_example"; // string | Ticket milestone name
$description = "description_example"; // string | Ticket milestone description
$start = new \DateTime(); // \DateTime | Ticket milestone start date
$end = new \DateTime(); // \DateTime | Ticket milestone due date
$force_status = "force_status_example"; // string | If you want to force close the milestone set to 'close' or reopen it set to 'reopen'

try {
    $result = $api_instance->updateProjectTicketMilestone($id_or_name, $milestone_id, $name, $description, $start, $end, $force_status);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->updateProjectTicketMilestone: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **milestone_id** | **int**| numeric project ticket milestone id |
 **name** | **string**| Ticket milestone name | [optional]
 **description** | **string**| Ticket milestone description | [optional]
 **start** | **\DateTime**| Ticket milestone start date | [optional]
 **end** | **\DateTime**| Ticket milestone due date | [optional]
 **force_status** | **string**| If you want to force close the milestone set to &#39;close&#39; or reopen it set to &#39;reopen&#39; | [optional]

### Return type

[**\OSDN\Model\ProjectTicketComponent**](../Model/ProjectTicketComponent.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProjectTicketType**
> \OSDN\Model\ProjectTicketType updateProjectTicketType($id_or_name, $type_id, $name, $description, $is_public)



Update project ticket type

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectTicketApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$type_id = 56; // int | numeric project ticket type id
$name = "name_example"; // string | Ticket type name
$description = "description_example"; // string | Ticket type description
$is_public = true; // bool | if set as false, this type will be shown to project members only.

try {
    $result = $api_instance->updateProjectTicketType($id_or_name, $type_id, $name, $description, $is_public);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectTicketApi->updateProjectTicketType: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **type_id** | **int**| numeric project ticket type id |
 **name** | **string**| Ticket type name | [optional]
 **description** | **string**| Ticket type description | [optional]
 **is_public** | **bool**| if set as false, this type will be shown to project members only. | [optional]

### Return type

[**\OSDN\Model\ProjectTicketType**](../Model/ProjectTicketType.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

