# OSDN\UserApi

All URIs are relative to *https://osdn.net/api/v0*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getUser**](UserApi.md#getUser) | **GET** /user/{id_or_name} | 
[**getUserHistory**](UserApi.md#getUserHistory) | **GET** /user/{id_or_name}/history | 
[**getUserStatsDaily**](UserApi.md#getUserStatsDaily) | **GET** /user/{id_or_name}/stats/daily | 
[**getUserStatsMonthly**](UserApi.md#getUserStatsMonthly) | **GET** /user/{id_or_name}/stats/monthly | 
[**updateUserIcon**](UserApi.md#updateUserIcon) | **POST** /user/{id_or_name}/icon | 
[**updateUserPhoto**](UserApi.md#updateUserPhoto) | **POST** /user/{id_or_name}/photo | 


# **getUser**
> \OSDN\Model\User getUser($id_or_name)



Get user profile.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\UserApi();
$id_or_name = "id_or_name_example"; // string | numeric user id or user name

try {
    $result = $api_instance->getUser($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UserApi->getUser: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric user id or user name |

### Return type

[**\OSDN\Model\User**](../Model/User.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUserHistory**
> \OSDN\Model\History[] getUserHistory($id_or_name)



get user monthly stats.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\UserApi();
$id_or_name = "id_or_name_example"; // string | numeric user id or user name

try {
    $result = $api_instance->getUserHistory($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UserApi->getUserHistory: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric user id or user name |

### Return type

[**\OSDN\Model\History[]**](../Model/History.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUserStatsDaily**
> \OSDN\Model\UserStats[] getUserStatsDaily($id_or_name)



get user daily stats.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\UserApi();
$id_or_name = "id_or_name_example"; // string | numeric user id or user name

try {
    $result = $api_instance->getUserStatsDaily($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UserApi->getUserStatsDaily: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric user id or user name |

### Return type

[**\OSDN\Model\UserStats[]**](../Model/UserStats.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUserStatsMonthly**
> \OSDN\Model\UserStats[] getUserStatsMonthly($id_or_name)



get user monthly stats.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\UserApi();
$id_or_name = "id_or_name_example"; // string | numeric user id or user name

try {
    $result = $api_instance->getUserStatsMonthly($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UserApi->getUserStatsMonthly: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric user id or user name |

### Return type

[**\OSDN\Model\UserStats[]**](../Model/UserStats.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateUserIcon**
> updateUserIcon($id_or_name, $image)



Update user icon, the image will be resized to 12x12 automatically.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\UserApi();
$id_or_name = "id_or_name_example"; // string | numeric user id or user name
$image = "/path/to/file.txt"; // \SplFileObject | The image data to update, you need to send with multipart/form-data.

try {
    $api_instance->updateUserIcon($id_or_name, $image);
} catch (Exception $e) {
    echo 'Exception when calling UserApi->updateUserIcon: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric user id or user name |
 **image** | **\SplFileObject**| The image data to update, you need to send with multipart/form-data. |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: multipart/form-data
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateUserPhoto**
> updateUserPhoto($id_or_name, $image)



Update user profile photo.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\UserApi();
$id_or_name = "id_or_name_example"; // string | numeric user id or user name
$image = "/path/to/file.txt"; // \SplFileObject | The image data to update, you need to send with multipart/form-data.

try {
    $api_instance->updateUserPhoto($id_or_name, $image);
} catch (Exception $e) {
    echo 'Exception when calling UserApi->updateUserPhoto: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric user id or user name |
 **image** | **\SplFileObject**| The image data to update, you need to send with multipart/form-data. |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: multipart/form-data
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

