/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.miya.pglauncher.actions;

import jp.gr.java_conf.miya.pglauncher.actions.AbstractAction;
import jp.gr.java_conf.miya.pglauncher.actions.ActionEventProvider;
import jp.gr.java_conf.miya.pglauncher.dialogs.ProgramDialog;
import jp.gr.java_conf.miya.pglauncher.utils.TreeUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Event;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AddProgramAction
extends AbstractAction {
    private TreeViewer viewer_;

    public AddProgramAction(TreeViewer viewer, ActionEventProvider provider) {
        super("\u30d7\u30ed\u30b0\u30e9\u30e0\u8ffd\u52a0", null, provider);
        this.viewer_ = viewer;
    }

    public void run() {
        ProgramDialog dialog = new ProgramDialog(this.viewer_.getControl().getShell());
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            Element el = TreeUtils.getSelectedElement(this.viewer_);
            Element newEl = null;
            if (dialog.isProgram()) {
                newEl = this._createProgramElement(dialog.getProgramName(), dialog.getPath(), dialog.getArg());
                el.appendChild(newEl);
            } else if (dialog.isFolder()) {
                newEl = this._createFolderElement(dialog.getProgramName(), dialog.getPath());
                el.appendChild(newEl);
            }
            this.viewer_.refresh();
            this.viewer_.setSelection((ISelection)new StructuredSelection((Object)newEl), true);
        }
    }

    public void doubleClick(Event event) {
    }

    public void rightClick(Event event) {
        Element el = TreeUtils.getSelectedElement(this.viewer_);
        String type = el.getNodeName();
        if (type.equals("pglauncher") || type.equals("group")) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    public void keyDown(Event event) {
    }

    private Element _createProgramElement(String name, String path, String arg) {
        Element el = ((Document)this.viewer_.getInput()).createElement("program");
        el.setAttribute("name", name);
        el.setAttribute("path", path);
        el.setAttribute("arg", arg);
        return el;
    }

    private Element _createFolderElement(String name, String path) {
        Element el = ((Document)this.viewer_.getInput()).createElement("folder");
        el.setAttribute("name", name);
        el.setAttribute("path", path);
        return el;
    }
}

