/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.miya.pglauncher.dialogs;

import java.util.ArrayList;
import jp.gr.java_conf.miya.pglauncher.actions.ActionEventProvider;
import jp.gr.java_conf.miya.pglauncher.actions.AddGroupAction;
import jp.gr.java_conf.miya.pglauncher.actions.AddProgramAction;
import jp.gr.java_conf.miya.pglauncher.actions.DeleteAction;
import jp.gr.java_conf.miya.pglauncher.actions.UpdateAction;
import jp.gr.java_conf.miya.pglauncher.dialogs.ProgramDragListener;
import jp.gr.java_conf.miya.pglauncher.dialogs.ProgramTransfer;
import jp.gr.java_conf.miya.pglauncher.dialogs.ProgramTreeDropAdapter;
import jp.gr.java_conf.miya.pglauncher.utils.ImageUtils;
import jp.gr.java_conf.miya.pglauncher.utils.XMLUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigDialog
extends TitleAreaDialog {
    private TreeViewer viewer_;
    private EventListener listener_;
    private ActionEventProvider provider_;

    public ConfigDialog(Shell parent) {
        super(parent);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("\u8a2d\u5b9a");
    }

    protected Point getInitialSize() {
        return new Point(400, 500);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(composite, 0);
        contents.setLayout((Layout)new GridLayout());
        contents.setLayoutData((Object)new GridData(1808));
        this._createTreeViewer(contents);
        this._initDragAndDrop();
        this.setMessage("\u30d7\u30ed\u30b0\u30e9\u30e0\u306e\u767b\u9332\u30fb\u4fee\u6b63\u30fb\u524a\u9664\u3092\u884c\u3044\u307e\u3059\u3002", 1);
        return composite;
    }

    protected void okPressed() {
        XMLUtils.getInstance().saveDocument((Document)this.viewer_.getInput());
        super.okPressed();
    }

    protected void cancelPressed() {
        this.viewer_.setInput((Object)XMLUtils.getInstance().loadDocument());
        super.cancelPressed();
    }

    private void _createTreeViewer(Composite parent) {
        this.viewer_ = new TreeViewer(parent, 2816);
        this.viewer_.setContentProvider((IContentProvider)new TreeContentProvider());
        this.viewer_.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.viewer_.setInput((Object)XMLUtils.getInstance().loadDocument());
        this.viewer_.getControl().setLayoutData((Object)new GridData(1808));
        this.provider_ = new ActionEventProvider();
        this._createMenu();
        this._addListener();
        this.viewer_.expandAll();
    }

    private void _initDragAndDrop() {
        int ops = 2;
        Transfer[] transfers = new Transfer[]{ProgramTransfer.getInstance()};
        this.viewer_.addDragSupport(ops, transfers, (DragSourceListener)new ProgramDragListener(this.viewer_));
        transfers = new Transfer[]{ProgramTransfer.getInstance()};
        ProgramTreeDropAdapter dropAdapter = new ProgramTreeDropAdapter(this.viewer_);
        this.viewer_.addDropSupport(ops, transfers, (DropTargetListener)dropAdapter);
    }

    private void _createMenu() {
        MenuManager menu = new MenuManager();
        this.viewer_.getTree().setMenu(menu.createContextMenu((Control)this.viewer_.getTree()));
        menu.add((IAction)new AddProgramAction(this.viewer_, this.provider_));
        menu.add((IAction)new AddGroupAction(this.viewer_, this.provider_));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)new UpdateAction(this.viewer_, this.provider_));
        menu.add((IAction)new DeleteAction(this.viewer_, this.provider_));
    }

    private void _addListener() {
        this.listener_ = new EventListener();
        this.viewer_.getTree().addListener(35, (Listener)this.listener_);
        this.viewer_.getTree().addListener(8, (Listener)this.listener_);
        this.viewer_.getTree().addListener(1, (Listener)this.listener_);
    }

    static class TreeContentProvider
    implements ITreeContentProvider {
        TreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return this.getChildrenNodeArray((Node)parentElement);
        }

        public Object getParent(Object element) {
            return ((Node)element).getParentNode();
        }

        public boolean hasChildren(Object element) {
            return ((Node)element).hasChildNodes();
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildrenNodeArray((Node)inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        private Node[] getChildrenNodeArray(Node node) {
            NodeList nodeList = node.getChildNodes();
            ArrayList<Node> validNodeList = new ArrayList<Node>();
            int i = 0;
            while (i < nodeList.getLength()) {
                if (nodeList.item(i).getNodeType() == 1) {
                    validNodeList.add(nodeList.item(i));
                }
                ++i;
            }
            return validNodeList.toArray(new Node[validNodeList.size()]);
        }
    }

    static class TreeLabelProvider
    extends LabelProvider {
        TreeLabelProvider() {
        }

        public String getText(Object element) {
            Node node = (Node)element;
            if (node.getNodeName().equals("pglauncher")) {
                return "PGLauncher";
            }
            NamedNodeMap map = ((Node)element).getAttributes();
            return map.getNamedItem("name").getNodeValue();
        }

        public Image getImage(Object element) {
            Node node = (Node)element;
            String name = node.getNodeName();
            if (name.equals("pglauncher")) {
                return ImageUtils.getImageFromIcon("pglauncher");
            }
            if (name.equals("folder")) {
                return ImageUtils.getImageFromIcon("folder");
            }
            if (name.equals("group")) {
                return ImageUtils.getImageFromIcon("group");
            }
            NamedNodeMap map = ((Node)element).getAttributes();
            String path = map.getNamedItem("path").getNodeValue();
            Image img = ImageUtils.getImageFromProgram(path);
            if (img == null) {
                String extension = path.substring(path.lastIndexOf(".") + 1);
                if (extension.equalsIgnoreCase("exe")) {
                    return ImageUtils.getImageFromIcon("exe");
                }
                return ImageUtils.getImageFromIcon("unknown");
            }
            return img;
        }
    }

    class EventListener
    implements Listener {
        EventListener() {
        }

        public void handleEvent(Event event) {
            ConfigDialog.this.provider_.handleEvent(event, ConfigDialog.this.viewer_);
        }
    }
}

