/*******************************************************************************
 * Copyright (C) 2018 OTK Software
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package com.otk.application;

import java.awt.Font;
import java.awt.Image;

import com.otk.application.resource.font.ClassInFontsPackage;
import com.otk.application.resource.image.ClassInImagesPackage;
import com.otk.application.util.ImageUtils;
import com.otk.application.util.TextUtils;

/**
 * This class holds various constants used in the application.
 * 
 * @author olitank
 *
 */
public class TheConstants {

	/**
	 * Image symbolizing "not found".
	 */
	public static final Image notFoundImage = ImageUtils
			.requireAdaptedImage(ClassInImagesPackage.class.getResourceAsStream("notFound.png"));

	/**
	 * Image symbolizing "camera device not found".
	 */
	public static final Image noCameraImage = ImageUtils
			.requireAdaptedImage(ClassInImagesPackage.class.getResourceAsStream("noCamera.png"));

	/**
	 * Face frame head shape image.
	 */
	public static final Image positioningRectangleHeadShapeImage = ImageUtils
			.requireAdaptedImage(ClassInImagesPackage.class.getResourceAsStream("positioningHeadShape.gif"));

	/**
	 * Face frame inner square image.
	 */
	public static final Image positioningRectangleYellowSquareImage = ImageUtils
			.requireAdaptedImage(ClassInImagesPackage.class.getResourceAsStream("positioningYellowSquare.gif"));

	/**
	 * Face frame ruler image.
	 */
	public static final Image positioningRectangleRulersImage = ImageUtils
			.requireAdaptedImage(ClassInImagesPackage.class.getResourceAsStream("positioningRulers.gif"));

	/**
	 * A font supposed to be easily readable.
	 */
	public static final Font readableFont = TextUtils
			.requireFont(ClassInFontsPackage.class.getResourceAsStream("fontReadable.ttf"));

}
