/*******************************************************************************
 * Copyright (C) 2018 OTK Software
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package com.otk.application.image.filter;

import com.otk.application.error.UnexpectedError;

public class BoxBlur extends AbstractBoxFilter {

	@Override
	protected int getComponentCount() {
		return 4;
	}

	@Override
	protected int getPrecomputedOutputValue(int sum, int count) {
		return Math.round(((float) sum) / ((float) count));
	}

	@Override
	protected int getComponentValueFromPixel(int pixel, int c) {
		switch (c) {
		case 0:
			return (pixel >> 16) & 0xff;
		case 1:
			return (pixel >> 8) & 0xff;
		case 2:
			return (pixel) & 0xff;
		case 3:
			return (pixel >> 24) & 0xff;
		default:
			throw new UnexpectedError();
		}
	}

	@Override
	protected int getPixelWithNewComponentValue(int pixel, int c, int value) {
		switch (c) {
		case 0:
			return (pixel & 0xff00ffff) | (value << 16);
		case 1:
			return (pixel & 0xffff00ff) | (value << 8);
		case 2:
			return (pixel & 0xffffff00) | (value);
		case 3:
			return (pixel & 0x00ffffff) | (value << 24);
		default:
			throw new UnexpectedError();
		}
	}

}
