/*******************************************************************************
 * Copyright (C) 2018 OTK Software
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package com.otk.application.util.draw;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

import com.otk.application.error.UnexpectedError;
import com.otk.application.util.ImageUtils;

public class DropShadow {

	public static final BufferedImage FRAME;
	static {
		try {
			FRAME = ImageUtils.loadAdaptedImage(DropShadow.class.getResourceAsStream("dropShadow.png"));
		} catch (Throwable t) {
			throw new UnexpectedError(t);
		}
	}

	public static BufferedImage add(BufferedImage image) {
		BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(),
				ImageUtils.getAdaptedBufferedImageType());
		Graphics2D g = result.createGraphics();
		ImageUtils.setSmoothScalingRenderingHints(g);
		drawWith(g, image, new Rectangle(0, 0, result.getWidth(), result.getHeight()));
		g.dispose();
		return result;
	}

	public static void drawWith(Graphics2D g, BufferedImage image, Rectangle bounds) {
		g.drawImage(FRAME, bounds.x, bounds.y, bounds.width, bounds.height, null);
		Rectangle innerArea = getInnerArea(bounds);
		g.drawImage(image, innerArea.x, innerArea.y, innerArea.width, innerArea.height, null);
	}

	public static Rectangle getInnerArea(Rectangle bounds) {
		int x = bounds.x + Math.round(bounds.width * 0.02f);
		int y = bounds.y + Math.round(bounds.height * 0.02f);
		int width = Math.round(bounds.width * 0.95f);
		int height = Math.round(bounds.height * 0.95f);
		return new Rectangle(x, y, width, height);
	}

}
