title: Tutorials

## How to use the Tutorial ## {#howto}

You should go through this tutorial in a linear fashion.
Chapter 1 deals with the installation of Musubi. 
The following chapters dive deeper into the most important features and 
should give a good impression of what can be done with Musubi, and how.

After installation of Musubi, you will find a `tutorial` folder inside 
your `musubi` folder. 
This folder contains complete configuration files for each chapter, so 
you have working examples of everything we are going to build in this 
tutorial.

## Overview ## {#tut_overview}

- [What you need before you can start using Musubi](tut_0_prerequisites.html)
- [Basic configuration of Musubi simulations](tut_1_mus_config.html)
- [Using the complete APES simulation tool-chain. Generation of Meshes, Running the solver and post-processing the results](tut_2_mus_toolchain.html)
  + [Tracking flow quantities during the simulation](tut_3_tracking.html)
  + [Setting Boundary Conditions](tut_4_boundaries.html)
  + [Setting Initial Conditions ( Equilibrium and Non-equilibrium )](tut_6_initial.html)
  + [Conditions for convergence and stopping the code in general](tut_7_convergence.html)
  + [Restarting Simulations](tut_5_restart.html)
  + [Force as a source term](tut_8_source.html)
- [Multilevel Simulations](tut_00_mus_multilevel.html)


## Required Knowledge ## {#requ_know}

We assume that you know how to install programs on your computer 
and how to use a console. 
Also, we assume that you have some basic idea of the Lattice Boltzmann
 Method (see [here](http://www.scholarpedia.org/article/Lattice_Boltzmann_Method)
or [here](http://en.wikipedia.org/wiki/Lattice_Boltzmann_methods)
for a brief description of it).

- Find requirements for building, running and visualizing  under
  

@note In the documentation for Treelm you will find a lot of useful information due to the fact Musubi is based upon the Treelm.

## Test cases  

We provide several test cases to practice your skills with the Apes suite. We are working at the tutorials at the moment.

- [Flow around a cylinder](FlowAroundCylinder/index.html)
- [Taylor Green Vortex](taylorgreen/index.html)
