title: Force as a source term

Navigate: [&larr; Setting up a Convergence Criterium](tut_7_convergence.html)
| [Overview](index.html)
| [Multilevel Simulations &rarr;](tut_00_mus_multilevel.html)

To define a force that affects the whole domain one uses the `source` table.

```
source = { force = 'myforce' }
```

* example

The force `myforce` has to be defined inside the `variable` table.
```lua
variable = {
  {
    ...
  },
  {
    name = 'myforce',
    ncomponents = 3,
    vartype = 'st_fun',
    st_fun = {
      predefined = 'combined',
      temporal = { predefined = 'cos' },
      spatial = { dp_dx * dx * dx * dx, 0.0, 0.0}
    } -- st_fun
  } -- 'myforce'
} -- variable
```

@note: `dp_dx` and `dx` are constants that are defined somewhere else.

This example is taken from the Womersley Flow test case which is located at:
```
>>musubi_folder<</testsuite/validation/womersley
```

Next chapter: [Multilevel Simulations &rarr;](tut_00_mus_multilevel.html)
